/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.ConditionalOnHostname;
import cz.polreich.spagetka.utils.HostUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

/*
 * Exception performing whole class analysis ignored.
 */
public class OnHostnameCondition
implements Condition {
    public boolean matches(ConditionContext ctx, AnnotatedTypeMetadata md) {
        Map attrs = md.getAnnotationAttributes(ConditionalOnHostname.class.getName());
        if (attrs == null) {
            return false;
        }
        String[] anyOf = attrs.getOrDefault("anyOf", new String[0]);
        String prop = attrs.getOrDefault("valuesFromProperty", "");
        boolean wild = attrs.getOrDefault("enableSimpleWildcards", true);
        LinkedHashSet allowed = new LinkedHashSet();
        Stream.of(anyOf).map(String::trim).filter(s -> !s.isEmpty()).forEach(allowed::add);
        if (!prop.isBlank()) {
            Environment env = ctx.getEnvironment();
            String raw = env.getProperty(prop, "");
            allowed.addAll(OnHostnameCondition.splitCandidates((String)raw));
        }
        if (allowed.isEmpty()) {
            return false;
        }
        String hostname = HostUtils.getHostnameShort();
        if (hostname == null || hostname.isBlank()) {
            return false;
        }
        String hostLower = hostname.toLowerCase(Locale.ROOT);
        return OnHostnameCondition.matchesAny(allowed, (String)hostLower, (boolean)wild);
    }

    private static List<String> splitCandidates(String raw) {
        if (raw == null) {
            return List.of();
        }
        String[] parts = raw.split("[,;\\s]+");
        ArrayList<String> out = new ArrayList<String>(parts.length);
        for (String p : parts) {
            String s = p.trim();
            if (s.isEmpty()) continue;
            out.add(s);
        }
        return out;
    }

    private static boolean matchesAny(Collection<String> allowed, String hostname, boolean wild) {
        for (String pattern : allowed) {
            Pattern regex = OnHostnameCondition.globToRegex((String)pattern.toLowerCase(Locale.ROOT), (boolean)wild);
            if (!regex.matcher(hostname).matches()) continue;
            return true;
        }
        return false;
    }

    private static Pattern globToRegex(String glob, boolean enable) {
        if (!enable || !glob.contains("*")) {
            return Pattern.compile(Pattern.quote(glob));
        }
        StringBuilder regex = new StringBuilder();
        for (char c : glob.toCharArray()) {
            if (c == '*') {
                regex.append(".*");
                continue;
            }
            regex.append(Pattern.quote(String.valueOf(c)));
        }
        return Pattern.compile(regex.toString());
    }
}

