/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.screensaver.resourceService;

import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.factory.ImageWrapperFactory;
import cz.polreich.spagetka.factory.MediaFactory;
import cz.polreich.spagetka.factory.MediaWrapperFactory;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.wrapper.ImageWrapper;
import cz.polreich.spagetka.models.wrapper.MediaWrapper;
import cz.polreich.spagetka.utils.ConditionalOnHostname;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.media.Media;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@ConditionalOnHostname(anyOf={"kioskOrder*"})
@Service
public class ScreensaverResourcesServiceFromResourcesFolder {
    private static final Logger log = LoggerFactory.getLogger(ScreensaverResourcesServiceFromResourcesFolder.class);
    private final String resourcesMediaFolder;
    private final String resourcesImageFolder;
    private PartnerServerRestClient partnerServerRestClient;
    private ImageWrapperFactory imageWrapperFactory;
    private MediaWrapperFactory mediaWrapperFactory;
    private ResourceHelper resourceHelper;
    private ImageFactory imageFactory;
    private MediaFactory mediaFactory;

    @Autowired
    public ScreensaverResourcesServiceFromResourcesFolder(Config config, ImageWrapperFactory imageWrapperFactory, MediaWrapperFactory mediaWrapperFactory, ResourceHelper resourceHelper) {
        this.resourcesImageFolder = config.getCustomer().getScreensaverConfig().getRelativeImagePath();
        this.resourcesMediaFolder = config.getCustomer().getScreensaverConfig().getRelativeMediaPath();
        this.imageWrapperFactory = imageWrapperFactory;
        this.mediaWrapperFactory = mediaWrapperFactory;
        this.resourceHelper = resourceHelper;
        this.cleanResources();
    }

    public List<ImageWrapper> getImageList() {
        ArrayList<ImageWrapper> imageList = new ArrayList<ImageWrapper>();
        List availableImagePaths = this.resourceHelper.getAvailableImagePaths(this.resourcesImageFolder);
        if (!availableImagePaths.isEmpty()) {
            for (String imagePath : availableImagePaths) {
                try {
                    Image i = (Image)this.imageFactory.create(imagePath).get();
                    imageList.add(this.imageWrapperFactory.create(this.createId(imagePath), i));
                    log.info("Created new Image with path - {}", (Object)imagePath);
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    log.error("Failed to load image from path: {}", (Object)imagePath, (Object)e);
                }
            }
        }
        return imageList;
    }

    public List<MediaWrapper> getMediaList() {
        List availableMediaPaths = this.resourceHelper.getAvailableMediaPaths(this.resourcesMediaFolder);
        ArrayList<MediaWrapper> mediaList = new ArrayList<MediaWrapper>();
        for (String mediaPath : availableMediaPaths) {
            Optional mediaOptional = this.mediaFactory.create(mediaPath);
            if (mediaOptional.isPresent()) {
                log.info("Created new Media with path - {}", (Object)mediaPath);
                MediaWrapper mediaWrapper = new MediaWrapper(this.createId(mediaPath), (Media)mediaOptional.get());
                mediaList.add(mediaWrapper);
                continue;
            }
            log.error("Appeared an issue in getting mp4 by path - {}", (Object)mediaPath);
        }
        return mediaList;
    }

    public ImageWrapper installImage(String url) {
        this.partnerServerRestClient.downloadResource(url, this.resourcesImageFolder.substring(1));
        StringBuilder imagePath = new StringBuilder().append(this.resourcesImageFolder).append("/").append(this.createId(url));
        Image image = (Image)this.imageFactory.create(imagePath.toString()).get();
        log.info("[INSTALL IMAGES] - Created new Image with path - {}", (Object)imagePath);
        return new ImageWrapper(this.createId(url), image);
    }

    public MediaWrapper installMedia(String url) {
        this.partnerServerRestClient.downloadResource(url, this.resourcesMediaFolder.substring(1));
        StringBuilder mediaPath = new StringBuilder().append(this.resourcesMediaFolder).append("/").append(this.createId(url));
        Media media = (Media)this.mediaFactory.create(mediaPath.toString()).get();
        log.info("Created new Image with path - {}", (Object)mediaPath);
        return new MediaWrapper(this.createId(url), media);
    }

    public boolean deleteImageFromResources(String url) {
        log.info("[Deleting an image from resources] - url - {}", (Object)url);
        StringBuilder imagePath = new StringBuilder().append(this.resourcesImageFolder).append("/").append(this.createId(url));
        return this.resourceHelper.deleteFile(imagePath.toString());
    }

    public boolean deleteMediaFromResources(String url) {
        StringBuilder mediaPath = new StringBuilder().append(this.resourcesMediaFolder).append("/").append(this.createId(url));
        return this.resourceHelper.deleteFile(mediaPath.toString());
    }

    public String createId(String path) {
        int lastSlash = path.lastIndexOf("/");
        if (lastSlash == -1) {
            return path;
        }
        return path.substring(lastSlash + 1);
    }

    private void cleanResources() {
        List availableImagePaths = this.resourceHelper.getAvailableImagePaths(this.resourcesImageFolder);
        for (String imagePath : availableImagePaths) {
            this.deleteImageFromResources(imagePath);
        }
        List availableMediaPaths = this.resourceHelper.getAvailableMediaPaths(this.resourcesMediaFolder);
        for (String mediaPath : availableMediaPaths) {
            this.deleteMediaFromResources(mediaPath);
        }
    }

    @Autowired
    public void setPartnerServerRestClient(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    @Autowired
    public void setMediaFactory(MediaFactory mediaFactory) {
        this.mediaFactory = mediaFactory;
    }
}

