/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.AttendanceLogItemDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.AttendanceLogItem;
import cz.polreich.spagetka.repository.AttendanceLogItemsRepository;
import java.time.LocalDateTime;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttendanceLogItemsService {
    @Autowired
    AttendanceLogItemsRepository attendanceLogItemsRepository;
    private PartnerServerRestClient partnerServerRestClient;

    public AttendanceLogItemsService() {
    }

    public AttendanceLogItemsService(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    public List<AttendanceLogItem> findAll() {
        return this.attendanceLogItemsRepository.findAll();
    }

    public AttendanceLogItem findById(String id) {
        return (AttendanceLogItem)this.attendanceLogItemsRepository.findById((Object)id).get();
    }

    public void saveAll(List<AttendanceLogItem> attendanceLogItems) {
        this.attendanceLogItemsRepository.saveAll(attendanceLogItems);
        new Thread(() -> this.partnerServerRestClient.sendAttendanceLogItems(attendanceLogItems.stream().map(AttendanceLogItemDTO::new).toList())).start();
    }

    public void save(AttendanceLogItem attendanceLogItem) {
        this.attendanceLogItemsRepository.save((Object)attendanceLogItem);
        new Thread(() -> this.partnerServerRestClient.sendAttendanceLogItem(new AttendanceLogItemDTO(attendanceLogItem))).start();
    }

    public boolean existsById(String id) {
        return this.attendanceLogItemsRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.attendanceLogItemsRepository.deleteById((Object)id);
    }

    public List<AttendanceLogItem> findAllFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<AttendanceLogItem> findAllToDateTime(LocalDateTime toDateTime) {
        return this.findAllInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<AttendanceLogItem> findAllInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.attendanceLogItemsRepository.findAttendanceItemsBetweenDateTimes(fromDateTime, toDateTime);
    }
}

