/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import com.fasterxml.jackson.annotation.JsonProperty;
import cz.polreich.spagetka.DTO.DeliveryAddressDTO;
import cz.polreich.spagetka.DTO.OrderItemDTO;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import java.util.ArrayList;
import java.util.List;

public class OrderDTO {
    private String id;
    private String customerFirstName;
    private String customerLastName;
    private String customerPhoneNumber;
    private int customerId;
    private String orderNumber;
    private String creationDateTime;
    private String toBeFinishedDateTime;
    private String orderType;
    private List<OrderItemDTO> orderItems = new ArrayList();
    private String orderStatus;
    private Double subTotalPrice;
    private Double discount;
    private String paymentMethod;
    private Double totalPrice;
    private Integer userConfirmedId;
    private Integer userFinishedId;
    @JsonProperty(value="discount_code")
    private String discountCode;
    @JsonProperty(value="custommer_description")
    private String customerDescription;
    private DeliveryAddressDTO deliveryAddress;
    private Double tipAmount;

    public OrderDTO(Order order) {
        this.id = order.getId();
        this.customerFirstName = order.getCustomerFirstName();
        this.customerLastName = order.getCustomerLastName();
        this.customerPhoneNumber = order.getCustomerPhoneNumber();
        this.customerId = order.getCustomerId();
        this.orderNumber = order.getOrderNumber();
        this.creationDateTime = String.valueOf(order.getCreationDateTime());
        this.toBeFinishedDateTime = String.valueOf(order.getToBeFinishedDateTime());
        this.orderType = String.valueOf(order.getOrderType());
        for (OrderItem item : order.getOrderItems()) {
            this.orderItems.add(new OrderItemDTO(item));
        }
        this.orderStatus = String.valueOf(order.getOrderStatus());
        this.subTotalPrice = order.getSubTotalPrice();
        this.discount = order.getDiscountPercentage();
        this.paymentMethod = String.valueOf(order.getPaymentMethod());
        this.totalPrice = order.getTotalPrice();
        this.userConfirmedId = order.getUserConfirmed() != null ? order.getUserConfirmed().getId() : -1;
        this.userFinishedId = order.getUserFinished() != null ? order.getUserFinished().getId() : -1;
        this.discountCode = order.getDiscountCode();
        this.customerDescription = order.getCustomerDescription();
        this.deliveryAddress = order.getDeliveryAddress() != null ? new DeliveryAddressDTO(order.getDeliveryAddress()) : null;
        this.tipAmount = order.getTip();
    }

    public String getId() {
        return this.id;
    }

    public String getCustomerFirstName() {
        return this.customerFirstName;
    }

    public String getCustomerLastName() {
        return this.customerLastName;
    }

    public String getCustomerPhoneNumber() {
        return this.customerPhoneNumber;
    }

    public int getCustomerId() {
        return this.customerId;
    }

    public String getOrderNumber() {
        return this.orderNumber;
    }

    public String getCreationDateTime() {
        return this.creationDateTime;
    }

    public String getToBeFinishedDateTime() {
        return this.toBeFinishedDateTime;
    }

    public String getOrderType() {
        return this.orderType;
    }

    public List<OrderItemDTO> getOrderItems() {
        return this.orderItems;
    }

    public String getOrderStatus() {
        return this.orderStatus;
    }

    public Double getSubTotalPrice() {
        return this.subTotalPrice;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public Double getTotalPrice() {
        return this.totalPrice;
    }

    public Integer getUserConfirmedId() {
        return this.userConfirmedId;
    }

    public Integer getUserFinishedId() {
        return this.userFinishedId;
    }

    public String getDiscountCode() {
        return this.discountCode;
    }

    public String getCustomerDescription() {
        return this.customerDescription;
    }

    public DeliveryAddressDTO getDeliveryAddress() {
        return this.deliveryAddress;
    }

    public Double getTipAmount() {
        return this.tipAmount;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCustomerFirstName(String customerFirstName) {
        this.customerFirstName = customerFirstName;
    }

    public void setCustomerLastName(String customerLastName) {
        this.customerLastName = customerLastName;
    }

    public void setCustomerPhoneNumber(String customerPhoneNumber) {
        this.customerPhoneNumber = customerPhoneNumber;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setCreationDateTime(String creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public void setToBeFinishedDateTime(String toBeFinishedDateTime) {
        this.toBeFinishedDateTime = toBeFinishedDateTime;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
    }

    public void setOrderItems(List<OrderItemDTO> orderItems) {
        this.orderItems = orderItems;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setSubTotalPrice(Double subTotalPrice) {
        this.subTotalPrice = subTotalPrice;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public void setUserConfirmedId(Integer userConfirmedId) {
        this.userConfirmedId = userConfirmedId;
    }

    public void setUserFinishedId(Integer userFinishedId) {
        this.userFinishedId = userFinishedId;
    }

    @JsonProperty(value="discount_code")
    public void setDiscountCode(String discountCode) {
        this.discountCode = discountCode;
    }

    @JsonProperty(value="custommer_description")
    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public void setDeliveryAddress(DeliveryAddressDTO deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public void setTipAmount(Double tipAmount) {
        this.tipAmount = tipAmount;
    }

    public OrderDTO() {
    }

    public OrderDTO(String id, String customerFirstName, String customerLastName, String customerPhoneNumber, int customerId, String orderNumber, String creationDateTime, String toBeFinishedDateTime, String orderType, List<OrderItemDTO> orderItems, String orderStatus, Double subTotalPrice, Double discount, String paymentMethod, Double totalPrice, Integer userConfirmedId, Integer userFinishedId, String discountCode, String customerDescription, DeliveryAddressDTO deliveryAddress, Double tipAmount) {
        this.id = id;
        this.customerFirstName = customerFirstName;
        this.customerLastName = customerLastName;
        this.customerPhoneNumber = customerPhoneNumber;
        this.customerId = customerId;
        this.orderNumber = orderNumber;
        this.creationDateTime = creationDateTime;
        this.toBeFinishedDateTime = toBeFinishedDateTime;
        this.orderType = orderType;
        this.orderItems = orderItems;
        this.orderStatus = orderStatus;
        this.subTotalPrice = subTotalPrice;
        this.discount = discount;
        this.paymentMethod = paymentMethod;
        this.totalPrice = totalPrice;
        this.userConfirmedId = userConfirmedId;
        this.userFinishedId = userFinishedId;
        this.discountCode = discountCode;
        this.customerDescription = customerDescription;
        this.deliveryAddress = deliveryAddress;
        this.tipAmount = tipAmount;
    }
}

