/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils.appmetadata;

import cz.polreich.spagetka.utils.ExceptionHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AppMetadataUtil {
    private static final Logger log = LoggerFactory.getLogger(AppMetadataUtil.class);
    private static final String UNKNOWN = "unknown";
    private static final String appName;
    private static final String appVersionFull;
    private static final String appVersionNumber;

    private static String getJarName() {
        try {
            String uri = AppMetadataUtil.class.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            String jarPath = uri.contains("jar:nested:") ? System.getProperty("java.class.path") : uri;
            log.info("JAR Path : " + jarPath);
            if (jarPath != null) {
                return jarPath.substring(jarPath.lastIndexOf("/") + 1);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        return null;
    }

    private static String[] parseJarName(String jarName) {
        String name = "unknown";
        String fullVersion = "unknown";
        if (jarName != null && jarName.endsWith(".jar")) {
            String baseName = jarName.substring(0, jarName.length() - 4);
            Pattern pattern = Pattern.compile("^(.+)-([\\d.]+(?:-[A-Z]+)?)(?:-.+)?$");
            Matcher matcher = pattern.matcher(baseName);
            if (matcher.matches()) {
                name = matcher.group(1);
                fullVersion = matcher.group(2);
            }
        }
        return new String[]{name, fullVersion};
    }

    private static String extractVersionNumber(String fullVersion) {
        if (fullVersion == null || fullVersion.equals("unknown")) {
            return "unknown";
        }
        Matcher matcher = Pattern.compile("^([\\d.]+)").matcher(fullVersion);
        return matcher.find() ? matcher.group(1) : "unknown";
    }

    static String[] parseJarNameForTesting(String jarName) {
        return AppMetadataUtil.parseJarName((String)jarName);
    }

    static String extractVersionNumberForTesting(String fullVersion) {
        return AppMetadataUtil.extractVersionNumber((String)fullVersion);
    }

    public static String getAppName() {
        return appName;
    }

    public static String getAppVersionFull() {
        return appVersionFull;
    }

    public static String getAppVersionNumber() {
        return appVersionNumber;
    }

    static {
        String jarName = AppMetadataUtil.getJarName();
        if (jarName == null || !jarName.contains(".jar")) {
            appName = "unknown";
            appVersionFull = "unknown";
            appVersionNumber = "unknown";
        } else {
            String[] parsed = AppMetadataUtil.parseJarName((String)jarName);
            appName = parsed[0];
            appVersionFull = parsed[1];
            appVersionNumber = AppMetadataUtil.extractVersionNumber((String)appVersionFull);
        }
    }
}

