/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateResponse;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.VatAmount;
import cz.polreich.spagetka.models.config.PrinterConfig;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.utils.BigDecimalUtils;
import cz.polreich.spagetka.utils.BytePrinter;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LabeledEnumHelper;
import cz.polreich.spagetka.utils.ResourceHelper;
import io.nayuki.qrcodegen.QrCode;
import java.awt.image.BufferedImage;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HexFormat;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.print.PrintService;

/*
 * Exception performing whole class analysis ignored.
 */
public class ReceiptPrinter
extends BytePrinter {
    private int characters = 37;
    private static final byte HT = 9;
    private static final byte LF = 10;
    private static final byte FF = 12;
    private static final byte CR = 13;
    private static final byte DC1 = 17;
    private static final byte DC2 = 18;
    private static final byte DC3 = 19;
    private static final byte CAN = 24;
    private static final byte ESC = 27;
    private static final byte FS = 28;
    private static final byte GS = 29;
    private static final byte SP = 32;
    private static final ResourceHelper resourceHelper = new ResourceHelper();

    public static byte[] lineSeparator(int charSize, String character, String encoding, int characters) {
        String s = switch (charSize) {
            case 0 -> character.repeat(characters);
            case 1 -> character.repeat(characters - 22);
            case 2 -> character.repeat(characters - 4);
            default -> character.repeat(5);
        };
        try {
            return s.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            ExceptionHandler.logException((Exception)e);
            return new byte[0];
        }
    }

    public static byte[] carriageReturn() {
        return new byte[]{13};
    }

    public static byte[] lineFeed() {
        return new byte[]{10};
    }

    public static byte[] pageLengthPrinting() {
        return new byte[]{12};
    }

    public static byte[] setPageLength(int value) {
        return new byte[]{27, 67, (byte)value};
    }

    public static byte[] printingAndFeedForward(int value) {
        return new byte[]{27, 74, (byte)value};
    }

    public static byte[] printingAndBackFeed(int value) {
        return new byte[]{27, 106, (byte)value};
    }

    public static byte[] printingAndConsecutiveLineFeed(int value) {
        return new byte[]{27, 100, (byte)value};
    }

    public static byte[] horizontalTab() {
        return new byte[]{9};
    }

    public static byte[] setHorizontalTab(int value) {
        return new byte[]{27, 68, (byte)value};
    }

    public static byte[] setInitialLinefeedValue(int value) {
        return new byte[]{27, 2, (byte)value};
    }

    public static byte[] setLinefeedValue(int value) {
        return new byte[]{27, 3, (byte)value};
    }

    public static byte[] setRightMargin(int value) {
        return new byte[]{27, 32, (byte)value};
    }

    public static byte[] setLeftMargin(int value) {
        return new byte[]{29, 76, (byte)value};
    }

    public static byte[] setPrintingAreaWidth(int value) {
        return new byte[]{29, 87, (byte)value};
    }

    public static byte[] setAbsolutePositionOfPrintingArea(int value) {
        return new byte[]{27, 36, (byte)value};
    }

    public static byte[] alignPosition(int value) {
        return new byte[]{27, 97, (byte)value};
    }

    public static byte[] alignToLeft() {
        return ReceiptPrinter.alignPosition((int)0);
    }

    public static byte[] alignToCenter() {
        return ReceiptPrinter.alignPosition((int)1);
    }

    public static byte[] alignToRight() {
        return ReceiptPrinter.alignPosition((int)2);
    }

    public static byte[] specifyBoldCharacter(int value) {
        return new byte[]{27, 71, (byte)value};
    }

    public static byte[] setBoldText() {
        return ReceiptPrinter.specifyBoldCharacter((int)1);
    }

    public static byte[] cancelBoldText() {
        return ReceiptPrinter.specifyBoldCharacter((int)0);
    }

    public static byte[] specifyInversePrinting(int value) {
        return new byte[]{27, 123, (byte)value};
    }

    public static byte[] setInversePrinting() {
        return ReceiptPrinter.specifyInversePrinting((int)1);
    }

    public static byte[] cancelInversePrinting() {
        return ReceiptPrinter.specifyInversePrinting((int)0);
    }

    public static byte[] specifyUnderlinePrinting(int value) {
        return new byte[]{27, 45, (byte)value};
    }

    public static byte[] setUnderlinePrinting() {
        return ReceiptPrinter.specifyUnderlinePrinting((int)1);
    }

    public static byte[] cancelUnderlinePrinting() {
        return ReceiptPrinter.specifyUnderlinePrinting((int)0);
    }

    public static byte[] setCharacterSize(int width, int height) {
        int size = width << 4 | height;
        return new byte[]{29, 33, (byte)size};
    }

    public static byte[] specifyBlackAndWhiteReversePrinting(int value) {
        return new byte[]{29, 66, (byte)value};
    }

    public static byte[] setBlackAndWhiteReversePrinting() {
        return ReceiptPrinter.specifyBlackAndWhiteReversePrinting((int)1);
    }

    public static byte[] cancelBlackAndWhiteReversePrinting() {
        return ReceiptPrinter.specifyBlackAndWhiteReversePrinting((int)0);
    }

    public static byte[] specifySmoothingFont(int value) {
        return new byte[]{29, 98, (byte)value};
    }

    public static byte[] setSmoothingFont() {
        return ReceiptPrinter.specifySmoothingFont((int)1);
    }

    public static byte[] cancelSmoothingFont() {
        return ReceiptPrinter.specifySmoothingFont((int)0);
    }

    public static byte[] getGraphicLogo() {
        return new byte[]{27, -6, 1, 0, 10, 0, -56};
    }

    public static byte[] partialCut() {
        return new byte[]{27, 109};
    }

    public static byte[] fullCut() {
        return new byte[]{27, 105};
    }

    public static byte[] setPrintDensity(int value) {
        return new byte[]{29, 40, 75, 2, 0, 49, (byte)value};
    }

    public static byte[] setPrintSpeed(int value) {
        return new byte[]{29, 40, 75, 2, 0, 50, (byte)value};
    }

    public static byte[] barcodeCode128() {
        return new byte[]{29, 107, 73};
    }

    public static byte[] code128CodeA() {
        return new byte[]{123, 65};
    }

    public static byte[] code128CodeB() {
        return new byte[]{123, 66};
    }

    public static byte[] code128CodeC() {
        return new byte[]{123, 67};
    }

    public static byte[] getPaperEndAlertBytes(boolean enable) {
        boolean n = false;
        if (enable) {
            n = true;
        }
        return new byte[]{31, 27, 17, 18, 17, 8, (byte)(n ? 1 : 0)};
    }

    public static byte[] getFixCutterBytes() {
        return new byte[]{31, 27, 17, 18, 16, 17, 6};
    }

    public static byte[] getEncodingBytes(String encoding) {
        int codePage = 0;
        if (encoding.equals("CP1250") || encoding.equals("WPC1250")) {
            codePage = 50;
        } else if (encoding.equals("CP852") || encoding.equals("PC852")) {
            codePage = 32;
        }
        return new byte[]{31, 27, 31, -1, (byte)codePage};
    }

    public ReceiptPrinter() {
    }

    public ReceiptPrinter(PrintService printService) {
        this.setPrintService(printService);
    }

    public static void setPrinterEncoding(String printerName, String encoding) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding)});
    }

    public static void setPaperEndAlarm(String printerName, boolean enable) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getPaperEndAlertBytes((boolean)enable)});
    }

    public static void fixCutter(String printerName) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getFixCutterBytes()});
    }

    public static void printDiscountCode(String printerName, String code, LocalDateTime dateTime, String logoFileName, String encoding) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        BufferedImage logo = null;
        try {
            logo = ImageIO.read(resourceHelper.getImageAsStream("/resources/images/" + logoFileName));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)logo), ReceiptPrinter.setCharacterSize((int)1, (int)2), ReceiptPrinter.alignToCenter(), ReceiptPrinter.getBytesForString((String)"V\u00e1\u0161 slevov\u00fd k\u00f3d:", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)code, (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)1), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Platnost kon\u010d\u00ed " + dateTime.format(formatter)), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.partialCut()});
    }

    public static void printExpirationDate(String printerName, LocalDateTime creationDate, StockItem pastaStockItem, String encoding, LocalDateTime expirationDate) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)1), ReceiptPrinter.alignToCenter(), ReceiptPrinter.getBytesForString((String)("Vyrobeno: " + creationDate.format(dateFormatter)), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Expiruje: " + expirationDate.format(dateFormatter)), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.alignToCenter(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)ReceiptPrinter.generateQrcode((String)pastaStockItem.getQrcode())), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.partialCut()});
    }

    public static void printNewOrderNotification(Order order, String printerName, int characters, String encoding) {
        System.out.println(ReceiptPrinter.getPrinters());
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)1), ReceiptPrinter.getBytesForString((String)"Nov\u00e1 objedn\u00e1vka", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)7, (int)7), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)order.getOrderNumber(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.alignToCenter(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)ReceiptPrinter.generateQrcode((String)order.getId())), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)0, (int)1), ReceiptPrinter.getPaymentMethodBytes((Order)order, (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getOrderTypeBytes((Order)order, (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.partialCut()});
    }

    public static byte[] getPaymentMethodBytes(Order order, String encoding) {
        return ReceiptPrinter.getBytesForString((String)("Platba: " + LabeledEnumHelper.getLabel((Enum)order.getPaymentMethod())), (String)encoding);
    }

    public static byte[] getOrderTypeBytes(Order order, String encoding) {
        return ReceiptPrinter.getBytesForString((String)("Typ: " + LabeledEnumHelper.getLabel((Enum)order.getOrderType())), (String)encoding);
    }

    public static byte[] getOrderNumberBytes(Order order, List<String> header, KioskInfo kioskInfo, String logoFileName, boolean cutAfterPrint, int characters, String encoding) {
        byte[] ret = new byte[]{};
        BufferedImage logo = null;
        try {
            logo = ImageIO.read(resourceHelper.getImageAsStream("/resources/images/" + logoFileName));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        ret = order.getPaymentMethod().equals((Object)PAYMENT_METHOD.CASH) ? ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)logo), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForReceiptHeader(header, (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)"\u010c\u00edslo objedn\u00e1vky:", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)7, (int)7), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)order.getOrderNumber(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Provozovna: " + kioskInfo.getKioskId()), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)order.getCreationDateTime().toString(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)"Va\u0161e objedn\u00e1vka je\u0161t\u011b nen\u00ed zaplacena", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)2), ReceiptPrinter.getBytesForString((String)"Zapla\u0165te u obsluhy.", (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)ReceiptPrinter.generateQrcode((String)order.getId())), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), cutAfterPrint ? ReceiptPrinter.partialCut() : new byte[]{}}) : ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)"\u010c\u00edslo objedn\u00e1vky:", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)7, (int)7), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)order.getOrderNumber(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)0), ReceiptPrinter.getBytesForString((String)("Provozovna: " + kioskInfo.getKioskId()), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)FormatUtils.formatDateTime((LocalDateTime)order.getCreationDateTime()), (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), cutAfterPrint ? ReceiptPrinter.partialCut() : new byte[]{}});
        return ret;
    }

    public static void printOrderNumber(byte[] data, String printerName) {
        System.out.println(ReceiptPrinter.getPrinters());
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{data});
    }

    public static void printReceipt(Receipt receipt, String printerName, KioskInfo kioskInfo, String logoFileName, int characters, String encoding, byte[] orderNumberData) {
        boolean isForInvoice = PAYMENT_METHOD.INVOICE.equals((Object)receipt.getPaymentMethod());
        System.out.println(ReceiptPrinter.getPrinters());
        PrintService printService = ReceiptPrinter.findPrintService((String)printerName);
        BufferedImage logo = null;
        try {
            logo = ImageIO.read(resourceHelper.getImageAsStream("/resources/images/" + logoFileName));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        if (receipt.getTip() != null && receipt.getTip() > 0.0) {
            ArrayList<ReceiptItem> newItems = new ArrayList<ReceiptItem>(receipt.getReceiptItems());
            ReceiptItem tipItem = new ReceiptItem();
            tipItem.setTitle("Spropitn\u00e9");
            tipItem.setQuantity(1);
            tipItem.setUnitPrice(BigDecimal.valueOf(receipt.getTip()));
            tipItem.setVatPercent(Double.valueOf(0.0));
            tipItem.setTotalPrice(BigDecimal.valueOf(receipt.getTip()));
            newItems.add(tipItem);
            receipt.setReceiptItems(newItems);
        }
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), orderNumberData, ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.alignToCenter(), ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getReceiptTitle((boolean)isForInvoice), (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)logo), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForReceiptHeader((List)receipt.getHeader(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.alignToLeft(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Datum a \u010das: ", (String)FormatUtils.formatDateTime((LocalDateTime)receipt.getDateTime()), (int)characters), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Provozovna: ", (String)(kioskInfo.getKioskId() + " - " + kioskInfo.getName()), (int)characters), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Objedn\u00e1vka: " + receipt.getOrderId()), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("\u010c. dokladu: " + receipt.getId()), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.printDeliveryDetails((Receipt)receipt, (String)encoding, (int)characters), ReceiptPrinter.alignToLeft(), ReceiptPrinter.getBytesForReceiptItems((List)receipt.getReceiptItems(), (String)encoding, (int)characters), ReceiptPrinter.getDiscountBytes((Receipt)receipt, (String)encoding, (int)characters), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForVatSummary((Receipt)receipt, (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForSumRow((Receipt)receipt, (String)encoding, (int)characters), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForString((String)receipt.getNote(), (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)ReceiptPrinter.generateQrcode((String)receipt.getOrderId())), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)receipt.getFooter(), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.partialCut()});
        System.out.println("Done");
    }

    private static byte[] printDeliveryDetails(Receipt receipt, String encoding, int characters) {
        byte[] ret = new byte[]{};
        Order order = receipt.getOrder();
        if (order != null && ORDER_TYPE.DELIVERY.equals((Object)order.getOrderType())) {
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.alignToCenter(), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForString((String)"ROZVOZ", (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.alignToLeft(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Jm\u00e9no: ", (String)order.getCustomerFullName(), (int)characters), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Telefon: ", (String)order.getCustomerPhoneNumber(), (int)characters), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Adresa: ", (String)order.getDeliveryAddress().toString(), (int)characters), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"=", (String)encoding, (int)characters), ReceiptPrinter.lineFeed()});
        }
        return ret;
    }

    public static byte[] getDiscountBytes(Receipt receipt, String encoding, int characters) {
        if (BigDecimalUtils.isLessThanOrEqualTo((BigDecimal)receipt.getDiscount(), (int)0)) {
            return new byte[0];
        }
        return ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getLabelAndValue((String)"Sleva: ", (String)("-" + FormatUtils.formatCurrencyForceDecimal((BigDecimal)receipt.getDiscount())), (int)characters), (String)encoding), ReceiptPrinter.lineFeed()});
    }

    public static BufferedImage generateQrcode(String barcodeText) {
        return ReceiptPrinter.generateQrcode((String)barcodeText, (int)5, (int)4);
    }

    public static BufferedImage generateQrcode(String barcodeText, int scale, int border) {
        QrCode qrCode = QrCode.encodeText((CharSequence)barcodeText, (QrCode.Ecc)QrCode.Ecc.MEDIUM);
        BufferedImage img = ReceiptPrinter.toImage((QrCode)qrCode, (int)scale, (int)border);
        return img;
    }

    public static BufferedImage toImage(QrCode qr, int scale, int border) {
        return ReceiptPrinter.toImage((QrCode)qr, (int)scale, (int)border, (int)0xFFFFFF, (int)0);
    }

    public static BufferedImage toImage(QrCode qr, int scale, int border, int lightColor, int darkColor) {
        Objects.requireNonNull(qr);
        if (scale <= 0 || border < 0) {
            throw new IllegalArgumentException("Value out of range");
        }
        if (border > 0x3FFFFFFF || (long)qr.size + (long)border * 2L > (long)(Integer.MAX_VALUE / scale)) {
            throw new IllegalArgumentException("Scale or border too large");
        }
        BufferedImage result = new BufferedImage((qr.size + border * 2) * scale, (qr.size + border * 2) * scale, 1);
        for (int y = 0; y < result.getHeight(); ++y) {
            for (int x = 0; x < result.getWidth(); ++x) {
                boolean color = qr.getModule(x / scale - border, y / scale - border);
                result.setRGB(x, y, color ? darkColor : lightColor);
            }
        }
        return result;
    }

    private static byte[] getBytesForSumRow(Receipt receipt, String encoding, int characters) {
        characters /= 2;
        if (receipt.getPaymentMethod().equals((Object)PAYMENT_METHOD.CASH)) {
            String roundString = ReceiptPrinter.getLabelAndValue((String)"Zaokrouhlen\u00ed: ", (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)receipt.getRounding(), (String)"K\u010d"), (int)characters);
            String priceString = ReceiptPrinter.getLabelAndValue((String)"SUMA: ", (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)receipt.getTotalAmountAfterRounding(), (String)"K\u010d"), (int)characters);
            return ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.getBytesForString((String)roundString, (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForString((String)priceString, (String)encoding)});
        }
        String priceString = ReceiptPrinter.getLabelAndValue((String)"SUMA: ", (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)receipt.getTotalAmount(), (String)"K\u010d"), (int)characters);
        return ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.setCharacterSize((int)1, (int)1), ReceiptPrinter.getBytesForString((String)priceString, (String)encoding)});
    }

    public static String getSpacesForText(int totalLength, String text) {
        return " ".repeat(Math.max(totalLength - text.length(), 0)) + text;
    }

    public static String getLabelAndValue(String beforeText, String afterText, int characters) {
        return beforeText + ReceiptPrinter.getSpacesForText((int)(characters - beforeText.length()), (String)afterText);
    }

    public static String getSpacesForText(int totalLength, Double text) {
        return ReceiptPrinter.getSpacesForText((int)totalLength, (String)String.valueOf(text));
    }

    private static String getReceiptTitle(boolean isForInvoice) {
        String text = "Potvrzen\u00ed o platb\u011b\n";
        if (isForInvoice) {
            text = "Shrnut\u00ed objedn\u00e1vky\n";
        }
        return text;
    }

    private static String[] getItemListHeader(int characters) {
        String[] labels = new String[4];
        if (characters >= 27) {
            labels[0] = "po\u010det";
            labels[1] = "jedn.cena";
            labels[2] = "sazba DPH";
            labels[3] = "cena";
        } else if (characters >= 26) {
            labels[0] = "po\u010det";
            labels[1] = "jedn.cena";
            labels[2] = "sazbaDPH";
            labels[3] = "cena";
        } else {
            labels[0] = "po\u010d";
            labels[1] = "j.cena";
            labels[2] = "s.DPH";
            labels[3] = "cena";
        }
        return ReceiptPrinter.evenlySpreadSpacesForLabels((String[])labels, (int)characters);
    }

    private static String[] evenlySpreadSpacesForLabels(String[] labels, int characters) {
        double labelsSum = Arrays.stream(labels).mapToDouble(String::length).sum();
        double spacesTotal = (double)characters - labelsSum;
        int spacesEach = (int)(spacesTotal / (double)(labels.length - 1));
        int remainder = (int)(spacesTotal % (double)(labels.length - 1));
        if (spacesEach > 0) {
            for (int i = 1; i < labels.length; ++i) {
                labels[i] = i == labels.length - 1 ? " ".repeat(spacesEach + remainder) + labels[i] : " ".repeat(spacesEach) + labels[i];
            }
        }
        return labels;
    }

    private static byte[] getBytesForReceiptHeader(List<String> header, String encoding) {
        return ReceiptPrinter.getBytesForString((String)header.stream().filter(s -> s != null && !s.trim().isEmpty()).collect(Collectors.joining("\n")), (String)encoding);
    }

    private static int[][] getPixelsFast(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] result = new int[height][width];
        int[] pixelRow = new int[width];
        for (int row = 0; row < height; ++row) {
            image.getRGB(0, row, width, 1, pixelRow, 0, width);
            result[row] = (int[])pixelRow.clone();
        }
        return result;
    }

    public static void printGiftVoucherCode(PrinterConfig printerConfig, DiscountCodeCreateResponse response, double amount) {
        LocalDateTime dateTime = LocalDateTime.parse(response.getValidUntil(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String code = response.getDiscountCode();
        ReceiptPrinter.printGiftVoucherCode((PrinterConfig)printerConfig, (String)code, (LocalDateTime)dateTime, (double)amount);
    }

    public static void printGiftVoucherCode(PrinterConfig printerConfig, String code, LocalDateTime dateTime, double amount) {
        PrintService printService = ReceiptPrinter.findPrintService((String)printerConfig.getPrinterName());
        String encoding = printerConfig.getCodepage();
        ReceiptPrinter receiptPrinter = new ReceiptPrinter(printService);
        BufferedImage logo = null;
        try {
            logo = ImageIO.read(resourceHelper.getImageAsStream("/resources/images/" + printerConfig.getLogoImageName()));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm");
        receiptPrinter.printBytes((byte[][])new byte[][]{ReceiptPrinter.getEncodingBytes((String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)0), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForRasterImage((BufferedImage)logo), ReceiptPrinter.setCharacterSize((int)1, (int)2), ReceiptPrinter.alignToCenter(), ReceiptPrinter.getBytesForString((String)"D\u00e1rkov\u00fd poukaz:", (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)code, (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Hodnota: " + FormatUtils.formatCurrency((double)amount)), (String)encoding), ReceiptPrinter.setCharacterSize((int)0, (int)1), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.getBytesForString((String)("Platnost kon\u010d\u00ed " + dateTime.format(formatter)), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed(), ReceiptPrinter.partialCut()});
    }

    public void printRasterImage(BufferedImage image) {
        int[][] pixels = ReceiptPrinter.getPixelsFast((BufferedImage)image);
        byte[] escPosCommand = new byte[]{27, 42, 33};
        byte[] setLineSpacing24 = new byte[]{27, 51, 24};
        byte[] setLineSpacing30 = new byte[]{27, 51, 30};
        this.printBytes((byte[][])new byte[][]{setLineSpacing24});
        byte[] ret = new byte[]{};
        for (int y = 0; y < pixels.length; y += 24) {
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, escPosCommand});
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, {(byte)(0xFF & pixels[y].length), (byte)((0xFF00 & pixels[y].length) >> 8)}});
            for (int x = 0; x < pixels[y].length; ++x) {
                ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.recollectSlice((int)y, (int)x, (int[][])pixels)});
            }
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.lineFeed()});
        }
        this.printBytes((byte[][])new byte[][]{ret});
        this.printBytes((byte[][])new byte[][]{setLineSpacing30});
    }

    public static byte[] getBytesForRasterImage(BufferedImage image) {
        if (image == null) {
            return new byte[0];
        }
        int[][] pixels = ReceiptPrinter.getPixelsFast((BufferedImage)image);
        byte[] escPosCommand = new byte[]{27, 42, 33};
        byte[] setLineSpacing24 = new byte[]{27, 51, 24};
        byte[] setLineSpacing30 = new byte[]{27, 51, 30};
        byte[] ret = new byte[]{};
        ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, setLineSpacing24});
        for (int y = 0; y < pixels.length; y += 24) {
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, escPosCommand});
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, {(byte)(0xFF & pixels[y].length), (byte)((0xFF00 & pixels[y].length) >> 8)}});
            for (int x = 0; x < pixels[y].length; ++x) {
                ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.recollectSlice((int)y, (int)x, (int[][])pixels)});
            }
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.lineFeed()});
        }
        ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, setLineSpacing30});
        return ret;
    }

    private static byte[] recollectSlice(int y, int x, int[][] img) {
        byte[] slices = new byte[]{0, 0, 0};
        int imgLength = img.length;
        int yy = y;
        for (int i = 0; yy < y + 24 && i < 3; yy += 8, ++i) {
            byte slice = 0;
            for (int b = 0; b < 8; ++b) {
                int yyy = yy + b;
                if (yyy >= imgLength) continue;
                int col = img[yyy][x];
                slice = (byte)(slice | (byte)((ReceiptPrinter.shouldPrintColor((int)col) ? 1 : 0) << 7 - b));
            }
            slices[i] = slice;
        }
        return slices;
    }

    private static boolean shouldPrintColor(int col) {
        int threshold = 127;
        int r = col >> 16 & 0xFF;
        int g = col >> 8 & 0xFF;
        int b = col & 0xFF;
        int luminance = (int)(0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b);
        return (col & 0xFF000000) == -16777216 && luminance < 127;
    }

    public static byte[] getBytesForReceiptItem(ReceiptItem receiptItem, String encoding, String[] labels) {
        byte[] title = ReceiptPrinter.getBytesForString((String)receiptItem.getTitle(), (String)encoding);
        byte[] quantity = ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getSpacesForText((int)labels[0].length(), (String)(receiptItem.getQuantity() + " x")), (String)encoding);
        byte[] unitPrice = ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getSpacesForText((int)labels[1].length(), (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)receiptItem.getUnitPrice())), (String)encoding);
        byte[] vatPercent = ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getSpacesForText((int)labels[2].length(), (String)(FormatUtils.formatOneDecimalForce((double)receiptItem.getVatPercent()) + " %")), (String)encoding);
        byte[] totalPrice = ReceiptPrinter.getBytesForString((String)ReceiptPrinter.getSpacesForText((int)labels[3].length(), (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)receiptItem.getTotalPrice())), (String)encoding);
        byte[] addProducts = ReceiptPrinter.lineFeed();
        byte[] ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.setBoldText(), title, ReceiptPrinter.cancelBoldText(), ReceiptPrinter.lineFeed()});
        if (!receiptItem.getSubItems().isEmpty()) {
            for (ReceiptItem subItem : receiptItem.getSubItems()) {
                addProducts = ReceiptPrinter.appendArrays((byte[][])new byte[][]{addProducts, ReceiptPrinter.getBytesForReceiptItem((ReceiptItem)subItem, (String)encoding, (String[])labels)});
            }
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, addProducts, ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed()});
        } else {
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, quantity, unitPrice, vatPercent, totalPrice, ReceiptPrinter.lineFeed(), ReceiptPrinter.lineFeed()});
        }
        return ret;
    }

    public static byte[] getBytesForVatSummary(Receipt receipt, String encoding, int characters) {
        String[] labels = new String[4];
        if (characters >= 21) {
            labels[0] = "Sazba";
            labels[1] = "bez DPH";
            labels[2] = "DPH";
            labels[3] = "Celkem";
        } else if (characters >= 20) {
            labels[0] = "Sazba";
            labels[1] = "bezDPH";
            labels[2] = "DPH";
            labels[3] = "Celkem";
        } else {
            labels[0] = "S%";
            labels[1] = "bezD";
            labels[2] = "D";
            labels[3] = "Celk";
        }
        String header = String.join((CharSequence)"", ReceiptPrinter.evenlySpreadSpacesForLabels((String[])labels, (int)characters));
        byte[] ret = ReceiptPrinter.getBytesForString((String)header, (String)encoding);
        for (VatAmount vatAmount : receipt.getVatAmounts()) {
            String percentString = ReceiptPrinter.getSpacesForText((int)labels[0].length(), (String)(FormatUtils.formatOneDecimalForce((double)vatAmount.getVatPercent()) + "%"));
            String baseAmountString = ReceiptPrinter.getSpacesForText((int)labels[1].length(), (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)vatAmount.getBaseAmount()));
            String vatAmountString = ReceiptPrinter.getSpacesForText((int)labels[2].length(), (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)vatAmount.getVatAmount()));
            String totalAmountString = ReceiptPrinter.getSpacesForText((int)labels[3].length(), (String)FormatUtils.formatCurrencyForceDecimal((BigDecimal)vatAmount.getTotalAmount()));
            byte[] row = ReceiptPrinter.getBytesForString((String)(percentString + baseAmountString + vatAmountString + totalAmountString), (String)encoding);
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, row});
        }
        return ret;
    }

    public static byte[] getBytesForReceiptItems(List<ReceiptItem> receiptItems, String encoding, int characters) {
        CharSequence[] labels = ReceiptPrinter.getItemListHeader((int)characters);
        byte[] ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ReceiptPrinter.getBytesForString((String)String.join((CharSequence)"", labels), (String)encoding), ReceiptPrinter.lineFeed(), ReceiptPrinter.lineSeparator((int)0, (String)"-", (String)encoding, (int)characters), ReceiptPrinter.lineFeed()});
        for (ReceiptItem receiptItem : receiptItems) {
            ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, ReceiptPrinter.getBytesForReceiptItem((ReceiptItem)receiptItem, (String)encoding, (String[])labels)});
        }
        return ret;
    }

    private static byte[] getCode128Barcode(String id) {
        byte[] ret = new byte[]{};
        byte[] barcodeHeight = new byte[]{29, 104, 3};
        byte[] barcodeWidth = new byte[]{29, 119, 50};
        ret = ReceiptPrinter.appendArrays((byte[][])new byte[][]{ret, barcodeHeight, barcodeWidth, ReceiptPrinter.barcodeCode128(), {(byte)id.length()}, ReceiptPrinter.code128CodeB(), id.getBytes()});
        String retString = HexFormat.ofDelimiter(" ").formatHex(ret);
        return ret;
    }

    public int getCharacters() {
        return this.characters;
    }

    public void setCharacters(int characters) {
        this.characters = characters;
    }
}

