/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.monitoring;

import cz.polreich.spagetka.DTO.monitoring.MonitoringDataDto;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.service.internet.InternetConnectivityService;
import cz.polreich.spagetka.service.mapper.MonitoringDataMapper;
import cz.polreich.spagetka.service.monitoring.MonitoringService;
import cz.polreich.spagetka.service.monitoring.model.MonitoringData;
import cz.polreich.spagetka.utils.ConditionalOnHostname;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnHostname(anyOf={"kioskCashier*"})
public class MonitoringRunner {
    private static final Logger log = LoggerFactory.getLogger(MonitoringRunner.class);
    private final MonitoringService monitoringService;
    private final RestTemplate restTemplate = new RestTemplate();
    private PartnerServerRestClient partnerServerRestClient;
    @Value(value="${spagetka.monitoring.monitoringInterval}")
    private Integer monitoringInterval;
    private InternetConnectivityService internetConnectivityService;

    @Autowired
    public MonitoringRunner(MonitoringService monitoringService) {
        this.monitoringService = monitoringService;
    }

    @PostConstruct
    private void init() {
        Objects.requireNonNull(this.partnerServerRestClient, "PartnerServerRestClient must not be null");
        Objects.requireNonNull(this.monitoringInterval, "monitoringInterval must not be null");
    }

    @Scheduled(fixedRateString="${spagetka.monitoring.monitoringInterval}")
    @Async
    public void scheduledMonitoringRunner() {
        if (this.internetConnectivityService.isPartnerWebAvailable()) {
            log.info("Monitoring data is started");
            MonitoringData data = this.monitoringService.createMonitoringData();
            if (data != null) {
                log.info("Sending monitoring data to PW");
                MonitoringDataDto monitoringDataDto = MonitoringDataMapper.toDto((MonitoringData)data);
                this.partnerServerRestClient.sendMonitoringData(monitoringDataDto);
            } else {
                log.error("Monitoring data is null. Client gets null. Fix it");
            }
        } else {
            log.info("[MONITORING RUNNER] - Monitoring is not running - no connection to Partner Web or no internet");
        }
    }

    @Autowired
    public void setInternetConnectivityService(InternetConnectivityService internetConnectivityService) {
        this.internetConnectivityService = internetConnectivityService;
    }

    @Autowired
    public void setPartnerServerRestClient(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    public MonitoringService getMonitoringService() {
        return this.monitoringService;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public PartnerServerRestClient getPartnerServerRestClient() {
        return this.partnerServerRestClient;
    }

    public Integer getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public InternetConnectivityService getInternetConnectivityService() {
        return this.internetConnectivityService;
    }

    public void setMonitoringInterval(Integer monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MonitoringRunner)) {
            return false;
        }
        MonitoringRunner other = (MonitoringRunner)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$monitoringInterval = this.getMonitoringInterval();
        Integer other$monitoringInterval = other.getMonitoringInterval();
        if (this$monitoringInterval == null ? other$monitoringInterval != null : !((Object)this$monitoringInterval).equals(other$monitoringInterval)) {
            return false;
        }
        MonitoringService this$monitoringService = this.getMonitoringService();
        MonitoringService other$monitoringService = other.getMonitoringService();
        if (this$monitoringService == null ? other$monitoringService != null : !this$monitoringService.equals(other$monitoringService)) {
            return false;
        }
        RestTemplate this$restTemplate = this.getRestTemplate();
        RestTemplate other$restTemplate = other.getRestTemplate();
        if (this$restTemplate == null ? other$restTemplate != null : !this$restTemplate.equals(other$restTemplate)) {
            return false;
        }
        PartnerServerRestClient this$partnerServerRestClient = this.getPartnerServerRestClient();
        PartnerServerRestClient other$partnerServerRestClient = other.getPartnerServerRestClient();
        if (this$partnerServerRestClient == null ? other$partnerServerRestClient != null : !this$partnerServerRestClient.equals(other$partnerServerRestClient)) {
            return false;
        }
        InternetConnectivityService this$internetConnectivityService = this.getInternetConnectivityService();
        InternetConnectivityService other$internetConnectivityService = other.getInternetConnectivityService();
        return !(this$internetConnectivityService == null ? other$internetConnectivityService != null : !this$internetConnectivityService.equals(other$internetConnectivityService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MonitoringRunner;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $monitoringInterval = this.getMonitoringInterval();
        result = result * 59 + ($monitoringInterval == null ? 43 : ((Object)$monitoringInterval).hashCode());
        MonitoringService $monitoringService = this.getMonitoringService();
        result = result * 59 + ($monitoringService == null ? 43 : $monitoringService.hashCode());
        RestTemplate $restTemplate = this.getRestTemplate();
        result = result * 59 + ($restTemplate == null ? 43 : $restTemplate.hashCode());
        PartnerServerRestClient $partnerServerRestClient = this.getPartnerServerRestClient();
        result = result * 59 + ($partnerServerRestClient == null ? 43 : $partnerServerRestClient.hashCode());
        InternetConnectivityService $internetConnectivityService = this.getInternetConnectivityService();
        result = result * 59 + ($internetConnectivityService == null ? 43 : $internetConnectivityService.hashCode());
        return result;
    }

    public String toString() {
        return "MonitoringRunner(monitoringService=" + this.getMonitoringService() + ", restTemplate=" + this.getRestTemplate() + ", partnerServerRestClient=" + this.getPartnerServerRestClient() + ", monitoringInterval=" + this.getMonitoringInterval() + ", internetConnectivityService=" + this.getInternetConnectivityService() + ")";
    }
}

