/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.polreich.spagetka.DTO.OrderDTO;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FormatUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.EntityNotFoundException;
import jakarta.servlet.http.HttpServletRequest;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/orders"})
@Tag(name="Orders API", description="Handles Orders operations")
public class OrderController
extends BaseRestController {
    @Autowired
    public OrderService orderService;
    @Autowired
    public ReceiptService receiptService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Orders")
    public ResponseEntity<List<OrderDTO>> getAll(@RequestHeader Map<String, String> headers, @RequestParam(required=false, name="fromDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String fromDateTimeString, @RequestParam(required=false, name="toDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String toDateTimeString) {
        return this.processRequest(headers, () -> new BaseRestController.DateRangeHandler((BaseRestController)this).handleDateRange(fromDateTimeString, toDateTimeString, arg_0 -> ((OrderService)this.orderService).findAllFromDateTime(arg_0), arg_0 -> ((OrderService)this.orderService).findAllToDateTime(arg_0), (arg_0, arg_1) -> ((OrderService)this.orderService).findAllInDateTimeFrame(arg_0, arg_1), () -> ((OrderService)this.orderService).findAll(), OrderDTO::new));
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Order with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=OrderDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Order with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<OrderDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            try {
                return new OrderDTO(this.orderService.findByIdQuery(id));
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Order with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while getting the order!");
            }
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Orders", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<OrderDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<OrderDTO> dtos, HttpServletRequest request) {
        System.out.println("[WOLT-DEBUG] Order 2 received");
        try {
            System.out.println("[WOLT-DEBUG] Creating file");
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(dtos);
            this.saveRequestBodyToFile(jsonString, "orders_POST_" + FormatUtils.formatDateTime((LocalDateTime)LocalDateTime.now()) + ".json");
            System.out.println("[WOLT-DEBUG] Created file");
        }
        catch (Exception e) {
            System.out.println("[WOLT-DEBUG] Handling exception");
            ExceptionHandler.logException((Exception)e);
        }
        return this.processRequest(headers, () -> {
            System.out.println("[WOLT-DEBUG] Processing request");
            List updatedOrders = this.orderService.createAll(dtos.stream().map(Order::new).toList(), false);
            System.out.println("[WOLT-DEBUG] Created orders - returning");
            return updatedOrders.stream().map(OrderDTO::new).toList();
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Order with specified ID", description="Updates existing or creates a new Order in case none found with provided ID")
    public ResponseEntity<OrderDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody OrderDTO newItem, @PathVariable String id, HttpServletRequest request) {
        System.out.println("Order 3 received");
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)newItem);
            this.saveRequestBodyToFile(jsonString, "orders_PUT_" + FormatUtils.formatDateTime((LocalDateTime)LocalDateTime.now()) + ".json");
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            Order orderWithNumber = this.orderService.createNew(new Order(newItem), false);
            newItem.setOrderNumber(orderWithNumber.getOrderNumber());
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Order with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Order with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            try {
                this.orderService.deleteById(id);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Order with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while deleting the order!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

