/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderManagementController;

import cz.polreich.spagetka.controllers.OrderManagementController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.YellowButton;
import cz.polreich.spagetka.utils.FormatUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;

public class CancelOrderPopup
extends Popup {
    private OrderManagementController orderManagementController;
    private AnchorPane popupAnchor;
    private ScrollPane itemsScrollPane;
    private List<ReceiptItem> selectedReceiptItems = new ArrayList();
    private VBox itemsVBox;
    private Receipt originalReceipt;
    private Order order;
    private List<CheckBox> checkboxesList = new ArrayList();

    public CancelOrderPopup(OrderManagementController orderManagementController) {
        this.orderManagementController = orderManagementController;
        int popupWidth = 900;
        int popupHeight = 700;
        this.popupAnchor = new AnchorPane();
        this.popupAnchor.setMinWidth((double)popupWidth);
        this.popupAnchor.setMaxWidth((double)popupWidth);
        this.popupAnchor.setMinHeight((double)popupHeight);
        this.popupAnchor.setMaxHeight((double)popupHeight);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        Label label = new Label();
        label.setText(orderManagementController.strings.getString("cancelOrderPopup.label.title"));
        label.setFont(orderManagementController.titleFont);
        AnchorPane.setTopAnchor((Node)label, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)label, (Double)10.0);
        AnchorPane.setRightAnchor((Node)label, (Double)10.0);
        label.setAlignment(Pos.CENTER);
        label.setPadding(new Insets(20.0));
        this.itemsScrollPane = new ScrollPane();
        AnchorPane.setTopAnchor((Node)this.itemsScrollPane, (Double)150.0);
        AnchorPane.setBottomAnchor((Node)this.itemsScrollPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.itemsScrollPane, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.itemsScrollPane, (Double)10.0);
        this.itemsVBox = new VBox();
        this.itemsVBox.setSpacing(10.0);
        this.itemsScrollPane.setContent((Node)this.itemsVBox);
        FlowPane buttonsFlowPane = new FlowPane();
        buttonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        buttonsFlowPane.setHgap(30.0);
        AnchorPane.setBottomAnchor((Node)buttonsFlowPane, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)10.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)10.0);
        ConfirmButton confirmButton = new ConfirmButton("Potvrdit");
        confirmButton.setFont(orderManagementController.subtitleFont);
        YellowButton cancelAllButton = new YellowButton("Storno vseho");
        cancelAllButton.setFont(orderManagementController.subtitleFont);
        CancelButton backButton = new CancelButton("Zpet");
        backButton.setFont(orderManagementController.subtitleFont);
        confirmButton.setOnMouseClicked(mouseEvent -> {
            if (this.order.isTaxRelevant()) {
                this.createRepairReceipt(true);
            }
            orderManagementController.finishCancelReceiptCreation();
        });
        cancelAllButton.setOnMouseClicked(mouseEvent -> {
            if (this.order.isTaxRelevant()) {
                this.createRepairReceipt(false);
            }
            orderManagementController.finishCancelReceiptCreation();
        });
        backButton.setOnMouseClicked(mouseEvent -> orderManagementController.hideCancelOrderPopup());
        buttonsFlowPane.getChildren().addAll((Object[])new Node[]{confirmButton, backButton});
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{label, this.itemsScrollPane, buttonsFlowPane});
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup(Order order, List<Receipt> receipts) {
        this.order = order;
        this.originalReceipt = receipts.stream().filter(r -> r.getTotalAmount().compareTo(BigDecimal.ZERO) >= 0).findFirst().orElse(null);
        ArrayList<String> allOrderItemsIds = new ArrayList<String>(order.getOrderItems().stream().map(OrderItem::getId).toList());
        if (this.originalReceipt != null) {
            for (ReceiptItem receiptItem : this.originalReceipt.getReceiptItems()) {
                boolean enabled = receiptItem.getOrderItemId() == null || allOrderItemsIds.contains(receiptItem.getOrderItemId());
                this.createReceiptItem(receiptItem, enabled);
            }
            this.show((Window)this.orderManagementController.stage);
        }
    }

    public void createReceiptItem(ReceiptItem receiptItem, boolean enabled) {
        for (int i = 0; i < receiptItem.getQuantity(); ++i) {
            CheckBox checkBox = new CheckBox();
            StringBuilder labelText = new StringBuilder(receiptItem.getTitle() + " " + FormatUtils.formatCurrency((BigDecimal)receiptItem.getTotalPrice().divide(BigDecimal.valueOf(receiptItem.getQuantity()), 2, RoundingMode.HALF_UP), (String)this.orderManagementController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.orderManagementController.activeConfig.getSelectedLocale())));
            for (String addTitle : receiptItem.getAddProductsTitles()) {
                labelText.append("\n    - ").append(addTitle);
            }
            checkBox.setText(labelText.toString());
            checkBox.setFont(this.orderManagementController.normalFont);
            checkBox.setId(receiptItem.getId());
            checkBox.setSelected(false);
            checkBox.setDisable(!enabled);
            this.checkboxesList.add(checkBox);
            Separator separator = new Separator();
            this.itemsVBox.getChildren().addAll((Object[])new Node[]{checkBox, separator});
        }
    }

    private ReceiptItem createReturnReceiptItem(ReceiptItem originalItem) {
        ReceiptItem newItem = new ReceiptItem(originalItem);
        newItem.setId(null);
        newItem.setUnitPrice(BigDecimal.ZERO.subtract(originalItem.getUnitPrice().divide(BigDecimal.valueOf(originalItem.getQuantity()), 2, RoundingMode.HALF_UP)));
        newItem.setTotalPrice(BigDecimal.ZERO.subtract(originalItem.getTotalPrice().divide(BigDecimal.valueOf(originalItem.getQuantity()), 2, RoundingMode.HALF_UP)));
        newItem.setBaseAmount(BigDecimal.ZERO.subtract(originalItem.getBaseAmount().divide(BigDecimal.valueOf(originalItem.getQuantity()), 2, RoundingMode.HALF_UP)));
        newItem.setVatAmount(BigDecimal.ZERO.subtract(originalItem.getVatAmount().divide(BigDecimal.valueOf(originalItem.getQuantity()), 2, RoundingMode.HALF_UP)));
        newItem.setQuantity(1);
        newItem.setSubItems(originalItem.getSubItems().stream().map(arg_0 -> this.createReturnReceiptItem(arg_0)).toList());
        return newItem;
    }

    public void createRepairReceipt(boolean partial) {
        Receipt repairReceipt = this.orderManagementController.createReceipt(false, this.order);
        repairReceipt.setDateTime(LocalDateTime.now());
        repairReceipt.setReceiptItems(new ArrayList());
        if (partial) {
            for (CheckBox checkBox : this.checkboxesList) {
                Optional<ReceiptItem> optionalOriginalReceiptItem;
                if (!checkBox.isSelected() || !(optionalOriginalReceiptItem = this.originalReceipt.getReceiptItems().stream().filter(r -> r.getId() != null && r.getId().equals(checkBox.getId())).findFirst()).isPresent()) continue;
                ReceiptItem item = this.createReturnReceiptItem(optionalOriginalReceiptItem.get());
                repairReceipt.addReceiptItem(item);
            }
        } else {
            for (ReceiptItem originalItem : repairReceipt.getReceiptItems()) {
                if (!this.order.getOrderItems().stream().anyMatch(oi -> oi.getId().equals(originalItem.getOrderItemId()))) continue;
                ReceiptItem item = this.createReturnReceiptItem(originalItem);
                repairReceipt.addReceiptItem(item);
            }
        }
        repairReceipt.setPaymentMethod(PAYMENT_METHOD.CASH);
        repairReceipt.setDiscount(BigDecimal.ZERO);
        repairReceipt.recalculateFields();
        this.orderManagementController.receiptService.save(repairReceipt);
        this.orderManagementController.printReceipt(repairReceipt);
        this.orderManagementController.printReceipt(repairReceipt);
        this.updateOrder(repairReceipt);
    }

    public void updateOrder(Receipt repairReceipt) {
        for (ReceiptItem receiptItem : repairReceipt.getReceiptItems()) {
            OrderItem orderItem;
            if (receiptItem.getOrderItemId() == null || (orderItem = (OrderItem)this.order.getOrderItems().stream().filter(oi -> oi.getId().equals(receiptItem.getOrderItemId())).findFirst().orElse(null)) == null) continue;
            if (orderItem.getQuantity() >= 2) {
                orderItem.setQuantity(orderItem.getQuantity() - 1);
            } else {
                this.order.getOrderItems().remove(orderItem);
            }
            BigDecimal refundedDiscount = receiptItem.getUnitPrice().abs().subtract(receiptItem.getTotalPrice().abs().divide(BigDecimal.valueOf(receiptItem.getQuantity()), 2, RoundingMode.HALF_UP));
            this.order.setDiscount(Double.valueOf(this.order.getDiscount() - refundedDiscount.doubleValue()));
            this.orderManagementController.orderService.update(this.order);
        }
    }

    public void hidePopup() {
        this.orderManagementController.hideCancelOrderPopup();
    }
}

