/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CashierBaseController;
import cz.polreich.spagetka.controllers.popup.cashierController.AttendancePopup;
import cz.polreich.spagetka.controllers.popup.cashierController.DiscountCodeGenerationPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.InventoryPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.KioskManagementPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.LogInPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.LogOutPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.NewDeliveryOrderPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.NewOrderPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.OrderVboxService;
import cz.polreich.spagetka.controllers.popup.cashierController.ProductsSettingsPopup;
import cz.polreich.spagetka.controllers.popup.cashierController.UpdatePopup;
import cz.polreich.spagetka.event.DummyEvent;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.service.AllergenService;
import cz.polreich.spagetka.service.AttendanceLogItemsService;
import cz.polreich.spagetka.service.CashManipulationItemsService;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.CompositionItemService;
import cz.polreich.spagetka.service.DiscountCouponService;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.service.InventoryCheckReportItemsService;
import cz.polreich.spagetka.service.KioskInfoService;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductVariantService;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.service.ReturnService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.service.StockMovementLogItemsService;
import cz.polreich.spagetka.service.UserService;
import cz.polreich.spagetka.service.internet.InternetConnectivityService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.MockDataHandler;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import java.awt.Point;
import java.io.File;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.robot.Robot;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class CashierController
extends CashierBaseController
implements Initializable {
    private static final Logger log = LoggerFactory.getLogger(CashierController.class);
    @FXML
    private AnchorPane checkoutAnchorPane;
    @FXML
    private AnchorPane headerAnchorPane;
    @FXML
    private Label currentUserLabel;
    @FXML
    private Button logInButton;
    @FXML
    private Button logOutButton;
    @FXML
    private FlowPane leftButtonsFlowPane;
    @FXML
    private Button discountCodeGenerationButton;
    @FXML
    private Button productsSettingsButton;
    @FXML
    private FlowPane ordersFlowPane;
    @FXML
    private Button addNewOrder;
    @FXML
    private Button attendanceButton;
    @FXML
    private Button kioskManagementButton;
    @FXML
    private Button orderManagementButton;
    @FXML
    private Button inventoryButton;
    @FXML
    private Button newOrderButton;
    @FXML
    private Button updateDataButton;
    @FXML
    private ScrollPane orderScrollPane;
    @FXML
    private ImageView internetImageView;
    @Autowired
    public UserService userService;
    @Autowired
    public OrderService orderService;
    @Autowired
    public DiscountCouponService discountCouponService;
    @Autowired
    public ReturnService returnService;
    @Autowired
    public AttendanceLogItemsService attendanceLogItemsService;
    @Autowired
    public MockDataHandler mockDataHandler;
    @Autowired
    public StockItemService stockItemService;
    @Autowired
    public StockMovementLogItemsService stockMovementLogItemsService;
    @Autowired
    public CategoryService categoryService;
    @Autowired
    public ProductService productService;
    @Autowired
    public MenuOptionService menuOptionService;
    @Autowired
    public IngredientService ingredientService;
    @Autowired
    public InventoryCheckReportItemsService inventoryCheckReportItemsService;
    @Autowired
    public ProductsGroupService productsGroupService;
    @Autowired
    public KioskInfoService kioskInfoService;
    @Autowired
    public AllergenService allergenService;
    @Autowired
    public ReceiptService receiptService;
    @Autowired
    public CashManipulationItemsService cashManipulationItemsService;
    @Autowired
    public CompositionItemService compositionItemService;
    @Autowired
    public ProductVariantService productVariantService;
    @Autowired
    private InternetConnectivityService internetConnectivityService;
    @Autowired
    private PartnerServerRestClient partnerServerRestClient;
    public int forkDiscount = 5;
    public int spoonDiscount = 6;
    private DiscountCodeGenerationPopup discountCodeGenerationPopup;
    private LogInPopup logInPopup;
    private LogOutPopup logOutPopup;
    private ProductsSettingsPopup productsSettingsPopup;
    private AttendancePopup attendancePopup;
    private KioskManagementPopup kioskManagementPopup;
    private InventoryPopup inventoryPopup;
    private NewOrderPopup newOrderPopup;
    private UpdatePopup updatePopup;
    private NewDeliveryOrderPopup newDeliveryOrderPopup;
    private GaussianBlur gaussianBlur;
    public BooleanProperty isLoggedIn = new SimpleBooleanProperty(false);
    public BooleanProperty isPopupOpen = new SimpleBooleanProperty(false);
    public OrderVboxService orderVboxService;
    public Boolean scrolling = false;

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.mockDataHandler.addUserToDB();
    }

    public void setupScene() {
        super.setupScene();
        if (this.activeConfig.isLoadMockData()) {
            this.mockDataHandler.setupCashierMockData();
        }
        this.initButtons();
        this.setupElementsWhichAreRelatedTOInternetConnection();
        this.initBindings();
        if (this.activeConfig.getLoggedInCashier() != null && this.activeConfig.getLoggedInCashier().get() != null) {
            this.logInPopup.okButtonAction(((User)this.activeConfig.getLoggedInCashier().get()).getPassword());
        }
        this.orderScrollPane.setFitToWidth(true);
        this.orderScrollPane.setOnScrollStarted(e -> {
            this.scrolling = true;
            e.consume();
        });
        this.orderScrollPane.setOnScrollFinished(e -> {
            this.scrolling = false;
            e.consume();
        });
    }

    private void initButtons() {
        for (Node node : this.leftButtonsFlowPane.getChildren()) {
            if (!(node instanceof Button)) continue;
            Button button = (Button)node;
            button.setFont(this.mainSceneButtonsFont);
            button.setPrefHeight(125.0);
            button.setMaxHeight(125.0);
            button.setPrefWidth(200.0);
            button.setPrefWidth(200.0);
        }
    }

    public void updateData() {
        System.out.println("Data update started");
        this.updatePopup.loadPopup();
        System.out.println("Data updated");
    }

    private void initBindings() {
        this.discountCodeGenerationPopup = new DiscountCodeGenerationPopup(this);
        this.logInPopup = new LogInPopup(this);
        this.logOutPopup = new LogOutPopup(this);
        this.productsSettingsPopup = new ProductsSettingsPopup(this);
        this.attendancePopup = new AttendancePopup(this);
        this.kioskManagementPopup = new KioskManagementPopup(this);
        this.inventoryPopup = new InventoryPopup(this);
        this.newOrderPopup = new NewOrderPopup(this);
        this.updatePopup = new UpdatePopup(this);
        this.newDeliveryOrderPopup = new NewDeliveryOrderPopup(this);
        this.leftButtonsFlowPane.setDisable(true);
        this.logOutButton.setDisable(true);
        this.gaussianBlur = new GaussianBlur();
        this.gaussianBlur.setRadius(7.0);
        this.logInButton.disableProperty().bind((ObservableValue)this.isLoggedIn);
        this.logOutButton.disableProperty().bind((ObservableValue)this.isLoggedIn.not());
        this.currentUserLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.activeConfig.getLoggedInCashier().get() != null ? ((User)this.activeConfig.getLoggedInCashier().get()).getFirstName() + " " + ((User)this.activeConfig.getLoggedInCashier().get()).getLastName() : "", (Observable[])new Observable[]{this.activeConfig.getLoggedInCashier()}));
        this.isPopupOpen.bind((ObservableValue)this.logInPopup.showingProperty().or((ObservableBooleanValue)this.logOutPopup.showingProperty()).or((ObservableBooleanValue)this.discountCodeGenerationPopup.showingProperty()).or((ObservableBooleanValue)this.productsSettingsPopup.showingProperty()).or((ObservableBooleanValue)this.attendancePopup.showingProperty()).or((ObservableBooleanValue)this.kioskManagementPopup.showingProperty()).or((ObservableBooleanValue)this.inventoryPopup.showingProperty()).or((ObservableBooleanValue)this.newOrderPopup.showingProperty()).or((ObservableBooleanValue)this.updatePopup.showingProperty()).or((ObservableBooleanValue)this.newDeliveryOrderPopup.showingProperty()));
        this.headerAnchorPane.disableProperty().bind((ObservableValue)this.isPopupOpen);
        this.leftButtonsFlowPane.disableProperty().bind((ObservableValue)this.isPopupOpen);
        this.isLoggedIn.bind((ObservableValue)Bindings.createBooleanBinding(() -> this.activeConfig.getLoggedInCashier().get() != null, (Observable[])new Observable[]{this.activeConfig.getLoggedInCashier()}));
        this.discountCodeGenerationButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.productsSettingsButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.kioskManagementButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.orderManagementButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.inventoryButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.updateDataButton.visibleProperty().bind((ObservableValue)this.isLoggedIn);
        this.disableUnusedButtons();
    }

    public void disableUnusedButtons() {
        this.newOrderButton.setDisable(true);
        this.newOrderButton.setVisible(false);
        this.productsSettingsButton.setDisable(true);
    }

    public void logInButtonAction() {
        if (!this.isLoggedIn.get()) {
            this.logInPopup.loadPopup();
            this.moveCursorToPopup((Popup)this.logInPopup);
        }
    }

    public void moveCursorToPopup(Popup popup) {
        try {
            Robot robot = new Robot();
            Window window = popup.getOwnerWindow();
            Bounds bounds = popup.getScene().getRoot().localToScreen(popup.getScene().getRoot().getBoundsInLocal());
            Point p = new Point((int)Math.round(bounds.getMinX() + bounds.getWidth() / 2.0), (int)Math.round(bounds.getMinY() + bounds.getHeight() / 2.0));
            robot.mouseMove((double)p.x, (double)p.y);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void confirmOrderPaid(Order order) {
        order.setOrderStatus(ORDER_STATUS.CONFIRMED);
        order.setUserConfirmed((User)this.activeConfig.getLoggedInCashier().get());
        if (order.isTaxRelevant()) {
            this.createReceipt(this.activeConfig.getPrinterConfig().isEnabled(), order);
        }
        if (this.activeConfig.getCurrentOrder().isDiscountApplied() && this.activeConfig.getCurrentOrder().getDiscountCode() != null) {
            this.partnerServerRestClient.notifyAboutDiscountCodeUsage(this.activeConfig.getCurrentOrder().getDiscountCode(), order.getId());
        }
        this.orderService.update(order);
    }

    public Receipt createReceipt(boolean print, Order order) {
        int cashierId = this.activeConfig.getLoggedInCashier() != null && this.activeConfig.getLoggedInCashier().get() != null ? ((User)this.activeConfig.getLoggedInCashier().get()).getId() : 0;
        Receipt receipt = new Receipt(order, Integer.valueOf(cashierId));
        receipt.setLocation(this.activeConfig.getKioskName() + " (" + this.activeConfig.getKioskInfo().getKioskId() + ")");
        List header = this.activeConfig.getKioskInfo().getReceiptInfo().getHeader();
        String footer = this.activeConfig.getKioskInfo().getReceiptInfo().getFooter();
        receipt.setHeader(header);
        receipt.setFooter(footer);
        this.receiptService.save(receipt);
        if (print) {
            try {
                this.printReceipt(receipt);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        }
        return receipt;
    }

    public void printReceipt(Receipt receipt) {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        String logoImageName = this.activeConfig.getPrinterConfig().getLogoImageName();
        int characters = this.activeConfig.getPrinterConfig().getCharacters();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        ReceiptPrinter.printReceipt((Receipt)receipt, (String)printerName, (KioskInfo)this.activeConfig.getKioskInfo(), (String)logoImageName, (int)characters, (String)encoding, (byte[])new byte[0]);
    }

    public void printDiscountCode(String code, LocalDateTime validUntil) {
        ReceiptPrinter.printDiscountCode((String)this.activeConfig.getPrinterConfig().getPrinterName(), (String)code, (LocalDateTime)validUntil, (String)this.activeConfig.getPrinterConfig().getLogoImageName(), (String)this.activeConfig.getPrinterConfig().getCodepage());
    }

    private void setupElementsWhichAreRelatedTOInternetConnection() {
        Optional internetI = this.internetConnectivityService.getImage();
        if (this.internetImageView == null) {
            return;
        }
        if (internetI.isPresent()) {
            this.internetImageView.setVisible(true);
            this.internetImageView.setPreserveRatio(false);
            this.internetImageView.setFitWidth(80.0);
            this.internetImageView.setFitHeight(80.0);
            this.internetImageView.setImage((Image)internetI.get());
            this.updateDataButton.setDisable(true);
            this.discountCodeGenerationButton.setDisable(true);
        } else {
            this.internetImageView.setVisible(false);
            this.updateDataButton.setDisable(false);
            this.discountCodeGenerationButton.setDisable(false);
        }
    }

    @EventListener
    public void handleInternetEvent(DummyEvent event) {
        log.info("[HANDLE INTERNET EVENT] - setting up graphical elements which are related to internet connection status");
        this.setupElementsWhichAreRelatedTOInternetConnection();
    }

    public void logOutButtonAction() {
        this.logOutPopup.loadPopup();
    }

    @FXML
    public void discountCodeGenerationButtonAction() {
        this.discountCodeGenerationPopup.loadPopup();
    }

    @FXML
    public void attendanceAction() {
        this.attendancePopup.loadPopup();
    }

    @FXML
    public void updateDataButtonAction() {
        this.updateData();
    }

    @FXML
    public void kioskManagementAction() {
        this.kioskManagementPopup.loadPopup();
    }

    @FXML
    public void orderManagementButtonAction() {
        this.orderVboxService.stop();
        this.switchToOrderManagementScene();
    }

    public void deliveryTilePaneAction() {
        this.orderVboxService = new OrderVboxService(this);
        this.orderVboxService.startTimer();
    }

    @FXML
    private void productsSettingsAction() {
        this.productsSettingsPopup.loadPopup(this.categoryService.findAll(), this.productService.findAll(), this.menuOptionService.findAll());
    }

    @FXML
    private void newOrderButtonAction() {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            List dtos = (List)objectMapper.readValue(new File("C:\\Users\\polre\\Downloads\\api logs\\orders_POST_02.08.2025_10-45.json"), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            this.orderService.createAll(dtos.stream().map(Order::new).toList(), false);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void blurBackground() {
        this.checkoutAnchorPane.setEffect((Effect)this.gaussianBlur);
    }

    public void unBlurBackground() {
        this.checkoutAnchorPane.setEffect(null);
    }

    @FXML
    private void inventoryButtonAction() {
        this.inventoryPopup.loadPopup();
    }

    public void hideInventoryPopup() {
        this.inventoryPopup.hide();
        this.inventoryPopup = new InventoryPopup(this);
    }

    public void hideNewOrderPopup() {
        this.newOrderPopup.hide();
        this.newOrderPopup = new NewOrderPopup(this);
    }

    public void showNewDeliveryOrderPopup() {
        if (this.newDeliveryOrderPopup.isShowing()) {
            return;
        }
        this.newDeliveryOrderPopup.loadPopup();
    }

    public FlowPane getOrdersFlowPane() {
        return this.ordersFlowPane;
    }

    public ScrollPane getOrderScrollPane() {
        return this.orderScrollPane;
    }
}

