/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.config;

import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.CashierConfigRow;
import cz.polreich.spagetka.models.config.CommonConfig;
import cz.polreich.spagetka.models.config.CommonConfigRow;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.config.CookConfigRow;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.models.config.CustomerConfigRow;
import cz.polreich.spagetka.models.config.FontsConfig;
import cz.polreich.spagetka.service.config.CashierConfigRowService;
import cz.polreich.spagetka.service.config.CommonConfigRowService;
import cz.polreich.spagetka.service.config.CookConfigRowService;
import cz.polreich.spagetka.service.config.CustomerConfigRowService;
import cz.polreich.spagetka.service.config.FontsConfigService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.HostUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class AppConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(AppConfigLoader.class);

    @Bean(name={"config"})
    public Config config(CommonConfig commonConfig, String hostname, CashierConfigRowService cashierConfigRowService, CookConfigRowService cookConfigRowService, CustomerConfigRowService customerConfigRowService, ResourceHelper resourceHelper, ImageFactory imageFactory, FontsConfig fontsConfig) {
        Config loadedConfig = new Config();
        loadedConfig.setResourceHelper(resourceHelper);
        loadedConfig.setImageFactory(imageFactory);
        try {
            List prefixes = loadedConfig.loadCountryPrefixes();
            loadedConfig.setCommon(commonConfig);
            loadedConfig.getCommon().setCountryPrefixes(prefixes);
            if (hostname.startsWith("kioskCashier")) {
                CashierConfigRow cashierFromDB = cashierConfigRowService.getLatest(hostname);
                loadedConfig.setCashier(new CashierConfig(cashierFromDB));
                loadedConfig.setCashierSelected();
            }
            if (hostname.startsWith("kioskCook")) {
                CookConfigRow cookFromDB = cookConfigRowService.getLatest(hostname);
                CookConfig cookConfig = new CookConfig(cookFromDB);
                loadedConfig.setCook(new CookConfig(cookFromDB));
                loadedConfig.setCookSelected();
                List categoryColorsFromDB = cookConfigRowService.getAllCategoryColors();
                cookConfig.getColors().setCategories(categoryColorsFromDB);
            }
            if (hostname.startsWith("kioskOrder")) {
                CustomerConfigRow customerFromDB = customerConfigRowService.getLatest(hostname);
                loadedConfig.setCustomer(new CustomerConfig(customerFromDB));
                loadedConfig.setCustomerSelected();
            }
            loadedConfig.getCommon().setFonts(fontsConfig);
            if (hostname.startsWith("kioskCashier")) {
                loadedConfig.getCashier().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCashier());
            }
            if (hostname.startsWith("kioskCook")) {
                loadedConfig.getCook().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCook());
            }
            if (hostname.startsWith("kioskOrder")) {
                loadedConfig.getCustomer().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCustomer());
            }
        }
        catch (Exception e) {
            log.error("Failed to load configuration", (Throwable)e);
            ExceptionHandler.logException((Exception)e);
        }
        return loadedConfig;
    }

    @Bean
    public CommonConfig commonConfig(CommonConfigRowService commonConfigRowService, String hostname, @Lazy PartnerServerRestClient partnerServerRestClient) {
        CommonConfigRow commonFromDB = commonConfigRowService.getLatest(hostname);
        CommonConfig commonConfig = new CommonConfig(commonFromDB);
        commonConfig.setPartnerServerRestClient(partnerServerRestClient);
        return commonConfig;
    }

    @Bean
    public String hostname() {
        String hostname = HostUtils.getHostnameShort();
        boolean hostnameExist = HostUtils.isHostnameExist((String)hostname);
        if (!hostnameExist) {
            ExceptionHandler.logException((Exception)new IllegalStateException("Missing or incorrect required environment variable: " + HostUtils.getOVERRIDE_ENV() + ". Please choose a one value from a list : " + HostUtils.getHostnameList()));
            System.exit(1);
        }
        log.info("Hostname - {}", (Object)hostname);
        return hostname;
    }

    @Bean
    public FontsConfig fontsConfig(String hostname, FontsConfigService fontsConfigService) {
        List fontsPathsFromDB = fontsConfigService.getAllPaths();
        List fontsSettingsFromDB = fontsConfigService.getAllSettingsForMachine(hostname);
        FontsConfig fontsConfig = new FontsConfig();
        fontsConfig.setPaths(fontsPathsFromDB);
        fontsConfig.setSettings(fontsSettingsFromDB);
        return fontsConfig;
    }
}

