/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class InventoryUtils {
    private static IngredientService ingredientService;

    @Autowired
    public InventoryUtils(IngredientService ingredientService) {
        InventoryUtils.ingredientService = ingredientService;
    }

    @NotNull
    public static String trimInventoryLocation(@NotNull String input) {
        String[] split = input.split("-");
        if (split.length > 2) {
            return String.join((CharSequence)"-", Arrays.copyOfRange(split, split.length - 3, split.length));
        }
        return input;
    }

    @NotNull
    public static StockItem parseQrCodeToStockItem(@NotNull String qrCode) {
        String[] splitCode = qrCode.split("_");
        if (splitCode.length < 2) {
            throw new IllegalArgumentException("Invalid QR Code: " + qrCode);
        }
        String ingredientId = splitCode[1];
        Ingredient ingredient = ingredientService.findById(ingredientId);
        if (ingredient == null) {
            throw new IllegalArgumentException("Ingredient not found: " + ingredientId);
        }
        LocalDate expirationDate = InventoryUtils.parseQrCodeToExpirationDate((String)qrCode);
        StockItem stockItem = new StockItem();
        stockItem.setQrcode(qrCode);
        stockItem.setIngredient(ingredient);
        stockItem.setExpirationDate(expirationDate);
        return stockItem;
    }

    @NotNull
    public static LocalDate parseQrCodeToExpirationDate(@NotNull String qrCode) {
        String[] splitCode = qrCode.split("_");
        if (splitCode.length < 3) {
            return LocalDate.of(2099, 12, 31);
        }
        String dateString = splitCode[2];
        try {
            return LocalDate.parse(dateString, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (DateTimeParseException e) {
            try {
                return LocalDate.parse(dateString, DateTimeFormatter.ofPattern("dd.MM.yyyy"));
            }
            catch (DateTimeParseException e2) {
                try {
                    return LocalDate.parse(dateString, DateTimeFormatter.ofPattern("dd.M.yyyy"));
                }
                catch (DateTimeParseException e3) {
                    ExceptionHandler.logException((Exception)e);
                    ExceptionHandler.logException((Exception)e2);
                    ExceptionHandler.logException((Exception)e3);
                    return LocalDate.of(2098, 12, 31);
                }
            }
        }
    }
}

