/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.screensaver;

import cz.polreich.spagetka.DTO.promos.PromoBody;
import cz.polreich.spagetka.DTO.promos.PromoDTO;
import cz.polreich.spagetka.DTO.promos.PromoResponse;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.event.NewPromoEvent;
import cz.polreich.spagetka.utils.ConditionalOnHostname;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnHostname(anyOf={"kioskOrder*"})
public class PromoManager {
    private static final Logger log = LoggerFactory.getLogger(PromoManager.class);
    private PartnerServerRestClient partnerServerRestClient;
    private volatile List<PromoResponse> currentPromosList = Collections.emptyList();
    private ApplicationEventPublisher publisher;

    @Scheduled(fixedRateString="${spagetka.promos.timeInterval}")
    public void checkPromos() {
        if (!this.partnerServerRestClient.isPartnerWebAvailable()) {
            log.debug("[CHECK PROMOS] - Partner Web is not available for installing promos");
            return;
        }
        log.info("[CHECK PROMOS] - checking PW for promos");
        List promosResponseList = this.partnerServerRestClient.requestPromos(new PromoBody(false, false));
        log.info("[CHECK PROMOS] - response from PW - {}", (Object)promosResponseList);
        if (promosResponseList.isEmpty()) {
            log.info("[PROMO RESPONSE] - a response from Partner Web is empty - no promos");
            return;
        }
        if (!this.areListsEqual(this.currentPromosList, promosResponseList)) {
            log.info("[CHECK PROMOS] - new promos detected, publishing event");
            Set newPromos = promosResponseList.stream().map(r -> new PromoDTO(r.getUrl())).collect(Collectors.toSet());
            Set currentPromos = this.currentPromosList.stream().map(r -> new PromoDTO(r.getUrl())).collect(Collectors.toSet());
            NewPromoEvent event = new NewPromoEvent((Object)this, false);
            event.setInstallList(newPromos.stream().filter(p -> !currentPromos.contains(p)).toList());
            event.setDeleteList(currentPromos.stream().filter(p -> !newPromos.contains(p)).toList());
            this.publisher.publishEvent((ApplicationEvent)event);
            this.currentPromosList = new ArrayList(promosResponseList);
        } else {
            log.info("[CHECK PROMOS] - no new promos");
        }
    }

    private boolean areListsEqual(List<PromoResponse> list1, List<PromoResponse> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Set set1 = list1.stream().map(PromoResponse::getUrl).collect(Collectors.toSet());
        Set set2 = list2.stream().map(PromoResponse::getUrl).collect(Collectors.toSet());
        return set1.equals(set2);
    }

    @Autowired
    public void setPartnerServerRestClient(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    @Autowired
    public void setPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

