/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.mapper;

import cz.polreich.spagetka.DTO.monitoring.KioskStageDto;
import cz.polreich.spagetka.DTO.monitoring.MonitoringDataDto;
import cz.polreich.spagetka.service.monitoring.model.KioskStage;
import cz.polreich.spagetka.service.monitoring.model.MonitoringData;
import java.util.List;
import java.util.stream.Collectors;

public class MonitoringDataMapper {
    public static MonitoringDataDto toDto(MonitoringData data) {
        if (data == null) {
            return null;
        }
        MonitoringDataDto dto = new MonitoringDataDto();
        dto.setKioskName(data.getKioskName());
        dto.setTimestamp(data.getTimestamp());
        dto.setVersion(data.getVersion());
        dto.setUserLoggedIn(data.isUserLoggedIn());
        dto.setUserId(data.getUserId());
        dto.setConfirmedOrdersQuantity(data.getConfirmedOrdersQuantity());
        dto.setPendingOrdersQuantity(data.getPendingOrdersQuantity());
        List kioskStageDtos = data.getKioskStageList().stream().map(MonitoringDataMapper::toDto).collect(Collectors.toList());
        dto.setKioskStageList(kioskStageDtos);
        return dto;
    }

    public static KioskStageDto toDto(KioskStage stage) {
        if (stage == null) {
            return null;
        }
        KioskStageDto dto = new KioskStageDto();
        dto.setKioskStageName(stage.getKioskStageName());
        dto.setKioskName(stage.getKioskName());
        dto.setFreeSpaceMB(stage.getFreeSpaceMB());
        dto.setFreeSpaceInPercent(stage.getFreeSpaceInPercent());
        dto.setComputerIsReachable(stage.isComputerIsReachable());
        return dto;
    }
}

