/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.repository.UserRepository;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UserService {
    @Autowired
    private UserRepository userRepository;

    public User findByPassword(String password) {
        return this.userRepository.findByPasswordAndIsActiveTrue(password);
    }

    public User findByRfid(String rfid) {
        return this.userRepository.findByRfidAndIsActiveTrue(rfid);
    }

    public boolean existsById(int id) {
        return this.userRepository.existsById((Object)id);
    }

    public User findById(int id) {
        return (User)this.userRepository.findById((Object)id).get();
    }

    public void save(User user) {
        this.userRepository.save((Object)user);
    }

    public void saveAll(List<User> users) {
        this.userRepository.saveAll(users);
    }

    @Transactional
    public void deactivateUsersNotInList(List<User> activeUsers) {
        List<Integer> activeIds = activeUsers.stream().map(User::getId).toList();
        this.userRepository.deactivateUsersNotInList(activeIds);
    }
}

