/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.factory.ProductFreeVariantFactory;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.repository.ProductFreeVariantRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductFreeVariantService {
    @Autowired
    private ProductFreeVariantRepository productFreeVariantRepository;
    private ProductFreeVariantFactory productFreeVariantFactory;

    public void saveAll(List<ProductFreeVariant> productFreeVariants) {
        this.productFreeVariantRepository.saveAll(productFreeVariants);
    }

    public List<ProductFreeVariant> findAll() {
        return this.productFreeVariantRepository.findAll();
    }

    public ProductFreeVariant findById(String id) {
        if (this.productFreeVariantRepository.findById((Object)id).isPresent()) {
            return (ProductFreeVariant)this.productFreeVariantRepository.findById((Object)id).get();
        }
        throw new EntityNotFoundException("[ProductFreeVariantService] - ProductFreeVariant with ID: " + id + "was not found. (E-154)");
    }

    public List<ProductFreeVariant> findByIdIn(List<String> ids) {
        return this.productFreeVariantRepository.findByIdIn(ids);
    }

    public ProductFreeVariant createFromExternalDTO(ProductFreeVariantDTO dto) {
        return this.productFreeVariantFactory.create(dto, true);
    }

    public void save(ProductFreeVariant productFreeVariant) {
        this.productFreeVariantRepository.save((Object)productFreeVariant);
    }

    public void deleteById(String id) {
        if (!this.productFreeVariantRepository.findById((Object)id).isPresent()) {
            throw new EntityNotFoundException("[ProductFreeVariantService] - ProductFreeVariant with ID: " + id + "was not found. (E-154)");
        }
        this.productFreeVariantRepository.deleteById((Object)id);
    }

    @Autowired
    public void setProductFreeVariantFactory(ProductFreeVariantFactory productFreeVariantFactory) {
        this.productFreeVariantFactory = productFreeVariantFactory;
    }
}

