/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/categories"})
@Tag(name="Categories API", description="Handles Categories operations")
public class CategoryController
extends BaseRestController {
    @Autowired
    private CategoryService categoryService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Categories")
    public ResponseEntity<List<CategoryDTO>> getAll(@RequestHeader Map<String, String> headers) {
        return this.processRequest(headers, () -> this.categoryService.findAll().stream().map(CategoryDTO::new).toList());
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Category with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=CategoryDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Category with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<CategoryDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable int id) {
        return this.processRequest(headers, () -> {
            try {
                return new CategoryDTO(this.categoryService.findById(Integer.valueOf(id)));
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Category with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while getting the category!");
            }
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Categories", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<CategoryDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<CategoryDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<Category> categories = new ArrayList<Category>();
            for (CategoryDTO dto : dtos) {
                Category category = this.categoryService.createFromDTO(dto);
                categories.add(category);
            }
            this.categoryService.saveAll(categories);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Category with specified ID", description="Updates existing or creates a new Category in case none found with provided ID")
    public ResponseEntity<CategoryDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody CategoryDTO newItem, @PathVariable int id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            Category category = this.categoryService.createFromDTO(newItem);
            this.categoryService.save(category);
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Category with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Category with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable int id) {
        if (this.isValidRequest(headers)) {
            try {
                this.categoryService.deleteById(id);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Category with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while deleting the category!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

