/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ReturnDTO;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.enums.RETURN_TYPE;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="Returns")
public class Return {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @ManyToOne
    @JoinColumn(name="order_id", nullable=true)
    private Order order;
    @Column
    private Double amount;
    @Column
    private String reason;
    @Column
    private String phoneNumber;
    @Column
    private LocalDateTime timestamp;
    @Column
    @Enumerated(value=EnumType.STRING)
    private RETURN_TYPE returnType;
    @Column
    private Boolean approved;
    @Column
    private Boolean issued;

    public Return(ReturnDTO dto) {
        this.id = dto.getId();
        OrderService orderService = (OrderService)ApplicationContextUtils.getApplicationContext().getBean(OrderService.class);
        this.order = orderService.findByIdQuery(dto.getOrderId());
        this.amount = dto.getAmount();
        this.reason = dto.getReason();
        this.phoneNumber = dto.getPhoneNumber();
        this.timestamp = LocalDateTime.parse(dto.getTimestamp());
        this.returnType = dto.getReturnType();
        this.approved = dto.getApproved();
        this.issued = dto.getIssued();
    }

    public String getId() {
        return this.id;
    }

    public Order getOrder() {
        return this.order;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getReason() {
        return this.reason;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public RETURN_TYPE getReturnType() {
        return this.returnType;
    }

    public Boolean getApproved() {
        return this.approved;
    }

    public Boolean getIssued() {
        return this.issued;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setReturnType(RETURN_TYPE returnType) {
        this.returnType = returnType;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public void setIssued(Boolean issued) {
        this.issued = issued;
    }

    public Return() {
    }

    public Return(String id, Order order, Double amount, String reason, String phoneNumber, LocalDateTime timestamp, RETURN_TYPE returnType, Boolean approved, Boolean issued) {
        this.id = id;
        this.order = order;
        this.amount = amount;
        this.reason = reason;
        this.phoneNumber = phoneNumber;
        this.timestamp = timestamp;
        this.returnType = returnType;
        this.approved = approved;
        this.issued = issued;
    }
}

