/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ReceiptItemDTO;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.utils.BigDecimalUtils;
import cz.polreich.spagetka.utils.CalcUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

@Entity
@Table(name="ReceiptItems")
public class ReceiptItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @Column
    private String title;
    @Column
    private List<String> addProductsTitles;
    @Column(columnDefinition="VARBINARY(1024) NULL DEFAULT NULL")
    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="receipt_items_sub_items", joinColumns={@JoinColumn(name="receiptItemId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="subItemId", referencedColumnName="id")})
    private List<ReceiptItem> subItems = new ArrayList();
    @Column
    private int quantity;
    @Column(precision=10, scale=2)
    private BigDecimal unitPrice;
    @Column(precision=10, scale=2)
    private BigDecimal totalPrice;
    @Column
    private Double vatPercent;
    @Column(precision=10, scale=2)
    private BigDecimal vatAmount;
    @Column(precision=10, scale=2)
    private BigDecimal baseAmount;
    @Column
    private String orderItemId;

    public ReceiptItem(OrderItem orderItem, BigDecimal discountPercentage) {
        this.title = orderItem.getDisplayName();
        this.addProductsTitles = Stream.of(orderItem.getAdditionalProducts().stream().map(Product::getName).toList(), orderItem.getFreeVariants().stream().map(ProductFreeVariant::getName).toList()).flatMap(Collection::stream).toList();
        this.subItems = orderItem.getSubItems().stream().map(o -> new ReceiptItem(o, discountPercentage)).toList();
        this.quantity = orderItem.getQuantity();
        this.unitPrice = BigDecimal.valueOf(orderItem.getFinalPrice()).setScale(2, RoundingMode.HALF_UP);
        if (BigDecimalUtils.isPositive((BigDecimal)discountPercentage)) {
            BigDecimal quantityBD = BigDecimal.valueOf(this.quantity);
            BigDecimal discount = this.unitPrice.multiply(quantityBD).multiply(discountPercentage).divide(BigDecimal.valueOf(100L), 0, RoundingMode.HALF_UP);
            this.totalPrice = this.unitPrice.multiply(quantityBD).subtract(discount).setScale(2, RoundingMode.HALF_UP);
        } else {
            BigDecimal quantityBD = BigDecimal.valueOf(this.quantity);
            this.totalPrice = this.unitPrice.multiply(quantityBD).setScale(2, RoundingMode.HALF_UP);
        }
        this.vatPercent = orderItem.getMainProduct().getVatPercent();
        this.vatAmount = this.subItems.isEmpty() ? CalcUtils.calculateVat((BigDecimal)this.totalPrice, (Double)this.vatPercent) : this.subItems.stream().map(ReceiptItem::getVatAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.baseAmount = this.totalPrice.subtract(this.vatAmount);
        this.orderItemId = orderItem.getId();
    }

    public ReceiptItem(ReceiptItemDTO dto) {
        this.id = dto.getId();
        this.title = dto.getTitle();
        this.addProductsTitles = dto.getAddProductsTitles();
        this.subItems = dto.getSubitems().stream().map(ReceiptItem::new).toList();
        this.quantity = dto.getQuantity();
        this.unitPrice = BigDecimal.valueOf(dto.getUnitPrice()).setScale(2, RoundingMode.HALF_UP);
        this.totalPrice = BigDecimal.valueOf(dto.getTotalPrice()).setScale(2, RoundingMode.HALF_UP);
        this.vatPercent = dto.getVatPercent();
        this.vatAmount = BigDecimal.valueOf(dto.getVatAmount()).setScale(2, RoundingMode.HALF_UP);
        this.baseAmount = BigDecimal.valueOf(dto.getBaseAmount()).setScale(2, RoundingMode.HALF_UP);
        this.orderItemId = dto.getOrderItemId();
    }

    public ReceiptItem(ReceiptItem receiptItem) {
        this.id = receiptItem.getId();
        this.title = receiptItem.getTitle();
        this.addProductsTitles = receiptItem.getAddProductsTitles();
        this.subItems = receiptItem.getSubItems();
        this.quantity = receiptItem.getQuantity();
        this.unitPrice = receiptItem.getUnitPrice();
        this.totalPrice = receiptItem.getTotalPrice();
        this.vatPercent = receiptItem.getVatPercent();
        this.vatAmount = receiptItem.getVatAmount();
        this.baseAmount = receiptItem.getBaseAmount();
        this.orderItemId = receiptItem.getOrderItemId();
    }

    public void addSubItem(ReceiptItem receiptItem) {
        this.subItems.add(receiptItem);
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAddProductsTitles() {
        return this.addProductsTitles;
    }

    public List<ReceiptItem> getSubItems() {
        return this.subItems;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public BigDecimal getUnitPrice() {
        return this.unitPrice;
    }

    public BigDecimal getTotalPrice() {
        return this.totalPrice;
    }

    public Double getVatPercent() {
        return this.vatPercent;
    }

    public BigDecimal getVatAmount() {
        return this.vatAmount;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAddProductsTitles(List<String> addProductsTitles) {
        this.addProductsTitles = addProductsTitles;
    }

    public void setSubItems(List<ReceiptItem> subItems) {
        this.subItems = subItems;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setTotalPrice(BigDecimal totalPrice) {
        this.totalPrice = totalPrice;
    }

    public void setVatPercent(Double vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setVatAmount(BigDecimal vatAmount) {
        this.vatAmount = vatAmount;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public ReceiptItem() {
    }

    public ReceiptItem(String id, String title, List<String> addProductsTitles, List<ReceiptItem> subItems, int quantity, BigDecimal unitPrice, BigDecimal totalPrice, Double vatPercent, BigDecimal vatAmount, BigDecimal baseAmount, String orderItemId) {
        this.id = id;
        this.title = title;
        this.addProductsTitles = addProductsTitles;
        this.subItems = subItems;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.totalPrice = totalPrice;
        this.vatPercent = vatPercent;
        this.vatAmount = vatAmount;
        this.baseAmount = baseAmount;
        this.orderItemId = orderItemId;
    }
}

