/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateResponse;
import cz.polreich.spagetka.DTO.discountCodes.DiscountCodesCustomerResponse;
import cz.polreich.spagetka.models.enums.DISCOUNT_CODE_TYPE;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class DiscountCode {
    private String discountCode;
    private DISCOUNT_CODE_TYPE codeType;
    private double amount;
    private LocalDateTime validUntil;
    private boolean valid;

    public boolean isValid() {
        return this.validUntil.isAfter(LocalDateTime.now());
    }

    public DiscountCode(DiscountCodeCreateResponse discountCodeCreateResponse) {
        this.discountCode = discountCodeCreateResponse.getDiscountCode();
        this.validUntil = LocalDateTime.parse(discountCodeCreateResponse.getValidUntil());
    }

    public DiscountCode(DiscountCodesCustomerResponse discountCodesCustomerResponse) {
        this.discountCode = discountCodesCustomerResponse.getDiscountCode();
        this.codeType = discountCodesCustomerResponse.getType();
        this.amount = discountCodesCustomerResponse.getValue();
        if (discountCodesCustomerResponse.getDateTo() == null) {
            this.validUntil = LocalDateTime.MAX;
        } else {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            this.validUntil = LocalDateTime.parse(discountCodesCustomerResponse.getDateTo(), formatter);
        }
    }

    public String getDiscountCode() {
        return this.discountCode;
    }

    public DISCOUNT_CODE_TYPE getCodeType() {
        return this.codeType;
    }

    public double getAmount() {
        return this.amount;
    }

    public LocalDateTime getValidUntil() {
        return this.validUntil;
    }

    public void setDiscountCode(String discountCode) {
        this.discountCode = discountCode;
    }

    public void setCodeType(DISCOUNT_CODE_TYPE codeType) {
        this.codeType = codeType;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setValidUntil(LocalDateTime validUntil) {
        this.validUntil = validUntil;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public DiscountCode() {
    }

    public DiscountCode(String discountCode, DISCOUNT_CODE_TYPE codeType, double amount, LocalDateTime validUntil, boolean valid) {
        this.discountCode = discountCode;
        this.codeType = codeType;
        this.amount = amount;
        this.validUntil = validUntil;
        this.valid = valid;
    }
}

