/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils.converters;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Converter(autoApply=false)
public class CsvIntListConverter
implements AttributeConverter<List<Integer>, String> {
    public String convertToDatabaseColumn(List<Integer> attribute) {
        if (attribute == null || attribute.isEmpty()) {
            return "";
        }
        return attribute.stream().map(String::valueOf).collect(Collectors.joining(","));
    }

    public List<Integer> convertToEntityAttribute(String dbData) {
        if (dbData == null || dbData.isBlank()) {
            return List.of();
        }
        String[] parts = dbData.split(",");
        ArrayList<Integer> out = new ArrayList<Integer>(parts.length);
        for (String p : parts) {
            String t = p.trim();
            if (t.isEmpty()) continue;
            out.add(Integer.parseInt(t));
        }
        return out;
    }
}

