/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.screensaver;

import cz.polreich.spagetka.event.UpdateScreensaverResourceEvent;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.models.config.ScreensaverConfig;
import cz.polreich.spagetka.models.gui.panes.ScreensaverPaneComponents;
import cz.polreich.spagetka.models.wrapper.ImageWrapper;
import cz.polreich.spagetka.service.screensaver.ScreensaverResourcesManager;
import cz.polreich.spagetka.utils.ConditionalOnHostname;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@ConditionalOnHostname(anyOf={"kioskOrder*"})
@Service
public class ScreensaverService {
    private static final Logger log = LoggerFactory.getLogger(ScreensaverService.class);
    private final ScreensaverResourcesManager screensaverResourcesManager;
    private Timeline slideshowTimeline;
    private MediaPlayer mediaPlayer;
    private AnchorPane screensaverAnchorPane;
    private ImageView imageView1;
    private ImageView imageView2;
    private MediaView mediaView;
    private Button goToWelcomePageButton;
    private final boolean enableImageScreensaver;
    private boolean enableMediaScreensaver;
    private final long activationScreensaverTimeSeconds;
    private final long nextImageTimeSeconds;
    private final double fadeOutDurationSeconds;
    private final double fadeInDurationSeconds;
    private boolean isSlideshowActive = false;
    private boolean isMediaActive = false;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    @Autowired
    public ScreensaverService(ScreensaverResourcesManager screensaverResourcesManager, Config config) {
        this.screensaverResourcesManager = screensaverResourcesManager;
        CustomerConfig customerConfig = config.getCustomer();
        ScreensaverConfig screensaverConfig = customerConfig.getScreensaverConfig();
        this.enableImageScreensaver = screensaverConfig.isEnableImageScreensaver();
        this.enableMediaScreensaver = screensaverConfig.isEnableMediaScreensaver();
        this.activationScreensaverTimeSeconds = screensaverConfig.getActivationScreensaverTimeSeconds();
        this.nextImageTimeSeconds = screensaverConfig.getNextImageTimeSeconds();
        this.fadeOutDurationSeconds = screensaverConfig.getFadeOutTimeSeconds();
        this.fadeInDurationSeconds = screensaverConfig.getFadeInTimeSeconds();
        if (this.enableImageScreensaver) {
            log.info("Screensaver is turned on to display images (configured via config.old.json).");
        } else {
            log.info("Screensaver is turned off to display images (configured via config.old.json).");
        }
        if (this.enableMediaScreensaver) {
            log.info("Screensaver is turned on to display medias (configured via config.old.json).");
        } else {
            log.info("Screensaver is turned off to display medias (configured via config.old.json).");
        }
        if (this.enableImageScreensaver && this.enableMediaScreensaver) {
            log.info("Screensaver is only turned on to display images and turn off to display media. \nA reason - enableImageScreensaver and enableMediaScreensaver are both setup as 'true'");
            this.enableMediaScreensaver = false;
        }
    }

    public void registerScreensaverPane(ScreensaverPaneComponents components) {
        this.screensaverAnchorPane = components.getAnchorPane();
        this.imageView1 = components.getImageView1();
        this.imageView2 = components.getImageView2();
        this.mediaView = components.getMediaView();
        this.goToWelcomePageButton = components.getGoToWelcomePageButton();
        if (this.enableImageScreensaver) {
            this.imageView1.setPreserveRatio(false);
            this.imageView1.setFitWidth(1080.0);
            this.imageView1.setFitHeight(1720.0);
            this.imageView1.setImage(null);
            this.imageView2.setPreserveRatio(false);
            this.imageView2.setFitWidth(1080.0);
            this.imageView2.setFitHeight(1720.0);
            this.imageView2.setImage(null);
        }
        if (this.enableMediaScreensaver) {
            this.mediaView.setFitWidth(1080.0);
            this.mediaView.setFitHeight(1720.0);
            this.mediaView.setMediaPlayer(null);
        }
        this.hideScreensaver();
        Runnable stopAction = () -> {
            this.stopAll();
            this.hideScreensaver();
        };
        this.screensaverAnchorPane.setOnMouseClicked(event -> stopAction.run());
        this.goToWelcomePageButton.setOnMouseClicked(event -> stopAction.run());
    }

    public void execute(long timeSinceLastPress) {
        boolean needsToUpdateResources = this.screensaverResourcesManager.isNeedsToUpdateResources();
        if (!this.screensaverAnchorPane.isVisible() && timeSinceLastPress >= this.activationScreensaverTimeSeconds * 1000L) {
            if (!needsToUpdateResources) {
                if (this.enableImageScreensaver && !this.isSlideshowActive) {
                    this.playSlideshow();
                }
                if (this.enableMediaScreensaver && !this.isMediaActive) {
                    this.playVideo();
                }
            } else {
                log.info("[EXECUTING SCREENSAVER ACTION] - does not execute - resources are updating");
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new UpdateScreensaverResourceEvent((Object)this));
            }
        }
    }

    private void stopAll() {
        if (this.slideshowTimeline != null) {
            this.slideshowTimeline.stop();
            this.slideshowTimeline = null;
        }
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.dispose();
            this.mediaView.setMediaPlayer(null);
            this.mediaPlayer = null;
        }
        this.isSlideshowActive = false;
        this.isMediaActive = false;
    }

    private void showScreensaver() {
        this.screensaverAnchorPane.setVisible(true);
        this.screensaverAnchorPane.setMouseTransparent(false);
        if (this.enableImageScreensaver) {
            this.imageView1.setVisible(true);
            this.imageView2.setVisible(true);
        }
        if (this.enableMediaScreensaver) {
            this.mediaView.setVisible(true);
        }
        this.goToWelcomePageButton.setVisible(true);
    }

    private void hideScreensaver() {
        this.screensaverAnchorPane.setVisible(false);
        this.screensaverAnchorPane.setMouseTransparent(true);
        this.imageView1.setVisible(false);
        this.imageView2.setVisible(false);
        this.mediaView.setVisible(false);
        this.goToWelcomePageButton.setVisible(false);
    }

    private void playSlideshow() {
        this.isSlideshowActive = true;
        Optional initialImage = this.screensaverResourcesManager.nextImage();
        if (initialImage.isEmpty()) {
            return;
        }
        this.imageView1.setImage(((ImageWrapper)initialImage.get()).getImage());
        this.imageView1.setOpacity(1.0);
        this.imageView2.setOpacity(0.0);
        this.showScreensaver();
        if (this.screensaverResourcesManager.getImageListSize() > 1) {
            this.slideshowTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)this.nextImageTimeSeconds), e -> {
                Optional nextImageOptional = this.screensaverResourcesManager.nextImage();
                if (nextImageOptional.isEmpty()) {
                    this.slideshowTimeline.stop();
                    return;
                }
                Image nextImage = ((ImageWrapper)nextImageOptional.get()).getImage();
                this.imageView2.setImage(nextImage);
                FadeTransition fadeOut = new FadeTransition(Duration.seconds((double)this.fadeOutDurationSeconds), (Node)this.imageView1);
                fadeOut.setFromValue(1.0);
                fadeOut.setToValue(0.0);
                FadeTransition fadeIn = new FadeTransition(Duration.seconds((double)this.fadeInDurationSeconds), (Node)this.imageView2);
                fadeIn.setFromValue(0.0);
                fadeIn.setToValue(1.0);
                fadeOut.play();
                fadeIn.play();
                fadeIn.setOnFinished(ev -> {
                    ImageView temp = this.imageView1;
                    this.imageView1 = this.imageView2;
                    this.imageView2 = temp;
                });
            }, new KeyValue[0])});
            this.slideshowTimeline.setCycleCount(-1);
            this.slideshowTimeline.play();
        }
    }

    private void playVideo() {
        this.isMediaActive = true;
        Optional mediaOptional = this.screensaverResourcesManager.nextMedia();
        if (mediaOptional.isEmpty()) {
            return;
        }
        this.showScreensaver();
        this.playNext();
    }

    private void playNext() {
        Optional mediaOptional = this.screensaverResourcesManager.nextMedia();
        if (mediaOptional.isEmpty()) {
            return;
        }
        mediaOptional.ifPresent(media -> {
            MediaPlayer newPlayer;
            this.disposeCurrentPlayer();
            this.mediaPlayer = newPlayer = new MediaPlayer(media.getMedia());
            this.mediaView.setMediaPlayer(newPlayer);
            newPlayer.setOnEndOfMedia(() -> this.playNext());
            newPlayer.play();
        });
    }

    private void disposeCurrentPlayer() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.stop();
            this.mediaPlayer.dispose();
            this.mediaPlayer = null;
        }
    }
}

