/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.CompositionItemDTO;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="compositionItems")
public class CompositionItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @ManyToOne
    @JoinColumn(name="ingredientId", referencedColumnName="id")
    private Ingredient ingredient;
    @Column
    private Double quantity;

    public CompositionItem(CompositionItemDTO dto) {
        IngredientService ingredientService = (IngredientService)ApplicationContextUtils.getApplicationContext().getBean(IngredientService.class);
        if (ingredientService.existsById(dto.getIngredientId().toString())) {
            this.ingredient = ingredientService.findById(dto.getIngredientId().toString());
        }
        this.quantity = dto.getQuantity();
    }

    public String getId() {
        return this.id;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public CompositionItem() {
    }

    public CompositionItem(String id, Ingredient ingredient, Double quantity) {
        this.id = id;
        this.ingredient = ingredient;
        this.quantity = quantity;
    }
}

