/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.customerMainController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.InputStream;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;

public class ProductDetailPopup
extends Popup {
    private CustomerMainController customerMainController;
    private CancelButton backButton = new CancelButton();
    private AnchorPane mainAnchorPane;
    private FlowPane contentFlowPane;
    private Label title;
    private Label descriptionTitle;
    private Label descriptionTextArea;
    private Label ingredientsTitle;
    private Label ingredientsTextArea;
    private VBox ingredientsVBox;
    private Label allergensTitle;
    private Label allergensTextArea;
    private double popupMinWidth;
    private double popupMinHeight;
    private double popupMaxWidth;
    private double popupMaxHeight;
    private double imageViewFitWidth;
    private double imageViewFitHeight;
    private double imageFlowPaneTopAnchor;
    private FlowPane vegetarianFlowPane;
    private VBox allergensVBox;

    public ProductDetailPopup(CustomerMainController customerMainController) {
        this.customerMainController = customerMainController;
        this.popupMinWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMinHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.9;
        this.popupMaxWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMaxHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.9;
        this.imageViewFitWidth = this.popupMinWidth;
        this.imageViewFitHeight = 500.0;
        double titleFlowPaneHeight = 100.0;
        double titleFlowPaneTopAnchor = 50.0;
        this.imageFlowPaneTopAnchor = Math.max(titleFlowPaneHeight + titleFlowPaneTopAnchor, 200.0);
        double contentBeginning = this.imageFlowPaneTopAnchor + this.imageViewFitHeight + 150.0;
        double descriptionVBoxTopAnchor = this.imageFlowPaneTopAnchor + this.imageViewFitHeight + 150.0;
        double ingredientsVBoxTopAnchor = descriptionVBoxTopAnchor + 150.0;
        double allergensVBoxTopAnchor = ingredientsVBoxTopAnchor + 150.0;
        this.contentFlowPane = new FlowPane();
        this.contentFlowPane.setOrientation(Orientation.VERTICAL);
        this.contentFlowPane.setVgap(50.0);
        this.contentFlowPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.contentFlowPane.setAlignment(Pos.TOP_CENTER);
        AnchorPane.setLeftAnchor((Node)this.contentFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.contentFlowPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.contentFlowPane, (Double)contentBeginning);
        AnchorPane.setBottomAnchor((Node)this.contentFlowPane, (Double)200.0);
        this.mainAnchorPane = new AnchorPane();
        this.mainAnchorPane.getStyleClass().add((Object)"popup-main-pane");
        this.mainAnchorPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.mainAnchorPane.setMinWidth(this.popupMinWidth);
        this.mainAnchorPane.setMinHeight(this.popupMinHeight);
        this.mainAnchorPane.setMaxWidth(this.popupMaxWidth);
        this.mainAnchorPane.setMaxHeight(this.popupMaxHeight);
        FlowPane titleFlowPane = new FlowPane();
        titleFlowPane.setMaxHeight(titleFlowPaneHeight);
        AnchorPane.setTopAnchor((Node)titleFlowPane, (Double)titleFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)titleFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)titleFlowPane, (Double)0.0);
        titleFlowPane.setAlignment(Pos.CENTER);
        this.title = new Label();
        this.title.setMaxWidth(this.popupMaxWidth * 0.9);
        this.title.setAlignment(Pos.CENTER);
        this.title.getStyleClass().add((Object)"popup-title");
        FontUtils.setIdealFont((Label)this.title, (Font)customerMainController.popupTitleFont);
        titleFlowPane.getChildren().add((Object)this.title);
        VBox descriptionVBox = new VBox();
        AnchorPane.setTopAnchor((Node)descriptionVBox, (Double)descriptionVBoxTopAnchor);
        AnchorPane.setLeftAnchor((Node)descriptionVBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)descriptionVBox, (Double)0.0);
        descriptionVBox.setAlignment(Pos.CENTER);
        descriptionVBox.setSpacing(30.0);
        descriptionVBox.setMaxWidth(this.popupMaxWidth - 20.0);
        this.descriptionTitle = new Label();
        this.descriptionTitle.setMaxWidth(this.popupMaxWidth - 20.0);
        customerMainController.bindStringToLocale(this.descriptionTitle, "productDetail.label.description", customerMainController.subtitleFont);
        FontUtils.setIdealFont((Label)this.descriptionTitle, (Font)customerMainController.subtitleFont);
        this.descriptionTitle.setMaxWidth(this.popupMaxWidth);
        this.descriptionTitle.setAlignment(Pos.CENTER);
        this.descriptionTextArea = new Label();
        this.descriptionTextArea.setMaxWidth(this.popupMaxWidth - 20.0);
        this.descriptionTextArea.setWrapText(true);
        this.descriptionTextArea.setFont(customerMainController.normalFont);
        this.descriptionTextArea.setAlignment(Pos.CENTER);
        ImageView vegetarianIconImageView = ResourceHelper.getImageViewFromResourceName((String)"/resources/images/vegetarian_128.png");
        vegetarianIconImageView.setFitWidth(64.0);
        vegetarianIconImageView.setFitHeight(64.0);
        Label vegetarianTitle = new Label();
        vegetarianTitle.setMaxWidth(this.popupMaxWidth * 0.9);
        customerMainController.bindStringToLocale(vegetarianTitle, "productDetail.label.vegetarianMeal", customerMainController.normalFont);
        FontUtils.setIdealFont((Label)vegetarianTitle, (Font)customerMainController.normalFont);
        this.vegetarianFlowPane = new FlowPane();
        this.vegetarianFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.vegetarianFlowPane.setAlignment(Pos.CENTER);
        this.vegetarianFlowPane.setHgap(30.0);
        this.vegetarianFlowPane.getChildren().addAll((Object[])new Node[]{vegetarianIconImageView, vegetarianTitle});
        descriptionVBox.getChildren().addAll((Object[])new Node[]{this.descriptionTitle, this.descriptionTextArea, this.vegetarianFlowPane});
        this.ingredientsVBox = new VBox();
        AnchorPane.setTopAnchor((Node)this.ingredientsVBox, (Double)ingredientsVBoxTopAnchor);
        AnchorPane.setLeftAnchor((Node)this.ingredientsVBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.ingredientsVBox, (Double)0.0);
        this.ingredientsVBox.setAlignment(Pos.CENTER);
        this.ingredientsVBox.setSpacing(30.0);
        this.ingredientsTitle = new Label();
        this.ingredientsTitle.setMaxWidth(this.popupMaxWidth * 0.9);
        customerMainController.bindStringToLocale(this.ingredientsTitle, "productDetail.label.ingredients", customerMainController.subtitleFont);
        FontUtils.setIdealFont((Label)this.ingredientsTitle, (Font)customerMainController.subtitleFont);
        this.ingredientsTitle.setAlignment(Pos.CENTER);
        this.ingredientsTextArea = new Label();
        this.ingredientsTextArea.setWrapText(true);
        this.ingredientsTextArea.setFont(customerMainController.normalFont);
        this.ingredientsTextArea.setAlignment(Pos.CENTER);
        this.ingredientsVBox.getChildren().addAll((Object[])new Node[]{this.ingredientsTitle, this.ingredientsTextArea});
        this.allergensVBox = new VBox();
        AnchorPane.setTopAnchor((Node)this.allergensVBox, (Double)allergensVBoxTopAnchor);
        AnchorPane.setLeftAnchor((Node)this.allergensVBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.allergensVBox, (Double)0.0);
        this.allergensVBox.setAlignment(Pos.CENTER);
        this.allergensVBox.setSpacing(30.0);
        this.allergensVBox.setMaxWidth(this.popupMaxWidth - 20.0);
        this.allergensTitle = new Label();
        this.allergensTitle.setMaxWidth(this.popupMaxWidth * 0.9);
        customerMainController.bindStringToLocale(this.allergensTitle, "productDetail.label.allergens", customerMainController.subtitleFont);
        FontUtils.setIdealFont((Label)this.allergensTitle, (Font)customerMainController.subtitleFont);
        this.allergensTitle.setAlignment(Pos.CENTER);
        this.allergensTextArea = new Label();
        this.allergensTextArea.setMaxWidth(this.popupMaxWidth - 20.0);
        this.allergensTextArea.setWrapText(true);
        FontUtils.setIdealFont((Label)this.allergensTextArea, (Font)customerMainController.normalFont);
        this.allergensTextArea.setAlignment(Pos.CENTER);
        this.allergensVBox.getChildren().addAll((Object[])new Node[]{this.allergensTitle, this.allergensTextArea});
        this.contentFlowPane.getChildren().addAll((Object[])new Node[]{descriptionVBox, this.ingredientsVBox, this.allergensVBox});
        FlowPane buttonsFlowPane = new FlowPane();
        AnchorPane.setBottomAnchor((Node)buttonsFlowPane, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)0.0);
        buttonsFlowPane.setAlignment(Pos.CENTER);
        buttonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        buttonsFlowPane.setHgap(50.0);
        customerMainController.bindStringToLocale((Button)this.backButton, "productDetail.button.back", customerMainController.titleFont);
        this.backButton.setPrefWidth(296.0);
        this.backButton.setPrefHeight(100.0);
        FontUtils.setIdealFont((Button)this.backButton, (Font)customerMainController.titleFont);
        this.backButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        this.backButton.setOnTouchPressed(touchEvent -> {
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        buttonsFlowPane.getChildren().add((Object)this.backButton);
        this.mainAnchorPane.getChildren().addAll((Object[])new Node[]{titleFlowPane, this.contentFlowPane, buttonsFlowPane});
        this.getContent().add((Object)this.mainAnchorPane);
        this.setAutoHide(false);
    }

    public void loadPopup(Product product) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.customerMainController.activeConfig.getOpenedPopups().add(this);
        this.title.setText(product.getName());
        FlowPane imageFlowPane = new FlowPane();
        AnchorPane.setTopAnchor((Node)imageFlowPane, (Double)this.imageFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)imageFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)imageFlowPane, (Double)0.0);
        imageFlowPane.setAlignment(Pos.CENTER);
        InputStream is = ResourceHelper.getImageAsStream((String)product.getImageFilePath());
        Image image = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)image, (double)this.popupMinWidth, (double)this.imageViewFitHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(this.popupMinWidth);
        imageView.setFitHeight(500.0);
        ImageUtils.centerImage((ImageView)imageView);
        imageFlowPane.getChildren().add((Object)imageView);
        this.mainAnchorPane.getChildren().add((Object)imageFlowPane);
        this.descriptionTextArea.setText(product.getDescription());
        this.vegetarianFlowPane.setVisible(product.isVegetarian());
        this.vegetarianFlowPane.setManaged(product.isVegetarian());
        if (this.customerMainController.activeConfig.isShowIngredientsInProductDetail()) {
            this.ingredientsVBox.setVisible(true);
            this.ingredientsVBox.setManaged(true);
            this.ingredientsTextArea.setText(product.getIngredientsString());
        } else {
            this.ingredientsVBox.setVisible(false);
            this.ingredientsVBox.setManaged(false);
        }
        if (product.getAlergens().isEmpty()) {
            this.customerMainController.bindStringToLocale(this.allergensTextArea, "productDetail.label.allergensGeneric", this.customerMainController.normalFont);
        } else {
            for (String allergen : product.getAlergens()) {
                this.allergensTextArea.setText(this.allergensTextArea.getText() + allergen + " - " + this.customerMainController.allergenService.findById(Integer.valueOf(allergen)).getName() + "\n");
            }
        }
        this.show((Window)this.customerMainController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
        this.customerMainController.getOverrideMainDisableProperty().set(true);
    }

    public void loadPopup(ProductVariant variant) {
        this.title.setText(variant.getName());
        FlowPane imageFlowPane = new FlowPane();
        AnchorPane.setTopAnchor((Node)imageFlowPane, (Double)this.imageFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)imageFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)imageFlowPane, (Double)0.0);
        imageFlowPane.setAlignment(Pos.CENTER);
        InputStream is = ResourceHelper.getImageAsStream((String)variant.getImageFilePath());
        Image image = new Image(is);
        ImageView imageView = ImageUtils.getCroppedImageView((Image)image, (double)this.popupMinWidth, (double)this.imageViewFitHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(this.popupMinWidth);
        imageView.setFitHeight(500.0);
        ImageUtils.centerImage((ImageView)imageView);
        imageFlowPane.getChildren().add((Object)imageView);
        this.mainAnchorPane.getChildren().add((Object)imageFlowPane);
        this.descriptionTextArea.setText(variant.getDescription());
        this.vegetarianFlowPane.setVisible(false);
        this.vegetarianFlowPane.setManaged(false);
        this.ingredientsVBox.setVisible(false);
        this.ingredientsVBox.setManaged(false);
        this.customerMainController.bindStringToLocale(this.allergensTextArea, "productDetail.label.allergensGeneric", this.customerMainController.normalFont);
        this.show((Window)this.customerMainController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void hide() {
        this.customerMainController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

