/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.CashierBaseController;
import cz.polreich.spagetka.controllers.OrderManagementController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.config.BaseConfig;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.FontPath;
import cz.polreich.spagetka.models.config.FontSetting;
import cz.polreich.spagetka.models.config.FontsConfig;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FontUtils;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class Controller {
    public Stage stage;
    @Autowired
    public Config config;
    public BaseConfig activeConfig;
    protected String stringBundleName;
    public ResourceBundle strings;
    private javafx.scene.text.Font defaultFont = new javafx.scene.text.Font("System", 12.0);

    public void init() {
        this.activeConfig = this.config.getSelectedConfig();
    }

    public void setupStage(Stage s) {
        this.stage = s;
        this.setupColors();
        this.setupFonts();
        this.setupScene();
    }

    public void setupStage(Stage s, ResourceBundle strings) {
        this.stage = s;
        this.strings = strings;
        this.setupColors();
        this.setupFonts();
        this.setupScene();
    }

    public void setupScene() {
    }

    public void setupFonts() {
    }

    public void setupColors() {
    }

    void registerFonts(FontsConfig fontsConfig) {
        for (FontPath fontPath : fontsConfig.getPaths()) {
            try {
                InputStream fontFile = Files.newInputStream(Paths.get(Objects.requireNonNull(this.getClass().getResource(fontPath.getRelativePath())).toURI()), new OpenOption[0]);
                Font font = Font.createFont(0, fontFile);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        }
    }

    javafx.scene.text.Font setupCashierFont(String fontFieldName) {
        return this.setupFont(fontFieldName, this.config.getCashier().getFonts());
    }

    javafx.scene.text.Font setupCookFont(String fontFieldName) {
        return this.setupFont(fontFieldName, this.config.getCook().getFonts());
    }

    javafx.scene.text.Font setupCustomerFont(String fontFieldName) {
        return this.setupFont(fontFieldName, this.config.getCustomer().getFonts());
    }

    javafx.scene.text.Font setupFont(String fontFieldName, FontsConfig fontsConfig) {
        List fontPaths = fontsConfig.getPaths();
        List fontSettings = fontsConfig.getSettings();
        Optional<FontSetting> optionalFontSetting = fontSettings.stream().filter(f -> f.getSettingName().equals(fontFieldName)).findFirst();
        if (optionalFontSetting.isPresent()) {
            FontSetting fontSetting = optionalFontSetting.get();
            Integer size = fontSetting.getFontSize();
            Optional<FontPath> filePathOptional = fontPaths.stream().filter(p -> p.getFontName().equals(fontSetting.getFontName())).findFirst();
            if (filePathOptional.isPresent()) {
                URL resource;
                String filePath = filePathOptional.get().getRelativePath();
                String fontFile = null;
                if (filePath != null && !filePath.trim().isEmpty() && (resource = this.getClass().getResource(filePath)) != null) {
                    fontFile = resource.toExternalForm();
                }
                if (fontFile != null) {
                    return javafx.scene.text.Font.loadFont(fontFile, (double)size.intValue());
                }
                return new javafx.scene.text.Font((double)size.intValue());
            }
            return new javafx.scene.text.Font((double)size.intValue());
        }
        return this.defaultFont;
    }

    public void bindStringToLocale(Button button, String key) {
        this.bindStringToLocale(button.textProperty(), key);
    }

    public void bindStringToLocale(Label label, String key) {
        this.bindStringToLocale(label.textProperty(), key);
    }

    public void bindStringToLocale(Button button, String key, javafx.scene.text.Font originalFont) {
        button.textProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Button)button, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + button.getText() + " | PrefWidth: " + button.getPrefWidth() + " | MaxWidth: " + button.getMaxWidth());
        });
        button.widthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Button)button, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + button.getText() + " | PrefWidth: " + button.getPrefWidth() + " | MaxWidth: " + button.getMaxWidth());
        });
        button.prefWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Button)button, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + button.getText() + " | PrefWidth: " + button.getPrefWidth() + " | MaxWidth: " + button.getMaxWidth());
        });
        button.maxWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Button)button, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + button.getText() + " | PrefWidth: " + button.getPrefWidth() + " | MaxWidth: " + button.getMaxWidth());
        });
        button.minWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Button)button, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + button.getText() + " | PrefWidth: " + button.getPrefWidth() + " | MaxWidth: " + button.getMaxWidth());
        });
        this.bindStringToLocale(button, key);
    }

    public void bindStringToLocale(Label label, String key, javafx.scene.text.Font originalFont) {
        label.textProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Label)label, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + label.getText() + " | PrefWidth: " + label.getPrefWidth() + " | MaxWidth: " + label.getMaxWidth());
        });
        label.widthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Label)label, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + label.getText() + " | PrefWidth: " + label.getPrefWidth() + " | MaxWidth: " + label.getMaxWidth());
        });
        label.maxWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Label)label, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + label.getText() + " | PrefWidth: " + label.getPrefWidth() + " | MaxWidth: " + label.getMaxWidth());
        });
        label.prefWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Label)label, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + label.getText() + " | PrefWidth: " + label.getPrefWidth() + " | MaxWidth: " + label.getMaxWidth());
        });
        label.minWidthProperty().addListener((observable, oldValue, newValue) -> {
            FontUtils.setIdealFont((Label)label, (javafx.scene.text.Font)originalFont);
            System.out.println("Setting for: " + label.getText() + " | PrefWidth: " + label.getPrefWidth() + " | MaxWidth: " + label.getMaxWidth());
        });
        this.bindStringToLocale(label, key);
    }

    public void bindStringToLocale(StringProperty stringProperty, String key) {
        stringProperty.bind((ObservableValue)Bindings.createStringBinding(() -> ResourceBundle.getBundle(this.stringBundleName, this.activeConfig.getSelectedLocale()).getString(key), (Observable[])new Observable[]{this.activeConfig.selectedLocaleProperty()}));
    }

    public void removeAllChildren(Pane pane) {
        pane.getChildren().removeAll((Collection)pane.getChildren());
    }

    protected Controller switchToScene(String resourceName) {
        try {
            String cssFilePath = resourceName.substring(0, resourceName.length() - 4) + "css";
            URL res = this.getClass().getResource(resourceName);
            FXMLLoader loader = new FXMLLoader(res, this.strings);
            loader.setControllerFactory(arg_0 -> ((ApplicationContext)ApplicationContextUtils.getApplicationContext()).getBean(arg_0));
            Parent parent = (Parent)loader.load();
            Controller controller = (Controller)loader.getController();
            if (loader.getController() instanceof CashierBaseController) {
                controller = (CashierBaseController)loader.getController();
            }
            controller.setupStage(this.stage, this.strings);
            this.stage.getScene().setRoot(parent);
            this.stage.getScene().setFill((Paint)Color.TRANSPARENT);
            URL cssFile = this.getClass().getResource(cssFilePath);
            if (cssFile != null) {
                String css = cssFile.toExternalForm();
                this.stage.getScene().getStylesheets().removeAll((Collection)this.stage.getScene().getStylesheets());
                this.stage.getScene().getStylesheets().add((Object)css);
            }
            this.stage.show();
            return controller;
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    protected void switchToCartScene() {
        this.switchToScene("/cz/polreich/spagetka/orderConfirmation.fxml");
    }

    protected void switchToMainScene() {
        this.switchToScene("/cz/polreich/spagetka/main.fxml");
    }

    protected void switchToOrderManagementScene() {
        this.switchToScene("/cz/polreich/spagetka/orderManagement.fxml");
    }

    public void switchToOrderManagementSceneWithOrder(Config c3, String orderId) {
        OrderManagementController controller = (OrderManagementController)this.switchToScene("/cz/polreich/spagetka/orderManagement.fxml");
        controller.loadOrderById(orderId);
    }

    protected void switchToCashierScene(Config c3) {
        this.switchToScene("/cz/polreich/spagetka/cashier.fxml");
    }

    public void resetToMainScene() {
        System.out.println("Switching to main scene.");
        this.activeConfig.setCurrentOrder(new Order());
        this.switchToMainScene();
    }
}

