/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO.discountCodes;

import cz.polreich.spagetka.models.enums.DISCOUNT_CODE_TYPE;

public class DiscountCodeVerifyResponse {
    private boolean valid;
    private double amount;
    private DISCOUNT_CODE_TYPE type;
    private String commentary;

    public DiscountCodeVerifyResponse(boolean valid, double amount, DISCOUNT_CODE_TYPE type, String commentary) {
        this.valid = valid;
        this.amount = amount;
        this.type = type;
        this.commentary = commentary;
    }

    public boolean isMonetary() {
        return DISCOUNT_CODE_TYPE.MONETARY.equals((Object)this.type) || DISCOUNT_CODE_TYPE.COMPLIMENTARY_MONETARY.equals((Object)this.type);
    }

    public boolean isPercentage() {
        return DISCOUNT_CODE_TYPE.PERCENTAGE.equals((Object)this.type) || DISCOUNT_CODE_TYPE.COMPLIMENTARY_PERCENTAGE.equals((Object)this.type);
    }

    public boolean isComplimentary() {
        return DISCOUNT_CODE_TYPE.COMPLIMENTARY_PERCENTAGE.equals((Object)this.type) || DISCOUNT_CODE_TYPE.COMPLIMENTARY_MONETARY.equals((Object)this.type);
    }

    public boolean isValid() {
        return this.valid;
    }

    public double getAmount() {
        return this.amount;
    }

    public DISCOUNT_CODE_TYPE getType() {
        return this.type;
    }

    public String getCommentary() {
        return this.commentary;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public void setType(DISCOUNT_CODE_TYPE type) {
        this.type = type;
    }

    public void setCommentary(String commentary) {
        this.commentary = commentary;
    }

    public DiscountCodeVerifyResponse() {
    }
}

