/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.controllers.loading.CashierLoadingController;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.ScreenResolution;
import cz.polreich.spagetka.service.monitoring.MonitoringRunner;
import java.awt.AWTException;
import java.io.IOException;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.scheduling.annotation.EnableScheduling;

/*
 * Exception performing whole class analysis ignored.
 */
@SpringBootApplication
@EnableScheduling
@EnableJpaRepositories(value={"cz.polreich.spagetka.repository", "cz.polreich.spagetka.service"})
@EntityScan(value={"cz.polreich.spagetka.models", "cz.polreich.spagetka.service"})
public class CashierApp
extends Application {
    private ConfigurableApplicationContext springContext;
    private CashierLoadingController cashierLoadingController;
    private Config config;
    private CashierConfig activeConfig;
    private ScreenResolution screenResolution;
    private MonitoringRunner monitoringRunner;
    String css = this.getClass().getResource("/cz/polreich/spagetka/cashier.css").toExternalForm();

    public void start(Stage stage) throws Exception {
        this.config = (Config)this.springContext.getBean(Config.class);
        this.config.setCashierSelected();
        this.activeConfig = this.config.getCashier();
        this.checkoutDisplay(stage);
        this.runMonitoringRunner();
    }

    public void stop() {
        this.springContext.stop();
        Platform.exit();
    }

    public void init() {
        this.springContext = SpringApplication.run(CashierApp.class, (String[])new String[0]);
    }

    public void checkoutDisplay(Stage stage) throws IOException, AWTException {
        Rectangle2D screenBounds;
        int sceneWidth = 600;
        int sceneHeight = 400;
        ResourceBundle strings = ResourceBundle.getBundle("resources.strings.cashier", this.activeConfig.getSelectedLocale());
        FXMLLoader loader = new FXMLLoader(CashierApp.class.getResource("loadingCashier.fxml"), strings);
        loader.setControllerFactory(arg_0 -> ((ConfigurableApplicationContext)this.springContext).getBean(arg_0));
        Parent root = (Parent)loader.load();
        this.cashierLoadingController = (CashierLoadingController)loader.getController();
        this.cashierLoadingController.setupStage(stage, strings);
        Scene scene = new Scene(root, (double)sceneWidth, (double)sceneHeight);
        scene.getStylesheets().add((Object)this.css);
        stage.setScene(scene);
        stage.setResizable(true);
        stage.setFullScreen(false);
        stage.setTitle("Spagetka BranchCheckout loader v0.0.1");
        try {
            screenBounds = ((Screen)Screen.getScreens().get(this.activeConfig.getDisplayConfig().getScreenId())).getVisualBounds();
        }
        catch (Exception e) {
            screenBounds = ((Screen)Screen.getScreens().get(0)).getVisualBounds();
        }
        stage.setX((screenBounds.getWidth() - (double)sceneWidth) / 2.0 + screenBounds.getMinX());
        stage.setY((screenBounds.getHeight() - (double)sceneHeight) / 2.0 + screenBounds.getMinY());
        stage.show();
    }

    private void runMonitoringRunner() {
        MonitoringRunner monitoringRunner = (MonitoringRunner)this.springContext.getBean(MonitoringRunner.class);
        monitoringRunner.setPartnerServerRestClient(this.activeConfig.getPartnerServerRestClient());
        ((MonitoringRunner)this.springContext.getBean(MonitoringRunner.class)).run();
    }

    public static void main(String[] args) {
        CashierApp.launch(CashierApp.class, (String[])args);
    }
}

