/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.monitoring;

import cz.polreich.spagetka.models.enums.COMPUTER;
import cz.polreich.spagetka.models.enums.COMPUTER_MANAGEMENT_ACTION;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.computer_command_service.SshCommandExecutor;
import cz.polreich.spagetka.service.computer_command_service.model.CommandExecutorResult;
import cz.polreich.spagetka.service.monitoring.model.KioskStage;
import cz.polreich.spagetka.service.monitoring.model.MonitoringData;
import cz.polreich.spagetka.service.monitoring.service.CashierActiveConfigService;
import cz.polreich.spagetka.utils.appmetadata.AppMetadataUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MonitoringService {
    private static final Logger log = LoggerFactory.getLogger(MonitoringService.class);
    private final CashierActiveConfigService cashierActiveConfigService;
    private final OrderService orderService;
    private final SshCommandExecutor sshCommandExecutor;

    @Autowired
    public MonitoringService(CashierActiveConfigService cashierActiveConfigService, OrderService orderService, SshCommandExecutor sshCommandExecutor) {
        this.cashierActiveConfigService = cashierActiveConfigService;
        this.orderService = orderService;
        this.sshCommandExecutor = sshCommandExecutor;
    }

    public MonitoringData createMonitoringData() {
        MonitoringData data = new MonitoringData();
        data.setKioskName(this.cashierActiveConfigService.getKioskName());
        data.setTimestamp(System.currentTimeMillis());
        this.cashierActiveConfigService.serLoggedUserForKioskStage(data);
        data.setConfirmedOrdersQuantity(this.orderService.countAllOrdersByTodayAndOrdersStatusList(List.of(ORDER_STATUS.CONFIRMED)));
        data.setPendingOrdersQuantity(this.orderService.countAllOrdersByTodayAndOrdersStatusList(List.of(ORDER_STATUS.WAITING_FOR_PICKUP, ORDER_STATUS.WAITING_FOR_DELIVERY)));
        for (COMPUTER computer : COMPUTER.values()) {
            CommandExecutorResult commandExecutorResult = this.sshCommandExecutor.getFreeSpaceInMBInformation(computer, COMPUTER_MANAGEMENT_ACTION.DISK_USAGE_SYNC_CMD);
            data.addKioskStage(this.createKioskStage(data.getKioskName(), commandExecutorResult));
        }
        data.setVersion(AppMetadataUtil.getAppVersionNumber());
        log.debug(data.toString());
        return data;
    }

    private KioskStage createKioskStage(String kioskName, CommandExecutorResult commandExecutorResult) {
        KioskStage kioskStage = new KioskStage();
        kioskStage.setKioskName(kioskName);
        kioskStage.setKioskStageName(commandExecutorResult.getComputer().getName());
        kioskStage.setComputerIsReachable(commandExecutorResult.isComputerIsReachable());
        kioskStage.setFreeSpaceMB(commandExecutorResult.getFreeSpaceMB());
        kioskStage.setFreeSpaceInPercent(commandExecutorResult.getFreeSpaceInPercent());
        log.debug(kioskStage.toString());
        return kioskStage;
    }
}

