/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.layout.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.layout.cashierController.OrderVBox;
import cz.polreich.spagetka.controllers.popup.cashierController.OrderVboxService;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderVBox {
    @FXML
    private FlowPane ordersFlowPane;
    boolean isFlowPaneExtended = false;
    CashierController cashierController;
    Timer timer;
    private List<Order> orders;
    Image imageEatIn;
    Image imageTakeAway;
    Image imageDelivery;
    Image imagePickup;
    Image imageOnline;
    Image imageUnknown;
    Image imageCustomerNote;
    Image imageFirstOrder;
    Image imageNotRegistered;
    Image imageNoPhone;
    OrderVboxService orderVboxService;
    private VBox orderItemsVBox = null;
    FlowPane collapsedOrdersFlowPane = new FlowPane();
    double orderTileWidth = 524.0;
    private Button extendOrdersListButton;
    private List<String> showCollapsed = new ArrayList();

    public OrderVBox(OrderVboxService orderVboxService, CashierController cashierController, Image imageEatIn, Image imageTakeAway, Image imageDelivery, Image imagePickup, Image imageOnline, Image imageUnknown, Image imageCustomerNote, Image imageFirstOrder, Image imageNotRegistered, Image imageNoPhone) {
        this.showCollapsed = cashierController.activeConfig.getCollapsedOrders();
        this.imageEatIn = imageEatIn;
        this.imageTakeAway = imageTakeAway;
        this.imageDelivery = imageDelivery;
        this.imagePickup = imagePickup;
        this.imageOnline = imageOnline;
        this.imageUnknown = imageUnknown;
        this.imageCustomerNote = imageCustomerNote;
        this.imageFirstOrder = imageFirstOrder;
        this.imageNotRegistered = imageNotRegistered;
        this.imageNoPhone = imageNoPhone;
        this.ordersFlowPane = cashierController.getOrdersFlowPane();
        this.cashierController = cashierController;
        this.orderVboxService = orderVboxService;
        this.ordersFlowPane.setPadding(new Insets(6.0));
        this.ordersFlowPane.setVgap(10.0);
        this.ordersFlowPane.setHgap(20.0);
        this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.ordersFlowPane.setPrefWrapLength(Double.MAX_VALUE);
        cashierController.getOrderScrollPane().setStyle("-fx-background-color: #393F56;");
        this.extendOrdersListButton = new Button(cashierController.strings.getString("extendOrderList"));
        this.extendOrdersListButton.getStyleClass().add((Object)"order_anchor_pane_extension_button_extension");
        this.extendOrdersListButton.setPrefHeight(40.0);
        this.extendOrdersListButton.setPrefWidth(500.0);
        this.extendOrdersListButton.setOnMouseClicked(mouseEvent -> this.toggleExtendedFlowPane());
        this.collapsedOrdersFlowPane.setPrefWidth(520.0);
        this.collapsedOrdersFlowPane.setPrefHeight(0.0);
        this.collapsedOrdersFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.collapsedOrdersFlowPane.setHgap(10.0);
        this.collapsedOrdersFlowPane.setVgap(10.0);
    }

    public OrderVBox() {
    }

    public void orderVBoxAction() {
        this.ordersFlowPane.getChildren().clear();
        this.collapsedOrdersFlowPane.getChildren().clear();
        this.ordersFlowPane.getChildren().addAll((Object[])new Node[]{this.extendOrdersListButton, this.collapsedOrdersFlowPane});
        for (int i = 0; i < this.orders.size(); ++i) {
            Order order = (Order)this.orders.get(i);
            if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PAYMENT) || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) continue;
            if (this.showCollapsed.contains(order.getId())) {
                this.createCollapsedOrderVBox(order);
                continue;
            }
            this.createOrderVBox(order);
        }
    }

    private void toggleExtendedFlowPane() {
        this.orderVboxService.stopTimer();
        Platform.runLater(() -> {
            if (this.isFlowPaneExtended) {
                AnchorPane.setLeftAnchor((Node)this.cashierController.getOrderScrollPane(), (Double)480.0);
                AnchorPane.setTopAnchor((Node)this.cashierController.getOrderScrollPane(), (Double)125.0);
                this.collapsedOrdersFlowPane.setPrefWidth(520.0);
                this.isFlowPaneExtended = false;
                this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
                this.orderTileWidth = 524.0;
                this.extendOrdersListButton.setText(this.cashierController.strings.getString("extendOrderList"));
            } else {
                AnchorPane.setLeftAnchor((Node)this.cashierController.getOrderScrollPane(), (Double)10.0);
                AnchorPane.setTopAnchor((Node)this.cashierController.getOrderScrollPane(), (Double)10.0);
                this.collapsedOrdersFlowPane.setPrefWidth(1000.0);
                this.isFlowPaneExtended = true;
                this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
                this.orderTileWidth = 480.0;
                this.extendOrdersListButton.setText(this.cashierController.strings.getString("retractOrderList"));
            }
            this.orderVBoxAction();
        });
        this.orderVboxService.startTimer();
    }

    private void createCollapsedOrderVBox(Order order) {
        LocalDateTime pastDate = LocalDateTime.parse(String.valueOf(order.getToBeFinishedDateTime()));
        boolean isBefore = LocalDateTime.now().isBefore(pastDate);
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMinHeight(40.0);
        anchorPane.setPrefHeight(86.0);
        anchorPane.setMinWidth(20.0);
        anchorPane.setPrefWidth(64.0);
        anchorPane.setMaxWidth(96.0);
        anchorPane.getStyleClass().add((Object)"order_anchor_pane");
        char firstChar = order.getOrderNumber().charAt(0);
        if (Character.isLetter(firstChar)) {
            VBox vbox = new VBox();
            vbox.setPadding(LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            vbox.setSpacing(0.0);
            vbox.setAlignment(Pos.CENTER);
            vbox.setMaxWidth(96.0);
            String orderTypeText = switch (String.valueOf(firstChar)) {
                case "W" -> "Wolt";
                case "F" -> "Food";
                case "B" -> "Bolt";
                default -> "";
            };
            Label orderType = new Label(orderTypeText);
            orderType.setAlignment(Pos.CENTER);
            orderType.setFont(this.cashierController.normalFont);
            orderType.setPadding(new Insets(0.0));
            orderType.setMaxWidth(96.0);
            orderType.setAlignment(Pos.CENTER);
            orderType.setTextAlignment(TextAlignment.CENTER);
            Label orderNumber = new Label(order.getCleanOrderNumber(false));
            orderNumber.setAlignment(Pos.CENTER);
            orderNumber.setPadding(new Insets(0.0));
            orderNumber.setMaxWidth(96.0);
            orderNumber.setAlignment(Pos.CENTER);
            orderNumber.setTextAlignment(TextAlignment.CENTER);
            FontUtils.setIdealFont((Label)orderNumber, (Font)this.cashierController.titleFont);
            vbox.getChildren().addAll((Object[])new Node[]{orderType, orderNumber});
            AnchorPane.setTopAnchor((Node)vbox, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)vbox, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)vbox, (Double)0.0);
            AnchorPane.setRightAnchor((Node)vbox, (Double)0.0);
            anchorPane.getChildren().add((Object)vbox);
            if (!(isBefore || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PICKUP) || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_DELIVERY))) {
                orderType.setStyle("-fx-text-fill : #ff6666;");
                orderNumber.setStyle("-fx-text-fill : #ff6666;");
            }
        } else {
            Label orderNumber = new Label(order.getCleanOrderNumber(false));
            orderNumber.setAlignment(Pos.CENTER);
            if (orderNumber.getText().length() > 2) {
                orderNumber.setFont(this.cashierController.subtitleFont);
            } else {
                orderNumber.setFont(this.cashierController.titleFont);
            }
            AnchorPane.setLeftAnchor((Node)orderNumber, (Double)0.0);
            AnchorPane.setTopAnchor((Node)orderNumber, (Double)0.0);
            AnchorPane.setRightAnchor((Node)orderNumber, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)orderNumber, (Double)0.0);
            anchorPane.getChildren().add((Object)orderNumber);
            if (!(isBefore || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PICKUP) || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_DELIVERY))) {
                orderNumber.setStyle("-fx-text-fill : #ff6666;");
            }
        }
        anchorPane.setOnMouseClicked(mouseEvent -> this.toggleCollapsed(order));
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                anchorPane.setStyle("-fx-background-color: #A9A9A9");
                break;
            }
            case 3: {
                anchorPane.setStyle("-fx-background-color: #F8F8F8");
                break;
            }
            case 4: {
                anchorPane.setStyle("-fx-background-color: #9FE2BF");
            }
        }
        this.collapsedOrdersFlowPane.getChildren().add((Object)anchorPane);
    }

    private void createOrderVBox(Order order) {
        LocalDateTime pastDate = LocalDateTime.parse(String.valueOf(order.getToBeFinishedDateTime()));
        boolean isBefore = LocalDateTime.now().isBefore(pastDate);
        VBox outerVBox = new VBox();
        outerVBox.setSpacing(10.0);
        AnchorPane orderAnchorPane = new AnchorPane();
        orderAnchorPane.getStyleClass().add((Object)"order_anchor_pane");
        orderAnchorPane.setPrefWidth(this.orderTileWidth);
        orderAnchorPane.setMaxWidth(this.orderTileWidth);
        Label orderName = new Label(order.getCustomerFullName());
        orderName.setStyle("-fx-font-size: 16px;");
        AnchorPane.setLeftAnchor((Node)orderName, (Double)10.0);
        AnchorPane.setTopAnchor((Node)orderName, (Double)30.0);
        ImageView imageView = new ImageView();
        AnchorPane.setLeftAnchor((Node)imageView, (Double)190.0);
        AnchorPane.setTopAnchor((Node)imageView, (Double)10.0);
        imageView.setFitHeight(30.0);
        imageView.setFitWidth(30.0);
        ImageView imageViewNote = new ImageView();
        imageViewNote.setImage(this.imageCustomerNote);
        AnchorPane.setLeftAnchor((Node)imageViewNote, (Double)240.0);
        AnchorPane.setTopAnchor((Node)imageViewNote, (Double)10.0);
        imageViewNote.setFitHeight(30.0);
        imageViewNote.setFitWidth(30.0);
        ImageView imageViewFirstOrder = new ImageView();
        imageViewFirstOrder.setImage(this.imageFirstOrder);
        AnchorPane.setLeftAnchor((Node)imageViewFirstOrder, (Double)280.0);
        AnchorPane.setTopAnchor((Node)imageViewFirstOrder, (Double)10.0);
        imageViewFirstOrder.setFitHeight(30.0);
        imageViewFirstOrder.setFitWidth(30.0);
        ImageView imageViewNotRegistered = new ImageView();
        imageViewNotRegistered.setImage(this.imageNotRegistered);
        AnchorPane.setLeftAnchor((Node)imageViewNotRegistered, (Double)320.0);
        AnchorPane.setTopAnchor((Node)imageViewNotRegistered, (Double)10.0);
        imageViewNotRegistered.setFitHeight(30.0);
        imageViewNotRegistered.setFitWidth(30.0);
        ImageView imageViewNoPhone = new ImageView();
        imageViewNoPhone.setImage(this.imageNoPhone);
        AnchorPane.setLeftAnchor((Node)imageViewNoPhone, (Double)280.0);
        AnchorPane.setTopAnchor((Node)imageViewNoPhone, (Double)10.0);
        imageViewNoPhone.setFitHeight(30.0);
        imageViewNoPhone.setFitWidth(30.0);
        Label orderNumber = new Label(order.getOrderNumber());
        orderNumber.setStyle("-fx-font-size: 16px;");
        AnchorPane.setLeftAnchor((Node)orderNumber, (Double)10.0);
        AnchorPane.setTopAnchor((Node)orderNumber, (Double)10.0);
        Label orderTimePickUp = new Label(FormatUtils.formatTime((LocalDateTime)order.getToBeFinishedDateTime()));
        orderTimePickUp.setStyle("-fx-font-size: 16px;");
        AnchorPane.setRightAnchor((Node)orderTimePickUp, (Double)10.0);
        AnchorPane.setTopAnchor((Node)orderTimePickUp, (Double)10.0);
        Button refuseOrderButton = new Button(this.cashierController.strings.getString("accept"));
        refuseOrderButton.getStyleClass().add((Object)"order_anchor_pane_button");
        refuseOrderButton.setPrefWidth(150.0);
        refuseOrderButton.setOnMouseReleased(mouseEvent -> this.refuseOrderButtonAction(orderAnchorPane, order, refuseOrderButton));
        Button forPickupButton = new Button(this.cashierController.strings.getString("retrieved"));
        forPickupButton.setPrefWidth(210.0);
        forPickupButton.getStyleClass().add((Object)"order_anchor_pane_button");
        forPickupButton.setVisible(false);
        Button finishOrderButton = new Button(this.cashierController.strings.getString("done"));
        finishOrderButton.setPrefWidth(150.0);
        finishOrderButton.getStyleClass().add((Object)"order_anchor_pane_button");
        finishOrderButton.setOnMouseReleased(mouseEvent -> this.finishOrderButtonAction(orderAnchorPane, order));
        Button managementOrderButton = new Button("Spravovat");
        managementOrderButton.setPrefWidth(210.0);
        managementOrderButton.getStyleClass().add((Object)"order_anchor_pane_button");
        managementOrderButton.setVisible(true);
        managementOrderButton.setOnMouseReleased(mouseEvent -> this.cashierController.switchToOrderManagementSceneWithOrder(this.cashierController.config, order.getId()));
        forPickupButton.setOnMouseReleased(mouseEvent -> this.forPickupButtonAction(orderAnchorPane, order, forPickupButton, finishOrderButton, managementOrderButton));
        Label orderPrice = new Label("Celkem: " + FormatUtils.formatCurrency((double)order.getTotalPrice(), (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale())));
        orderPrice.setStyle("-fx-font-size: 16px;");
        AnchorPane.setRightAnchor((Node)orderPrice, (Double)10.0);
        AnchorPane.setTopAnchor((Node)orderPrice, (Double)30.0);
        HBox buttons = new HBox(10.0);
        if (!(isBefore || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PICKUP) || order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_DELIVERY))) {
            orderName.setStyle("-fx-text-fill : #ff6666;");
            orderNumber.setStyle("-fx-text-fill : #ff6666;");
            orderTimePickUp.setStyle("-fx-text-fill : #ff6666;");
            orderPrice.setStyle("-fx-text-fill : #ff6666;");
        }
        Label orderTypeLabel = new Label();
        AnchorPane.setLeftAnchor((Node)orderTypeLabel, (Double)165.0);
        AnchorPane.setTopAnchor((Node)orderTypeLabel, (Double)40.0);
        if (order.getOrderType() == null) {
            imageView.setImage(this.imageUnknown);
            orderTypeLabel.setText(this.cashierController.strings.getString("unknown"));
        } else if (order.getOrderType().equals((Object)ORDER_TYPE.PERSONAL_HERE)) {
            imageView.setImage(this.imageEatIn);
            orderTypeLabel.setText(this.cashierController.strings.getString("eatIn"));
        } else if (order.getOrderType().equals((Object)ORDER_TYPE.PERSONAL_TAKE_AWAY)) {
            imageView.setImage(this.imageTakeAway);
            orderTypeLabel.setText(this.cashierController.strings.getString("takeAway"));
        } else if (order.isDelivery()) {
            imageView.setImage(this.imageDelivery);
            orderTypeLabel.setText(this.cashierController.strings.getString("delivery"));
            if (order.getOrderType().equals((Object)ORDER_TYPE.WOLT)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Wolt");
            } else if (order.getOrderType().equals((Object)ORDER_TYPE.FOODORA)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Foodora");
            } else if (order.getOrderType().equals((Object)ORDER_TYPE.BOLT)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Bolt");
            }
        } else if (order.isPickup()) {
            imageView.setImage(this.imagePickup);
            orderTypeLabel.setText(this.cashierController.strings.getString("pickup"));
            if (order.getOrderType().equals((Object)ORDER_TYPE.WOLT_PICKUP)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Wolt");
            } else if (order.getOrderType().equals((Object)ORDER_TYPE.FOODORA_PICKUP)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Foodora");
            } else if (order.getOrderType().equals((Object)ORDER_TYPE.BOLT_PICKUP)) {
                orderTypeLabel.setText(orderTypeLabel.getText() + " Bolt");
            }
        } else if (order.getOrderType().equals((Object)ORDER_TYPE.ONLINE)) {
            imageView.setImage(this.imageOnline);
            orderTypeLabel.setText(this.cashierController.strings.getString("online"));
        } else {
            imageView.setImage(this.imageUnknown);
            orderTypeLabel.setText(this.cashierController.strings.getString("unknown"));
        }
        AnchorPane.setLeftAnchor((Node)orderTypeLabel, (Double)180.0);
        AnchorPane.setTopAnchor((Node)orderTypeLabel, (Double)40.0);
        orderAnchorPane.setOnMouseClicked(mouseEvent -> this.toggleCollapsed(order));
        this.orderItemsVBox = this.createOrderItemVBox(order);
        orderAnchorPane.getChildren().add((Object)this.orderItemsVBox);
        orderAnchorPane.getChildren().addAll((Object[])new Node[]{orderNumber, orderName, imageView, orderPrice, orderTimePickUp, orderTypeLabel});
        if (ValidationUtils.isStringNotNullOrEmpty((String)order.getCustomerDescription())) {
            orderAnchorPane.getChildren().add((Object)imageViewNote);
        }
        if (order.isCustomerEvaluated().booleanValue()) {
            if (order.isCustomerFirstOrder() != null && order.isCustomerFirstOrder().booleanValue()) {
                orderAnchorPane.getChildren().add((Object)imageViewFirstOrder);
            }
            if (order.isCustomerRegistered() != null && !order.isCustomerRegistered().booleanValue()) {
                orderAnchorPane.getChildren().add((Object)imageViewNotRegistered);
            }
        }
        if (order.getCustomerPhoneNumber().trim().isEmpty()) {
            orderAnchorPane.getChildren().add((Object)imageViewNoPhone);
        }
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: {
                buttons.getChildren().add((Object)refuseOrderButton);
                buttons.getChildren().add((Object)managementOrderButton);
                managementOrderButton.setVisible(true);
                break;
            }
            case 2: {
                buttons.getChildren().add((Object)forPickupButton);
                buttons.getChildren().add((Object)managementOrderButton);
                forPickupButton.setVisible(true);
                managementOrderButton.setVisible(true);
                orderAnchorPane.setStyle("-fx-background-color: #A9A9A9");
                break;
            }
            case 3: {
                buttons.getChildren().add((Object)forPickupButton);
                buttons.getChildren().add((Object)managementOrderButton);
                forPickupButton.setVisible(true);
                managementOrderButton.setVisible(true);
                orderAnchorPane.setStyle("-fx-background-color: #F8F8F8");
                break;
            }
            case 4: {
                managementOrderButton.setVisible(true);
                buttons.getChildren().add((Object)managementOrderButton);
                buttons.getChildren().add((Object)finishOrderButton);
                orderAnchorPane.setStyle("-fx-background-color: #9FE2BF");
            }
        }
        outerVBox.getChildren().addAll((Object[])new Node[]{orderAnchorPane, buttons});
        this.ordersFlowPane.getChildren().addAll((Object[])new Node[]{outerVBox});
    }

    private void toggleCollapsed(Order order) {
        this.orderVboxService.stopTimer();
        Platform.runLater(() -> {
            if (this.showCollapsed.contains(order.getId())) {
                this.showCollapsed.remove(order.getId());
            } else {
                this.showCollapsed.add(order.getId());
            }
        });
        this.orderVBoxAction();
        this.orderVboxService.startTimer();
    }

    private VBox createOrderItemVBox(Order order) {
        VBox orderItemsVBox = new VBox();
        AnchorPane.setTopAnchor((Node)orderItemsVBox, (Double)65.0);
        AnchorPane.setLeftAnchor((Node)orderItemsVBox, (Double)10.0);
        orderItemsVBox.setSpacing(10.0);
        orderItemsVBox.setPadding(new Insets(10.0));
        orderItemsVBox.setStyle("-fx-border-style: solid none none none ;-fx-border-color: #C0C0C0;");
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem.getMainProduct().getPackagingItem().booleanValue()) continue;
            HBox orderItemsHBox = LayoutUtils.createOrderItemsList((OrderItem)orderItem, (String)this.cashierController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.cashierController.activeConfig.getSelectedLocale()), (double)(this.orderTileWidth - 60.0));
            orderItemsVBox.getChildren().add((Object)orderItemsHBox);
        }
        return orderItemsVBox;
    }

    public void loadNewOrders(List<Order> orders) {
        this.orders = orders;
        this.orderVBoxAction();
        List<Order> deliveryOrders = orders.stream().filter(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)).toList();
        if (!deliveryOrders.isEmpty()) {
            for (Order woltOrder : deliveryOrders) {
                woltOrder.setOrderStatus(ORDER_STATUS.CONFIRMED);
                this.cashierController.orderService.update(woltOrder);
            }
        }
    }

    private void refuseOrderButtonAction(AnchorPane orderAnchorPane, Order order, Button rejectOrderButton) {
        if (!this.cashierController.scrolling.booleanValue()) {
            this.orderVboxService.stopTimer();
            orderAnchorPane.setStyle("-fx-background-color: #90EE90");
            order.setOrderStatus(ORDER_STATUS.REJECTED);
            order.setUserConfirmed((User)this.cashierController.activeConfig.getLoggedInCashier().get());
            this.cashierController.orderService.update(order);
            rejectOrderButton.setVisible(false);
            this.orderVBoxAction();
            this.orderVboxService.startTimer();
        }
    }

    private void forPickupButtonAction(AnchorPane orderAnchorPane, Order order, Button showOrderButton, Button finishOrderButton, Button managementOrderButton) {
        if (!this.cashierController.scrolling.booleanValue()) {
            Receipt receipt;
            this.orderVboxService.stopTimer();
            order.setOrderStatus(ORDER_STATUS.WAITING_FOR_PICKUP);
            for (OrderItem orderItem : order.getOrderItems()) {
                for (int i = 0; i < orderItem.getQuantity(); ++i) {
                    this.cashierController.stockItemService.useAllStockItemsForProduct(orderItem.getMainProduct());
                    for (Product addProduct : orderItem.getAdditionalProducts()) {
                        this.cashierController.stockItemService.useAllStockItemsForProduct(addProduct);
                    }
                }
            }
            this.cashierController.orderService.update(order);
            if (order.shouldPrintReceiptOnPickupState() && this.cashierController.receiptService.existsByOrderId(order.getId()) && (receipt = this.cashierController.receiptService.findByOrderIdOnlyPositive(order.getId())) != null) {
                this.cashierController.printReceipt(receipt);
            }
            showOrderButton.setVisible(false);
            finishOrderButton.setVisible(true);
            this.orderVBoxAction();
            this.orderVboxService.startTimer();
        }
    }

    private void finishOrderButtonAction(AnchorPane orderAnchorPane, Order order) {
        if (!this.cashierController.scrolling.booleanValue()) {
            this.orderVboxService.stopTimer();
            order.setOrderStatus(ORDER_STATUS.DONE);
            order.setUserFinished((User)this.cashierController.activeConfig.getLoggedInCashier().get());
            this.cashierController.orderService.update(order);
            this.orders.remove(order);
            orderAnchorPane.setVisible(false);
            this.orderVBoxAction();
            this.orderVboxService.startTimer();
        }
    }

    private void createFXElementsByOrderStatus(Order order, AnchorPane orderAnchorPane, Button acceptOrderButton, Button finishOrderButton, Button managementOrderButton) {
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: {
                managementOrderButton.setVisible(true);
                break;
            }
            case 3: {
                orderAnchorPane.setStyle("-fx-background-color: #90EE90; -fx-background-radius : 10 10 10 10;\n    -fx-font-size : 15px;\n    -fx-font-family: \"Century Gothic\";");
                orderAnchorPane.setPrefHeight(50.0);
                orderAnchorPane.setMinWidth(464.0);
                orderAnchorPane.setMaxWidth(464.0);
                acceptOrderButton.setVisible(false);
                finishOrderButton.setVisible(true);
                managementOrderButton.setVisible(true);
                break;
            }
            case 2: {
                managementOrderButton.setVisible(true);
                break;
            }
            case 4: {
                managementOrderButton.setVisible(true);
                orderAnchorPane.setStyle("-fx-background-color: #9FE2BF");
            }
        }
    }

    public void stop() {
        this.timer.cancel();
        this.ordersFlowPane.getChildren().clear();
    }

    public void setFlowPaneExtended(boolean isFlowPaneExtended) {
        this.isFlowPaneExtended = isFlowPaneExtended;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public Image getImageEatIn() {
        return this.imageEatIn;
    }

    public Image getImageTakeAway() {
        return this.imageTakeAway;
    }

    public Image getImageDelivery() {
        return this.imageDelivery;
    }

    public Image getImagePickup() {
        return this.imagePickup;
    }

    public Image getImageOnline() {
        return this.imageOnline;
    }

    public Image getImageUnknown() {
        return this.imageUnknown;
    }

    public Image getImageCustomerNote() {
        return this.imageCustomerNote;
    }

    public Image getImageFirstOrder() {
        return this.imageFirstOrder;
    }

    public Image getImageNotRegistered() {
        return this.imageNotRegistered;
    }

    public Image getImageNoPhone() {
        return this.imageNoPhone;
    }

    public OrderVboxService getOrderVboxService() {
        return this.orderVboxService;
    }

    public List<String> getShowCollapsed() {
        return this.showCollapsed;
    }
}

