/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.config;

import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.CashierConfigRow;
import cz.polreich.spagetka.models.config.CommonConfig;
import cz.polreich.spagetka.models.config.CommonConfigRow;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.config.CookConfigRow;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.models.config.CustomerConfigRow;
import cz.polreich.spagetka.models.config.FontsConfig;
import cz.polreich.spagetka.service.config.CashierConfigRowService;
import cz.polreich.spagetka.service.config.CommonConfigRowService;
import cz.polreich.spagetka.service.config.CookConfigRowService;
import cz.polreich.spagetka.service.config.CustomerConfigRowService;
import cz.polreich.spagetka.service.config.FontsConfigService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.HostUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(AppConfigLoader.class);

    @Bean(name={"config"})
    public Config config(CommonConfigRowService commonConfigRowService, CashierConfigRowService cashierConfigRowService, CookConfigRowService cookConfigRowService, CustomerConfigRowService customerConfigRowService, FontsConfigService fontsConfigService) {
        Config loadedConfig = new Config();
        try {
            String hostname = HostUtils.getHostnameShort();
            List prefixes = Config.loadCountryPrefixes();
            CommonConfigRow commonFromDB = commonConfigRowService.getLatest(hostname);
            loadedConfig.setCommon(new CommonConfig(commonFromDB));
            loadedConfig.getCommon().setCountryPrefixes(prefixes);
            if (hostname.startsWith("kioskCashier")) {
                CashierConfigRow cashierFromDB = cashierConfigRowService.getLatest(hostname);
                loadedConfig.setCashier(new CashierConfig(cashierFromDB));
            }
            if (hostname.startsWith("kioskCook")) {
                CookConfigRow cookFromDB = cookConfigRowService.getLatest(hostname);
                loadedConfig.setCook(new CookConfig(cookFromDB));
                List categoryColorsFromDB = cookConfigRowService.getAllCategoryColors();
                loadedConfig.getCook().colors.setCategories(categoryColorsFromDB);
            }
            if (hostname.startsWith("kioskOrder")) {
                CustomerConfigRow customerFromDB = customerConfigRowService.getLatest(hostname);
                loadedConfig.setCustomer(new CustomerConfig(customerFromDB));
            }
            List fontsPathsFromDB = fontsConfigService.getAllPaths();
            List fontsSettingsFromDB = fontsConfigService.getAllSettingsForMachine(hostname);
            FontsConfig fontsConfig = new FontsConfig();
            fontsConfig.setPaths(fontsPathsFromDB);
            fontsConfig.setSettings(fontsSettingsFromDB);
            loadedConfig.getCommon().setFonts(fontsConfig);
            if (hostname.startsWith("kioskCashier")) {
                loadedConfig.getCashier().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCashier());
            }
            if (hostname.startsWith("kioskCook")) {
                loadedConfig.getCook().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCook());
            }
            if (hostname.startsWith("kioskOrder")) {
                loadedConfig.getCustomer().setRestClientConfig(loadedConfig.getCommon().getRestClientConfig());
                BeanUtils.copyProperties((Object)loadedConfig.getCommon(), (Object)loadedConfig.getCustomer());
            }
        }
        catch (Exception e) {
            log.error("Failed to load configuration", (Throwable)e);
            ExceptionHandler.logException((Exception)e);
        }
        return loadedConfig;
    }
}

