/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.DTO.CompositionItemDTO;
import cz.polreich.spagetka.models.ProductVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

public class ProductVariantDTO {
    private String id;
    private String name;
    private String description;
    private Double price;
    private String imageFilePath;
    private String imageBytesBase64;
    private List<CompositionItemDTO> composition = new ArrayList();
    private Boolean allowedAtKiosk;
    private Integer order;

    public ProductVariantDTO(ProductVariant productVariant) {
        this.id = productVariant.getId();
        this.name = productVariant.getName();
        this.description = productVariant.getDescription();
        this.price = productVariant.getPrice();
        this.imageFilePath = productVariant.getImageFilePath();
        this.imageBytesBase64 = productVariant.getImageBytes() == null ? null : Arrays.toString(Base64.getEncoder().encode(productVariant.getImageBytes()));
        this.composition = productVariant.getIngredients().stream().map(CompositionItemDTO::new).toList();
        this.allowedAtKiosk = productVariant.isEnabled();
        this.order = productVariant.getItemOrder();
    }

    public ProductVariantDTO() {
    }

    public ProductVariantDTO(String id, String name, String description, Double price, String imageFilePath, String imageBytesBase64, List<CompositionItemDTO> composition, Boolean allowedAtKiosk, Integer order) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.price = price;
        this.imageFilePath = imageFilePath;
        this.imageBytesBase64 = imageBytesBase64;
        this.composition = composition;
        this.allowedAtKiosk = allowedAtKiosk;
        this.order = order;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public String getImageBytesBase64() {
        return this.imageBytesBase64;
    }

    public List<CompositionItemDTO> getComposition() {
        return this.composition;
    }

    public Boolean getAllowedAtKiosk() {
        return this.allowedAtKiosk;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytesBase64(String imageBytesBase64) {
        this.imageBytesBase64 = imageBytesBase64;
    }

    public void setComposition(List<CompositionItemDTO> composition) {
        this.composition = composition;
    }

    public void setAllowedAtKiosk(Boolean allowedAtKiosk) {
        this.allowedAtKiosk = allowedAtKiosk;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }
}

