/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import cz.polreich.spagetka.repository.StockItemRepository;
import cz.polreich.spagetka.service.StockMovementLogItemsService;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockItemService {
    @Autowired
    private StockItemRepository stockItemRepository;
    @Autowired
    private StockMovementLogItemsService stockMovementLogItemsService;

    public void saveAll(List<StockItem> stockItems) {
        this.stockItemRepository.saveAll(stockItems);
    }

    public List<StockItem> findAll() {
        return this.stockItemRepository.findAll();
    }

    public List<StockItem> findAllWIthQuantityGreaterThan(double quantity) {
        return this.stockItemRepository.findByQuantityGreaterThan(quantity);
    }

    public StockItem findById(String id) {
        return (StockItem)this.stockItemRepository.findById((Object)id).get();
    }

    public StockItem findByQrCode(String qrCode) {
        return this.stockItemRepository.findByQrcode(qrCode).stream().findFirst().orElse(null);
    }

    public void save(StockItem stockItem) {
        this.stockItemRepository.save((Object)stockItem);
    }

    public boolean existsById(String id) {
        return this.stockItemRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.stockItemRepository.deleteById((Object)id);
    }

    public StockItem findSoonestExpiringByIngredientId(String ingredientId, double minimumQuantity) {
        Optional optionalItem = this.stockItemRepository.findFirstByIngredientIdAndQuantityGreaterThanEqualAndExpirationDateAfterOrderByExpirationDateAsc(ingredientId, minimumQuantity, LocalDate.now());
        return optionalItem.orElse(null);
    }

    public boolean existsByQrCodeAndLocation(String qrCode, String location) {
        return this.stockItemRepository.existsByQrcodeAndLocation(qrCode, location);
    }

    public List<StockItem> findByQrCodeAndLocation(String qrCode, String location) {
        return this.stockItemRepository.findByQrcodeAndLocation(qrCode, location);
    }

    public List<StockItem> findByLocation(String location) {
        return this.stockItemRepository.findByLocation(location);
    }

    public void useStockItemInRecipe(StockItem stockItem, Double quantity) {
        this.stockMovementLogItemsService.createUsedStockMovementForStockItem(stockItem, quantity, STOCK_MOVEMENT_ACTION.USED_IN_RECIPE);
        if (stockItem != null) {
            double newQuantity = stockItem.getQuantity() - quantity;
            if (newQuantity < 0.0) {
                System.out.println("WARNING: New quantity is lower than 0. Setting it to 0.");
                newQuantity = 0.0;
            }
            System.out.printf("Saving stock item: " + stockItem.getQrcode() + " with new quantity: " + newQuantity, new Object[0]);
            stockItem.setQuantity(newQuantity);
            this.stockItemRepository.save((Object)stockItem);
        }
    }

    public StockItem createPastaStockItem(Double quantity, Ingredient ingredient, LocalDateTime expirationDate) {
        DateTimeFormatter qrCodeDateFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        StockItem pastaStockItem = new StockItem();
        pastaStockItem.setId(UUID.randomUUID().toString());
        pastaStockItem.setQuantity(quantity.doubleValue());
        pastaStockItem.setIngredient(ingredient);
        pastaStockItem.setLocation("\u0160");
        pastaStockItem.setExpirationDate(expirationDate.toLocalDate());
        pastaStockItem.setQrcode("sti_" + ingredient.getId() + "_" + expirationDate.format(qrCodeDateFormatter));
        this.save(pastaStockItem);
        return pastaStockItem;
    }

    public void useAllStockItemsForProduct(Product product) {
        System.out.println("Stocking out product: " + product.getName() + " : " + product.getId());
        for (CompositionItem compositionItem : product.getIngredients()) {
            System.out.println("Processing composition item: " + compositionItem.getId());
            Ingredient ingredient = compositionItem.getIngredient();
            System.out.println("Ingredient being processed: " + ingredient.getName() + " : " + ingredient.getId());
            double stockItemSize = ValidationUtils.isDoubleNotNull((Double)ingredient.getAlternativeUnitRatio()) ? (ingredient.getAlternativeUnitRatio() != 0.0 ? ingredient.getAlternativeUnitRatio() : 1.0) : 1.0;
            System.out.println("Alternative ratio is: " + ingredient.getAlternativeUnitRatio() + " and effectively using: " + stockItemSize);
            double quantity = compositionItem.getQuantity() * stockItemSize;
            System.out.println("Composition Item quantity is: " + compositionItem.getQuantity() + " and calculated quantity to be stocked out is: " + quantity);
            StockItem stockItem = this.findSoonestExpiringByIngredientId(ingredient.getId(), quantity);
            if (stockItem != null) {
                System.out.println("Found soonest expiring stock item: " + stockItem.getQrcode() + " : " + stockItem.getId());
            } else {
                System.out.println("WARNING: No stock item found for ingredient: " + ingredient.getName() + " : " + ingredient.getId());
            }
            this.useStockItemInRecipe(stockItem, Double.valueOf(quantity));
        }
    }
}

