/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.MenuOptionDTO;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.persistence.EntityNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/menuOptions"})
@Tag(name="Menu Options API", description="Handles Menu Options operations")
public class MenuOptionController
extends BaseRestController {
    @Autowired
    public MenuOptionService menuOptionService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Menu Options")
    public ResponseEntity<List<MenuOptionDTO>> getAll(@RequestHeader Map<String, String> headers) {
        return this.processRequest(headers, () -> this.menuOptionService.findAll().stream().map(MenuOptionDTO::new).toList());
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Menu Option with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MenuOptionDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Menu Option with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<MenuOptionDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            try {
                return new MenuOptionDTO(this.menuOptionService.findById(id));
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Menu Option with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while getting the Menu Option!");
            }
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Menu Options", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<MenuOptionDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<MenuOptionDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<MenuOption> menuOptions = new ArrayList<MenuOption>();
            for (MenuOptionDTO dto : dtos) {
                MenuOption menuOption = new MenuOption(dto);
                menuOptions.add(menuOption);
            }
            this.menuOptionService.saveAll(menuOptions);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Menu Option with specified ID", description="Updates existing or creates a new Menu Option in case none found with provided ID")
    public ResponseEntity<MenuOptionDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody MenuOptionDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.menuOptionService.save(new MenuOption(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Menu Option with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Menu Option with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))}), @ApiResponse(responseCode="500", description="Internal Server Error - Exception occurred during execution", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            try {
                this.menuOptionService.deleteById(id);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
                if (e.getClass().equals(EntityNotFoundException.class)) {
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "The Menu Option with specified ID was not found");
                }
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Exception while deleting the Menu Option!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
    }
}

