/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.enums;

import cz.polreich.spagetka.utils.ExceptionHandler;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public enum KIOSK_ROLE {
    DISCOUNT_CODE_GENERATION(1),
    PRODUCTS_SETTINGS(2),
    ORDERS_MANAGEMENT(3),
    CANCEL_ORDER(4),
    STOCK_IN(5),
    INVENTORY_CHECK(6),
    PASTA_MAKING(7),
    CASH_DIARY_EDITS(8),
    TODAYS_INCOME(9),
    NEW_MANUAL_ORDER(10),
    KIOSK_MANAGEMENT(11),
    STOCK_OUT(12);

    private final int code;
    private static final Map<Integer, KIOSK_ROLE> MAP;

    private KIOSK_ROLE(int code) {
        this.code = code;
    }

    public static KIOSK_ROLE fromCode(int code) {
        KIOSK_ROLE role = (KIOSK_ROLE)MAP.get(code);
        if (role == null) {
            ExceptionHandler.logException((Exception)new IllegalArgumentException("Warning: Unknown kiosk role code received: " + code));
        }
        return role;
    }

    public int getCode() {
        return this.code;
    }

    static {
        MAP = Arrays.stream(KIOSK_ROLE.values()).collect(Collectors.toMap(KIOSK_ROLE::getCode, Function.identity()));
    }
}

