/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.computer_command_service;

import java.io.IOException;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandExecutor.class);
    private final String logPrefix = "[COMMAND EXECUTOR]";

    public Optional<Process> executeCommand(String[] command) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            Process process = processBuilder.start();
            log.debug("{} - Successfully started process: {}", (Object)"[COMMAND EXECUTOR]", (Object)String.join((CharSequence)" ", command));
            return Optional.of(process);
        }
        catch (IOException e) {
            log.error("{} - [ERROR] - Failed to execute command: {}", new Object[]{"[COMMAND EXECUTOR]", String.join((CharSequence)" ", command), e});
            return Optional.empty();
        }
    }
}

