/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.ExceptionHandler;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.media.Media;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHelper.class);
    private static final String BROKEN_IMAGE_PATH = "/resources/images/broken-image.png";
    private static final String location;

    public static InputStream getResourceAsStream(String filePath) {
        try {
            return ResourceHelper.class.getResourceAsStream(filePath);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public static InputStream getImageAsStream(String imageFilePath) {
        InputStream is = ResourceHelper.getResourceAsStream((String)imageFilePath);
        if (is == null && !"/resources/images/broken-image.png".equals(imageFilePath)) {
            is = ResourceHelper.getResourceAsStream((String)"/resources/images/broken-image.png");
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageView getImageViewFromResourceName(String imageFilePath) {
        try (InputStream is = ResourceHelper.getImageAsStream((String)imageFilePath);){
            if (is == null) {
                ImageView imageView2 = new ImageView();
                return imageView2;
            }
            ImageView imageView = new ImageView(new Image(is));
            return imageView;
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return new ImageView();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getImage(String imageFilePath) {
        try (InputStream is = ResourceHelper.getImageAsStream((String)imageFilePath);){
            if (is == null) {
                Image image2 = null;
                return image2;
            }
            Image image = new Image(is);
            return image;
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public static byte[] readResourceBytes(String path) throws IOException {
        try (InputStream is = ResourceHelper.class.getResourceAsStream(path);){
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
    }

    public static Image createImage(String path) {
        byte[] bytes;
        try {
            bytes = ResourceHelper.readResourceBytes((String)path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (bytes != null) {
            return new Image((InputStream)new ByteArrayInputStream(bytes));
        }
        return null;
    }

    public static String getBaseLocation() {
        if (location.contains(".jar")) {
            int i;
            String[] locArr = location.split("/");
            for (i = 0; i < locArr.length && !locArr[i].contains(".jar"); ++i) {
            }
            CharSequence[] newArray = Arrays.copyOfRange(locArr, 1, i);
            return "/" + String.join((CharSequence)"/", newArray) + "/";
        }
        return location;
    }

    public static BufferedImage loadImageFromFile(String imagePath) {
        try {
            return ImageIO.read(new File(imagePath));
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public static String convertImagePathFromExternal(String imagePath) {
        int index = imagePath.lastIndexOf(47);
        return "/resources/images/" + imagePath.substring(index + 1);
    }

    public static void transferFileWithSCP(String sourcePath, String destinationPath, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("scp", sourcePath, String.format("%s:%s", host, destinationPath));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("File transfer successful.");
            } else {
                log.error("File transfer failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            log.error("An error occurred: " + e.getMessage());
        }
    }

    public static void syncImagesByNameOnly(String sourceDir, String destinationDir, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("rsync", "-r", "--ignore-existing", sourceDir + "/", String.format("%s:%s", host, destinationDir));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("Image synchronization successful.");
            } else {
                log.error("Image synchronization failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public static List<String> getAvailableImagePaths(String folder) {
        return ResourceHelper.getAvailableFilePaths((String)folder, Set.of(".png", ".jpg", ".jpeg", ".gif"));
    }

    public static List<String> getAvailableMediaPaths(String folder) {
        return ResourceHelper.getAvailableFilePaths((String)folder, Set.of(".mp4"));
    }

    private static List<String> getAvailableFilePaths(String folder, Set<String> extensions) {
        List<String> list;
        block10: {
            Optional pathOpt = ResourceHelper.getResourceToURI((String)folder);
            if (pathOpt.isEmpty()) {
                return List.of();
            }
            Path folderPath = (Path)pathOpt.get();
            if (!Files.exists(folderPath, new LinkOption[0]) || !Files.isDirectory(folderPath, new LinkOption[0])) {
                log.warn("Folder does not exist or invalid: {}", (Object)folderPath);
                return List.of();
            }
            Stream<Path> stream = Files.list(folderPath);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> extensions.contains(ResourceHelper.getFileExtension((String)p.getFileName().toString()))).map(p -> folder + "/" + p.getFileName()).toList();
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to list files in folder: {}", (Object)folderPath, (Object)e);
                    ExceptionHandler.logException((Exception)e);
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    private static String getFileExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return idx >= 0 ? fileName.substring(idx).toLowerCase() : "";
    }

    public static Optional<Path> getResourceToURI(String resourceFolderPath) {
        try {
            URL resourceUrl = ResourceHelper.class.getResource(resourceFolderPath);
            if (resourceUrl == null) {
                log.error("{} does not exist in project", (Object)resourceFolderPath);
                return Optional.empty();
            }
            return Optional.of(Paths.get(resourceUrl.toURI()));
        }
        catch (URISyntaxException e) {
            log.error("Invalid URI syntax for resource: {}", (Object)resourceFolderPath, (Object)e);
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }

    public static Optional<Media> getMedia(String mediaPath) {
        if (mediaPath == null) {
            log.error("media path is null. Returns Optional.empty()");
            return Optional.empty();
        }
        try {
            URL url = ResourceHelper.class.getResource(mediaPath);
            if (url == null) {
                return Optional.empty();
            }
            log.info("Created new Media with path - {}", (Object)mediaPath);
            return Optional.of(new Media(url.toExternalForm()));
        }
        catch (Exception e) {
            log.error("Appeared an issue in getting mp4 by path - {}", (Object)mediaPath);
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }

    public static boolean deleteFile(String filePath) {
        try {
            URL url = ResourceHelper.class.getResource(filePath);
            if (url == null) {
                return false;
            }
            Path path = Paths.get(url.toURI());
            File file = path.toFile();
            return file.exists() && file.delete();
        }
        catch (Exception e) {
            log.error("Error deleting file {}", (Object)filePath, (Object)e);
            return false;
        }
    }

    static {
        String path = ResourceHelper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        location = path.startsWith("/") ? path.substring(1) : path;
    }
}

