/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ProductDTO;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

@Entity
@Table(name="Products")
public class Product {
    @Id
    private String id;
    @Column
    private String name;
    @Column
    private String shortName;
    @Column
    private String cookMonitorName;
    @Column
    private String receiptName;
    @Column
    private String stickerName;
    @Column
    private int category;
    @Column(length=1000)
    private String description;
    @Column
    private Double amountValue;
    @Column
    private String amountUnit;
    @Column(length=5000)
    private String ingredientsString;
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="ProductsIngredients", joinColumns={@JoinColumn(name="ingredientId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private List<CompositionItem> ingredients = new ArrayList();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="ProductsVariants", joinColumns={@JoinColumn(name="variantId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private List<ProductVariant> productVariants = new ArrayList();
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @JoinTable(name="ProductsCategoryVariants", joinColumns={@JoinColumn(name="variantId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private List<ProductFreeVariantCategory> productFreeVariantCategories = new ArrayList();
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> alergens = new ArrayList();
    @ElementCollection(fetch=FetchType.EAGER)
    private List<String> tags;
    @Column
    private Double originalPrice;
    @Column
    private Double actualPrice;
    @Column
    private Double vatPercent;
    @Column
    private String imageFilePath;
    @Column(length=1000000)
    private byte[] imageBytes;
    @Column
    private String remoteImagePath;
    @Column
    private boolean enabled;
    @Column(columnDefinition="bit default 1")
    private boolean available = true;
    @Column(columnDefinition="int default 999")
    private int itemOrder = 999;
    @Column
    private Boolean packagingItem = false;

    public Product(Product product) {
        this.id = product.getId();
        this.name = product.getName();
        this.shortName = product.getShortName();
        this.cookMonitorName = product.getCookMonitorName();
        this.receiptName = product.getReceiptName();
        this.stickerName = product.getStickerName();
        this.category = product.getCategory();
        this.description = product.getDescription();
        this.amountValue = product.getAmountValue();
        this.amountUnit = product.getAmountUnit();
        this.ingredientsString = product.getIngredientsString();
        this.ingredients = new ArrayList(product.getIngredients());
        this.productVariants = new ArrayList(product.getProductVariants());
        this.productFreeVariantCategories = new ArrayList(product.getProductFreeVariantCategories());
        this.alergens = new ArrayList(product.getAlergens());
        this.tags = new ArrayList(product.getTags());
        this.originalPrice = product.getOriginalPrice();
        this.actualPrice = product.getActualPrice();
        this.vatPercent = product.getVatPercent();
        this.imageFilePath = product.getImageFilePath();
        this.imageBytes = product.getImageBytes();
        this.remoteImagePath = product.getRemoteImagePath();
        this.enabled = product.isEnabled();
        this.available = product.isAvailable();
        this.itemOrder = product.getItemOrder();
        this.packagingItem = product.getPackagingItem();
    }

    public Product(ProductDTO dto) {
        this.createFromDTO(dto, false);
    }

    public Product(ProductDTO dto, boolean fromExternal) {
        this.createFromDTO(dto, fromExternal);
    }

    public Product(ProductVariant variant, Product originalProduct) {
        this.createFromVariant(variant, originalProduct, false);
    }

    public Product(ProductVariant variant, Product originalProduct, boolean fromExternal) {
        this.createFromVariant(variant, originalProduct, fromExternal);
    }

    private void createFromVariant(ProductVariant variant, Product originalProduct, boolean fromExternal) {
        this.id = "VAR_" + variant.getId();
        this.name = variant.getName();
        this.category = originalProduct.getCategory();
        this.description = variant.getDescription();
        this.ingredientsString = originalProduct.getIngredientsString();
        this.ingredients = variant.getIngredients();
        this.tags = originalProduct.getTags();
        this.originalPrice = originalProduct.getOriginalPrice();
        this.actualPrice = variant.getPrice();
        this.vatPercent = originalProduct.getVatPercent();
        if (fromExternal) {
            int index = variant.getImageFilePath().lastIndexOf("/");
            String fileName = variant.getImageFilePath().substring(index + 1);
            this.imageFilePath = "/resources/images/" + fileName;
        } else {
            this.imageFilePath = variant.getImageFilePath();
        }
        this.imageBytes = variant.getImageBytes();
        this.remoteImagePath = variant.getRemoteImagePath();
        this.enabled = variant.isEnabled();
        this.itemOrder = variant.getItemOrder();
    }

    private void createFromDTO(ProductDTO dto, boolean fromExternal) {
        this.id = dto.getId();
        this.name = dto.getName();
        this.shortName = dto.getShortName();
        this.cookMonitorName = dto.getCookMonitorName();
        this.receiptName = dto.getReceiptName();
        this.stickerName = dto.getStickerName();
        this.category = dto.getCategory();
        this.description = dto.getDescription();
        this.amountValue = dto.getAmountValue();
        this.amountUnit = dto.getAmountUnit();
        this.ingredientsString = dto.getIngredients();
        this.ingredients = dto.getComposition().stream().map(CompositionItem::new).collect(Collectors.toList());
        this.productVariants = new ArrayList<ProductVariant>(dto.getVariants().stream().map(v -> new ProductVariant(v, true)).toList());
        this.productFreeVariantCategories = new ArrayList<ProductFreeVariantCategory>(dto.getCategoriesVariants().stream().map(c -> new ProductFreeVariantCategory(c, true)).toList());
        this.alergens = new ArrayList(dto.getAlergens());
        this.tags = new ArrayList<String>(dto.getTags().stream().map(String::valueOf).toList());
        this.originalPrice = dto.getOriginalPrice();
        this.actualPrice = dto.getActualPrice();
        this.vatPercent = dto.getVatPercent();
        this.imageFilePath = fromExternal ? ResourceHelper.convertImagePathFromExternal((String)dto.getImageFilePath()) : dto.getImageFilePath();
        this.imageBytes = ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64()) ? DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()) : new byte[]{};
        this.remoteImagePath = dto.getImageFilePath();
        this.enabled = dto.isAllowedAtKiosk();
        this.itemOrder = dto.getOrder() != null ? dto.getOrder() : 999;
        this.packagingItem = dto.getIsPackaging();
    }

    public boolean isVegetarian() {
        return this.tags != null && !this.tags.isEmpty() && this.tags.contains("2");
    }

    public void addVariant(ProductVariant variant) {
        this.productVariants.add(variant);
    }

    public String getShortName() {
        if (this.shortName == null || this.shortName.isEmpty()) {
            return this.name;
        }
        return this.shortName;
    }

    public String getCookMonitorName() {
        if (this.cookMonitorName == null || this.cookMonitorName.isEmpty()) {
            return this.name;
        }
        return this.cookMonitorName;
    }

    public String getReceiptName() {
        if (this.receiptName == null || this.receiptName.isEmpty()) {
            return this.name;
        }
        return this.receiptName;
    }

    public String getStickerName() {
        if (this.stickerName == null || this.stickerName.isEmpty()) {
            return this.name;
        }
        return this.stickerName;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getAmountValue() {
        return this.amountValue;
    }

    public String getAmountUnit() {
        return this.amountUnit;
    }

    public String getIngredientsString() {
        return this.ingredientsString;
    }

    public List<CompositionItem> getIngredients() {
        return this.ingredients;
    }

    public List<ProductVariant> getProductVariants() {
        return this.productVariants;
    }

    public List<ProductFreeVariantCategory> getProductFreeVariantCategories() {
        return this.productFreeVariantCategories;
    }

    public List<String> getAlergens() {
        return this.alergens;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public Double getOriginalPrice() {
        return this.originalPrice;
    }

    public Double getActualPrice() {
        return this.actualPrice;
    }

    public Double getVatPercent() {
        return this.vatPercent;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public int getItemOrder() {
        return this.itemOrder;
    }

    public Boolean getPackagingItem() {
        return this.packagingItem;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public void setCookMonitorName(String cookMonitorName) {
        this.cookMonitorName = cookMonitorName;
    }

    public void setReceiptName(String receiptName) {
        this.receiptName = receiptName;
    }

    public void setStickerName(String stickerName) {
        this.stickerName = stickerName;
    }

    public void setCategory(int category) {
        this.category = category;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAmountValue(Double amountValue) {
        this.amountValue = amountValue;
    }

    public void setAmountUnit(String amountUnit) {
        this.amountUnit = amountUnit;
    }

    public void setIngredientsString(String ingredientsString) {
        this.ingredientsString = ingredientsString;
    }

    public void setIngredients(List<CompositionItem> ingredients) {
        this.ingredients = ingredients;
    }

    public void setProductVariants(List<ProductVariant> productVariants) {
        this.productVariants = productVariants;
    }

    public void setProductFreeVariantCategories(List<ProductFreeVariantCategory> productFreeVariantCategories) {
        this.productFreeVariantCategories = productFreeVariantCategories;
    }

    public void setAlergens(List<String> alergens) {
        this.alergens = alergens;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public void setOriginalPrice(Double originalPrice) {
        this.originalPrice = originalPrice;
    }

    public void setActualPrice(Double actualPrice) {
        this.actualPrice = actualPrice;
    }

    public void setVatPercent(Double vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public void setItemOrder(int itemOrder) {
        this.itemOrder = itemOrder;
    }

    public void setPackagingItem(Boolean packagingItem) {
        this.packagingItem = packagingItem;
    }

    public Product() {
    }

    public Product(String id, String name, String shortName, String cookMonitorName, String receiptName, String stickerName, int category, String description, Double amountValue, String amountUnit, String ingredientsString, List<CompositionItem> ingredients, List<ProductVariant> productVariants, List<ProductFreeVariantCategory> productFreeVariantCategories, List<String> alergens, List<String> tags, Double originalPrice, Double actualPrice, Double vatPercent, String imageFilePath, byte[] imageBytes, String remoteImagePath, boolean enabled, boolean available, int itemOrder, Boolean packagingItem) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.cookMonitorName = cookMonitorName;
        this.receiptName = receiptName;
        this.stickerName = stickerName;
        this.category = category;
        this.description = description;
        this.amountValue = amountValue;
        this.amountUnit = amountUnit;
        this.ingredientsString = ingredientsString;
        this.ingredients = ingredients;
        this.productVariants = productVariants;
        this.productFreeVariantCategories = productFreeVariantCategories;
        this.alergens = alergens;
        this.tags = tags;
        this.originalPrice = originalPrice;
        this.actualPrice = actualPrice;
        this.vatPercent = vatPercent;
        this.imageFilePath = imageFilePath;
        this.imageBytes = imageBytes;
        this.remoteImagePath = remoteImagePath;
        this.enabled = enabled;
        this.available = available;
        this.itemOrder = itemOrder;
        this.packagingItem = packagingItem;
    }
}

