/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.customerMainController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.FontUtils;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;

public class CancelConfirmationPopup
extends Popup {
    private CustomerMainController customerMainController;
    private ConfirmButton confirmButton = new ConfirmButton();
    private CancelButton backButton = new CancelButton();
    private AnchorPane mainAnchorPane;
    private Label title;
    private Label description;
    private double popupMinWidth;
    private double popupMinHeight;
    private double popupMaxWidth;
    private double popupMaxHeight;

    public CancelConfirmationPopup(CustomerMainController customerMainController) {
        this.customerMainController = customerMainController;
        this.popupMinWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMinHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.3;
        this.popupMaxWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        this.popupMaxHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.9;
        double titleFlowPaneHeight = 100.0;
        double titleFlowPaneTopAnchor = 50.0;
        double descriptionFlowPaneHeight = 300.0;
        double descriptionFlowPaneTopAnchor = 200.0;
        this.mainAnchorPane = new AnchorPane();
        this.mainAnchorPane.getStyleClass().add((Object)"popup-main-pane");
        this.mainAnchorPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.mainAnchorPane.setMinWidth(this.popupMinWidth);
        this.mainAnchorPane.setMinHeight(this.popupMinHeight);
        this.mainAnchorPane.setMaxWidth(this.popupMaxWidth);
        this.mainAnchorPane.setMaxHeight(this.popupMaxHeight);
        FlowPane titleFlowPane = new FlowPane();
        titleFlowPane.setMaxHeight(titleFlowPaneHeight);
        AnchorPane.setTopAnchor((Node)titleFlowPane, (Double)titleFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)titleFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)titleFlowPane, (Double)0.0);
        titleFlowPane.setAlignment(Pos.CENTER);
        this.title = new Label();
        this.title.setMaxWidth(this.popupMaxWidth * 0.9);
        this.title.setAlignment(Pos.CENTER);
        this.title.getStyleClass().add((Object)"popup-title");
        FontUtils.setIdealFont((Label)this.title, (Font)customerMainController.popupTitleFont);
        customerMainController.bindStringToLocale(this.title, "cancelConfirmation.title", customerMainController.popupTitleFont);
        titleFlowPane.getChildren().add((Object)this.title);
        FlowPane descriptionFlowPane = new FlowPane();
        descriptionFlowPane.setMaxHeight(descriptionFlowPaneHeight);
        AnchorPane.setTopAnchor((Node)descriptionFlowPane, (Double)descriptionFlowPaneTopAnchor);
        AnchorPane.setLeftAnchor((Node)descriptionFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)descriptionFlowPane, (Double)0.0);
        descriptionFlowPane.setAlignment(Pos.CENTER);
        descriptionFlowPane.setMaxWidth(this.popupMaxWidth * 0.9);
        this.description = new Label();
        this.description.setMaxWidth(this.popupMaxWidth * 0.9);
        this.description.setAlignment(Pos.CENTER);
        this.description.getStyleClass().add((Object)"popup-title");
        FontUtils.setIdealFont((Label)this.description, (Font)customerMainController.subtitleFont);
        customerMainController.bindStringToLocale(this.description, "cancelConfirmation.description", customerMainController.subtitleFont);
        this.description.setWrapText(true);
        descriptionFlowPane.getChildren().add((Object)this.description);
        FlowPane buttonsFlowPane = new FlowPane();
        AnchorPane.setBottomAnchor((Node)buttonsFlowPane, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)buttonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)buttonsFlowPane, (Double)0.0);
        buttonsFlowPane.setAlignment(Pos.CENTER);
        buttonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        buttonsFlowPane.setHgap(50.0);
        customerMainController.bindStringToLocale((Button)this.backButton, "cancelConfirmation.button.back", customerMainController.titleFont);
        this.backButton.setPrefWidth(296.0);
        this.backButton.setPrefHeight(100.0);
        FontUtils.setIdealFont((Button)this.backButton, (Font)customerMainController.titleFont);
        this.backButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        this.backButton.setOnTouchPressed(touchEvent -> {
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        customerMainController.bindStringToLocale((Button)this.confirmButton, "cancelConfirmation.button.confirm", customerMainController.titleFont);
        this.confirmButton.setPrefWidth(296.0);
        this.confirmButton.setPrefHeight(100.0);
        FontUtils.setIdealFont((Button)this.confirmButton, (Font)customerMainController.titleFont);
        this.confirmButton.setOnMouseClicked(mouseEvent -> {
            customerMainController.cancelOrder();
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        this.confirmButton.setOnTouchPressed(touchEvent -> {
            customerMainController.cancelOrder();
            this.hide();
            customerMainController.getOverrideMainDisableProperty().set(false);
        });
        buttonsFlowPane.getChildren().addAll((Object[])new Node[]{this.backButton, this.confirmButton});
        this.mainAnchorPane.getChildren().addAll((Object[])new Node[]{titleFlowPane, descriptionFlowPane, buttonsFlowPane});
        this.getContent().add((Object)this.mainAnchorPane);
        this.setAutoHide(false);
    }

    public void loadPopup() {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.customerMainController.activeConfig.getOpenedPopups().add(this);
        this.show((Window)this.customerMainController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void hide() {
        this.customerMainController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

