/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.kioskManagementPopup.ComputerButton;
import cz.polreich.spagetka.controllers.popup.cashierController.kioskManagementPopup.GraphicalComponentsKioskManagementPopup;
import cz.polreich.spagetka.models.enums.COMPUTER;
import cz.polreich.spagetka.models.enums.COMPUTER_MANAGEMENT_ACTION;
import cz.polreich.spagetka.service.computer_command_service.CommandExecutor;
import cz.polreich.spagetka.service.computer_command_service.SshCommandExecutor;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.io.BufferedWriter;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.TilePane;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class KioskManagementPopup
extends Popup {
    private static final Logger log = LoggerFactory.getLogger(KioskManagementPopup.class);
    private final CashierController cashierController;
    private static final String FILE_PATH = "migration_pecin_4.txt";
    private static final String DIVIDER = "----- Divider -----";
    private static BufferedWriter writer;
    private GraphicalComponentsKioskManagementPopup graphicalComponentsKioskManagementPopup;
    private final SshCommandExecutor sshCommandExecutor = new SshCommandExecutor(new CommandExecutor());

    public KioskManagementPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 700;
        int popupHeight = 650;
        AnchorPane popupAnchor = new AnchorPane();
        popupAnchor.getStyleClass().add((Object)"logout_anchor_pane");
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("kioskManagement"));
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 32px; -fx-text-fill: white;");
        TilePane mainTilePane = new TilePane();
        AnchorPane.setTopAnchor((Node)mainTilePane, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)mainTilePane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)mainTilePane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)mainTilePane, (Double)50.0);
        mainTilePane.setHgap(20.0);
        mainTilePane.setVgap(20.0);
        mainTilePane.setAlignment(Pos.TOP_CENTER);
        TilePane subTilePaneForRestart = this.createTilePaneForButtons(COMPUTER_MANAGEMENT_ACTION.RESTART);
        TilePane subTilePaneForShutdown = this.createTilePaneForButtons(COMPUTER_MANAGEMENT_ACTION.SHUTDOWN);
        AnchorPane confirmationAnchorPane = this.createConfirmationAnchorPane(popupAnchor);
        Button buttonReboot = new Button("Restartovat po\u010d\u00edta\u010d");
        buttonReboot.setStyle("-fx-font-size: 24px");
        buttonReboot.setPadding(LayoutUtils.getInsets((double)15.0, (double)5.0, (double)15.0, (double)5.0));
        buttonReboot.setOnMouseClicked(e -> this.showAvailableComputersList("reboot"));
        mainTilePane.getChildren().add((Object)buttonReboot);
        Button buttonShutdown = new Button("Vypnout po\u010d\u00edta\u010d");
        buttonShutdown.setStyle("-fx-font-size: 24px");
        buttonShutdown.setPadding(LayoutUtils.getInsets((double)15.0, (double)5.0, (double)15.0, (double)5.0));
        mainTilePane.getChildren().add((Object)buttonShutdown);
        buttonShutdown.setOnMouseClicked(e -> this.showAvailableComputersList("shutdown"));
        Button closeButton = new Button();
        closeButton.setText(cashierController.strings.getString("close"));
        closeButton.setStyle("-fx-font-size: 30px");
        closeButton.setPrefWidth(150.0);
        closeButton.setPrefHeight(75.0);
        AnchorPane.setBottomAnchor((Node)closeButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)closeButton, (Double)20.0);
        AnchorPane.setRightAnchor((Node)closeButton, (Double)20.0);
        closeButton.setOnMouseClicked(mouseEvent -> this.graphicalComponentsKioskManagementPopup.closeButtonAction());
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, mainTilePane, closeButton, subTilePaneForRestart, subTilePaneForShutdown, confirmationAnchorPane});
        this.getContent().addAll((Object[])new Node[]{popupAnchor});
        this.graphicalComponentsKioskManagementPopup = GraphicalComponentsKioskManagementPopup.builder().kioskManagementPopup((Popup)this).popupAnchor(popupAnchor).labelTitle(labelTitle).mainTilePane(mainTilePane).subTilePaneForReboot(subTilePaneForRestart).subTilePaneForShutdown(subTilePaneForShutdown).confirmationAnchorPane(confirmationAnchorPane).closeButton(closeButton).build();
    }

    private void showAvailableComputersList(String action) {
        switch (action) {
            case "reboot": {
                this.graphicalComponentsKioskManagementPopup.hideAllElements();
                this.graphicalComponentsKioskManagementPopup.showRestartButtons();
                break;
            }
            case "shutdown": {
                this.graphicalComponentsKioskManagementPopup.hideAllElements();
                this.graphicalComponentsKioskManagementPopup.showShutdownButtons();
            }
        }
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        this.graphicalComponentsKioskManagementPopup.showMainButtons();
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private Button createButton(String label, COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action) {
        ComputerButton button = new ComputerButton(computer, action);
        button.setText(label);
        button.setOnMouseClicked(event -> {
            this.graphicalComponentsKioskManagementPopup.hideCloseButton();
            this.graphicalComponentsKioskManagementPopup.showConfirmationAnchorPane();
            this.graphicalComponentsKioskManagementPopup.setChosenComputerButton(button);
            String text = "Jste si jisti, \u017ee chcete " + button.getAction().getCzechTranslation().toUpperCase() + " po\u010d\u00edta\u010d '" + button.getComputer().getLabel() + "'?";
            this.graphicalComponentsKioskManagementPopup.setTextForLabelInConfirmationAnchorPane(text);
        });
        return button;
    }

    private TilePane createTilePaneForButtons(COMPUTER_MANAGEMENT_ACTION action) {
        TilePane tilepane = new TilePane();
        AnchorPane.setTopAnchor((Node)tilepane, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)tilepane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)tilepane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)tilepane, (Double)100.0);
        tilepane.setHgap(20.0);
        tilepane.setVgap(20.0);
        tilepane.setAlignment(Pos.TOP_CENTER);
        tilepane.setVisible(false);
        for (COMPUTER computer : COMPUTER.values()) {
            String label = computer.getLabel() + " " + action;
            Button buttonAction = this.createButton(label, computer, action);
            buttonAction.setStyle("-fx-font-size: 24px");
            buttonAction.setPadding(LayoutUtils.getInsets((double)15.0, (double)5.0, (double)15.0, (double)5.0));
            tilepane.getChildren().add((Object)buttonAction);
        }
        return tilepane;
    }

    private AnchorPane createConfirmationAnchorPane(AnchorPane mainAnchorPane) {
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxWidth(mainAnchorPane.getMaxWidth());
        anchorPane.setMinHeight(mainAnchorPane.getMinHeight());
        anchorPane.getStyleClass().add((Object)"logout_anchor_pane");
        AnchorPane.setTopAnchor((Node)anchorPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)anchorPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)anchorPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)anchorPane, (Double)0.0);
        Label labelTitle = new Label();
        labelTitle.setText("Aru you sure you want to do it ?");
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setWrapText(true);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 32px; -fx-text-fill: white;");
        Button yesButton = new Button();
        yesButton.setText("ANO");
        yesButton.setStyle("-fx-font-size: 32px");
        yesButton.setPrefWidth(200.0);
        yesButton.setPrefHeight(75.0);
        AnchorPane.setBottomAnchor((Node)yesButton, (Double)20.0);
        AnchorPane.setRightAnchor((Node)yesButton, (Double)20.0);
        yesButton.setOnMouseClicked(mouseEvent -> this.computerButtonAction());
        Button noButton = new Button();
        noButton.setText("NE");
        noButton.setStyle("-fx-font-size: 32px");
        noButton.setPrefWidth(200.0);
        noButton.setPrefHeight(75.0);
        AnchorPane.setBottomAnchor((Node)noButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)noButton, (Double)20.0);
        noButton.setOnMouseClicked(mouseEvent -> this.graphicalComponentsKioskManagementPopup.closeButtonAction());
        anchorPane.getChildren().setAll((Object[])new Node[]{labelTitle, yesButton, noButton});
        return anchorPane;
    }

    private void computerButtonAction() {
        this.graphicalComponentsKioskManagementPopup.closeButtonAction();
        ComputerButton chosenComputerButton = this.graphicalComponentsKioskManagementPopup.getChosenComputerButton();
        if (chosenComputerButton != null) {
            COMPUTER computer = chosenComputerButton.getComputer();
            COMPUTER_MANAGEMENT_ACTION action = chosenComputerButton.getAction();
            log.info("Executing action - {} for computer - {} with remote status - {}", new Object[]{action.getCommand(), computer.getHostname(), computer.isRemote()});
            new Thread(() -> this.sshCommandExecutor.executeComputerAction(computer, action, computer.isRemote())).start();
        } else {
            log.error("chosenComputerButton is null");
        }
    }
}

