/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka;

import cz.polreich.spagetka.utils.ExceptionHandler;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

public class HttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestExecutor.class);
    private final RestClient client;

    public HttpRequestExecutor(RestClient client) {
        this.client = client;
    }

    public boolean ping() {
        try {
            ResponseEntity response = this.client.get().uri("/", new Object[0]).retrieve().toBodilessEntity();
            return response.getStatusCode().is2xxSuccessful();
        }
        catch (RestClientException ex) {
            return false;
        }
    }

    public <T> T getRequestWithResponseBody(String uri, ParameterizedTypeReference<T> typeReference) {
        return (T)this.client.get().uri(uri, new Object[0]).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().body(typeReference);
    }

    public <T> void getRequestWithRetry(String uri, T body, String logIdentifier) {
        this.getRequestWithRetry(uri, body, logIdentifier, 1);
    }

    public <T> void getRequestWithRetry(String uri, T body, String logIdentifier, int numberOfAttempts) {
        int attempt = 0;
        boolean success = false;
        while (attempt < numberOfAttempts && !success) {
            try {
                ++attempt;
                ResponseEntity response = ((RestClient.RequestBodySpec)this.client.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(body).retrieve().toBodilessEntity();
                if (response.getStatusCode().is2xxSuccessful()) {
                    success = true;
                    continue;
                }
                RestClientException e = new RestClientException("Failure while sending GET request to server. Request: " + body + " Response: " + response + " ID: " + logIdentifier + " Attempt: " + attempt);
                ExceptionHandler.logException((Exception)((Object)e));
                Thread.sleep(5000L);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        }
    }

    public <T> void postRequest(String uri, T body) {
        this.postRequestWithRetry(uri, body, 1);
    }

    public <T> void postRequestWithRetry(String uri, T body, int numberOfAttempts) {
        int attempt = 0;
        boolean success = false;
        while (attempt < numberOfAttempts && !success) {
            ++attempt;
            try {
                ResponseEntity responseEntity = ((RestClient.RequestBodySpec)this.client.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(body).retrieve().toBodilessEntity();
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    success = true;
                } else {
                    RestClientException e = new RestClientException("Failure while sending the request " + body + " to " + uri + ". Response received: " + responseEntity);
                    ExceptionHandler.logException((Exception)((Object)e));
                }
            }
            catch (Exception e) {
                log.error("Failure while sending the request {} to {}. Error message : {}", new Object[]{body, uri, e.getMessage()});
                ExceptionHandler.logException((Exception)e);
            }
            if (success) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
    }

    public <T, R> R postRequestWithResponseBody(String uri, T body, ParameterizedTypeReference<R> responseType) {
        return (R)this.postRequestWithResponseBodyAndRetry(uri, body, responseType, 1);
    }

    public <T, R> R postRequestWithResponseBodyAndRetry(String uri, T body, ParameterizedTypeReference<R> responseType, int numberOfAttempts) {
        int attempt = 0;
        while (attempt < numberOfAttempts) {
            ++attempt;
            try {
                ResponseEntity responseEntity = ((RestClient.RequestBodySpec)this.client.post().uri(uri, new Object[0])).contentType(MediaType.APPLICATION_JSON).body(body).retrieve().toEntity(responseType);
                if (responseEntity.getStatusCode().is2xxSuccessful()) {
                    return (R)Objects.requireNonNullElseGet(responseEntity.getBody(), () -> {
                        throw new RuntimeException("Response body was null");
                    });
                }
                RestClientException e = new RestClientException("Failure while sending the request " + body + " to " + uri + ". Response received: " + responseEntity);
                ExceptionHandler.logException((Exception)((Object)e));
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        throw new RestClientException("Failed to post request " + body + " to " + uri);
    }
}

