/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.ReceiptDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.repository.ReceiptItemRepository;
import cz.polreich.spagetka.repository.ReceiptRepository;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.Triple;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReceiptService {
    @Autowired
    private ReceiptRepository receiptRepository;
    @Autowired
    private ReceiptItemRepository receiptItemRepository;
    private PartnerServerRestClient partnerServerRestClient;

    public ReceiptService() {
    }

    public ReceiptService(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    public void saveAll(List<Receipt> receipts) {
        this.receiptRepository.saveAll(receipts);
        new Thread(() -> this.partnerServerRestClient.sendReceipts(receipts.stream().map(ReceiptDTO::new).toList())).start();
    }

    public Receipt findById(String id) {
        return (Receipt)this.receiptRepository.findById((Object)id).get();
    }

    public List<Receipt> findAll() {
        return this.receiptRepository.findAll();
    }

    public List<String> findAllIds() {
        return this.receiptRepository.findAllIds();
    }

    public void save(Receipt receipt, boolean sendToPartnerWeb) {
        this.receiptRepository.save((Object)receipt);
        System.out.println("[DBG23] Receipt saved: " + receipt.getId() + " for order ID: " + receipt.getOrderId());
        if (sendToPartnerWeb) {
            new Thread(() -> this.partnerServerRestClient.sendReceipt(new ReceiptDTO(receipt))).start();
        }
    }

    public void save(Receipt receipt) {
        this.receiptRepository.save((Object)receipt);
        System.out.println("[DBG23] Receipt saved: " + receipt.getId() + " for order ID: " + receipt.getOrderId());
        new Thread(() -> this.partnerServerRestClient.sendReceipt(new ReceiptDTO(receipt))).start();
    }

    public boolean existsById(String id) {
        return this.receiptRepository.existsById((Object)id);
    }

    public void deleteById(String id) {
        this.receiptRepository.deleteById((Object)id);
    }

    public boolean existsByOrderId(String orderId) {
        return this.receiptRepository.existsByOrder_Id(orderId);
    }

    public List<Receipt> findByOrderId(String orderId) {
        return this.receiptRepository.findByOrder_Id(orderId);
    }

    public Receipt findByOrderIdOnlyPositive(String orderId) {
        return this.receiptRepository.findByOrderIdOnlyPositive(orderId).stream().findFirst().orElse(null);
    }

    public List<Receipt> findAllByOrderId(String orderId) {
        return this.receiptRepository.findAllByOrderId(orderId);
    }

    public Triple<BigDecimal, BigDecimal, BigDecimal> getIncomeForToday() {
        return this.getIncomeForDate(LocalDate.now());
    }

    public Triple<BigDecimal, BigDecimal, BigDecimal> getIncomeForDate(LocalDate day) {
        LocalDateTime start = day.atStartOfDay();
        LocalDateTime end = day.plusDays(1L).atStartOfDay().minusSeconds(1L);
        List receipts = this.receiptRepository.findReceiptsBetweenDates(start, end);
        Triple ret = new Triple();
        ret.setFirst((Object)receipts.stream().map(Receipt::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        ret.setSecond((Object)receipts.stream().filter(r -> r.getPaymentMethod().equals((Object)PAYMENT_METHOD.CASH)).map(Receipt::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        ret.setThird((Object)receipts.stream().filter(r -> r.getPaymentMethod().equals((Object)PAYMENT_METHOD.CARD)).map(Receipt::getTotalAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add));
        return ret;
    }

    public List<Receipt> findAllFromDateTime(LocalDateTime fromDateTime) {
        return this.findAllInDateTimeFrame(fromDateTime, LocalDateTime.now());
    }

    public List<Receipt> findAllToDateTime(LocalDateTime toDateTime) {
        return this.findAllInDateTimeFrame(LocalDateTime.parse("2024-01-01T00:00:00"), toDateTime);
    }

    public List<Receipt> findAllInDateTimeFrame(LocalDateTime fromDateTime, LocalDateTime toDateTime) {
        return this.receiptRepository.findReceiptsBetweenDates(fromDateTime, toDateTime);
    }

    public ReceiptItem saveReceiptItemWithSubItems(ReceiptItem item) {
        try {
            if (item.getSubItems() != null && !item.getSubItems().isEmpty()) {
                ArrayList<ReceiptItem> savedSubItems = new ArrayList<ReceiptItem>();
                for (ReceiptItem subItem : item.getSubItems()) {
                    savedSubItems.add(this.saveReceiptItemWithSubItems(subItem));
                }
                item.setSubItems(savedSubItems);
            }
            return (ReceiptItem)this.receiptItemRepository.saveAndFlush((Object)item);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public ReceiptItem saveItem(ReceiptItem item) {
        return (ReceiptItem)this.receiptItemRepository.save((Object)item);
    }

    public List<ReceiptItem> saveItems(List<ReceiptItem> items) {
        return this.receiptItemRepository.saveAll(items);
    }
}

