/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.ReceiptDTO;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.ReceiptService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/receipts"})
@Tag(name="Receipts API", description="Handles Receipts operations")
public class ReceiptController
extends BaseRestController {
    @Autowired
    public ReceiptService receiptService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Receipts")
    public ResponseEntity<List<ReceiptDTO>> getAll(@RequestHeader Map<String, String> headers, @RequestParam(required=false, name="fromDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String fromDateTimeString, @RequestParam(required=false, name="toDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String toDateTimeString) {
        return this.processRequest(headers, () -> new BaseRestController.DateRangeHandler((BaseRestController)this).handleDateRange(fromDateTimeString, toDateTimeString, arg_0 -> ((ReceiptService)this.receiptService).findAllFromDateTime(arg_0), arg_0 -> ((ReceiptService)this.receiptService).findAllToDateTime(arg_0), (arg_0, arg_1) -> ((ReceiptService)this.receiptService).findAllInDateTimeFrame(arg_0, arg_1), () -> ((ReceiptService)this.receiptService).findAll(), ReceiptDTO::new));
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Receipt with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=ReceiptDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Receipt with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<ReceiptDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.receiptService.existsById(id)) {
                return new ReceiptDTO(this.receiptService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Receipt with ID: " + id + " not found!");
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Receipts", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<ReceiptDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<ReceiptDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<Receipt> receipts = new ArrayList<Receipt>();
            for (ReceiptDTO dto : dtos) {
                Receipt receipt = new Receipt(dto);
                receipts.add(receipt);
            }
            this.receiptService.saveAll(receipts);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Receipt with specified ID", description="Updates existing or creates a new Receipts in case none found with provided ID")
    public ResponseEntity<ReceiptDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody ReceiptDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.receiptService.save(new Receipt(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Receipt with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Receipt with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            if (!this.receiptService.existsById(id)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Receipt with ID: " + id + " not found!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.receiptService.deleteById(id);
    }
}

