/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import cz.polreich.spagetka.DTO.InventoryCheckReportItemDTO;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.InventoryCheckReportItemsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/inventoryCheckReports"})
@Tag(name="InventoryCheckReportItems API", description="Handles InventoryCheckReportItems operations")
public class InventoryCheckReportItemsController
extends BaseRestController {
    @Autowired
    public InventoryCheckReportItemsService inventoryCheckReportItemsService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Inventory Check Report Items")
    public ResponseEntity<List<InventoryCheckReportItemDTO>> getAll(@RequestHeader Map<String, String> headers, @RequestParam(required=false, name="fromDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String fromDateTimeString, @RequestParam(required=false, name="toDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String toDateTimeString) {
        return this.processRequest(headers, () -> new BaseRestController.DateRangeHandler((BaseRestController)this).handleDateRange(fromDateTimeString, toDateTimeString, arg_0 -> ((InventoryCheckReportItemsService)this.inventoryCheckReportItemsService).findAllNonZeroFromDateTime(arg_0), arg_0 -> ((InventoryCheckReportItemsService)this.inventoryCheckReportItemsService).findAllNonZeroToDateTime(arg_0), (arg_0, arg_1) -> ((InventoryCheckReportItemsService)this.inventoryCheckReportItemsService).findAllNonZeroInDateTimeFrame(arg_0, arg_1), () -> ((InventoryCheckReportItemsService)this.inventoryCheckReportItemsService).findAllNonZero(), InventoryCheckReportItemDTO::new));
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Inventory Check Report Item with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InventoryCheckReportItemDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Inventory Check Report Item with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<InventoryCheckReportItemDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.inventoryCheckReportItemsService.existsById(id)) {
                return new InventoryCheckReportItemDTO(this.inventoryCheckReportItemsService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Inventory Check Report Item with ID: " + id + " not found!");
        });
    }
}

