/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import jakarta.persistence.Column;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.springframework.beans.BeanWrapperImpl;

/*
 * Exception performing whole class analysis ignored.
 */
public final class DbRowBinder {
    private DbRowBinder() {
    }

    public static <S, T> void bindNonNullColumns(S sourceRow, T targetPojo) {
        BeanWrapperImpl bw = new BeanWrapperImpl(targetPojo);
        bw.setAutoGrowNestedPaths(true);
        for (Field f : sourceRow.getClass().getDeclaredFields()) {
            Object value;
            String columnName;
            Column col = f.getAnnotation(Column.class);
            if (col == null || (columnName = col.name()) == null || columnName.isBlank() || DbRowBinder.isTechnical((String)columnName)) continue;
            f.setAccessible(true);
            try {
                value = f.get(sourceRow);
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null) continue;
            String propertyPath = DbRowBinder.toPropertyPath((String)columnName);
            try {
                bw.setPropertyValue(propertyPath, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean isTechnical(String columnName) {
        return switch (columnName) {
            case "id", "machine_id", "created_at", "updated_at", "version" -> true;
            default -> false;
        };
    }

    static String toPropertyPath(String column) {
        return Arrays.stream(column.split("__")).map(DbRowBinder::toCamelCase).reduce((a, b) -> a + "." + b).orElse(column);
    }

    static String toCamelCase(String segment) {
        String[] parts = segment.split("_");
        if (parts.length == 0) {
            return segment;
        }
        StringBuilder sb = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].isEmpty()) continue;
            sb.append(Character.toUpperCase(parts[i].charAt(0)));
            if (parts[i].length() <= 1) continue;
            sb.append(parts[i].substring(1));
        }
        return sb.toString();
    }
}

