/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateResponse;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class DiscountCodeGenerationPopup
extends Popup {
    private CashierController cashierController;
    private TextField phoneNumberTextField;
    private ComboBox<CountryPrefix> prefixComboBox = new ComboBox();
    private CancelButton cancelButton;
    private ConfirmButton generateButton;
    private FlowPane keyboardFlowPane;
    private HBox phoneInputBox;
    private FlowPane buttonsFlowPane;
    private AnchorPane popupAnchor;
    private Label codeLabel;
    private Label validityLabel;
    private Label amountLabel;
    private IntegerProperty forksCount = new SimpleIntegerProperty(0);
    private IntegerProperty spoonsCount = new SimpleIntegerProperty(0);
    private DoubleProperty forksPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty spoonsPrice = new SimpleDoubleProperty(0.0);
    private DoubleProperty totalAmount = new SimpleDoubleProperty(0.0);
    private ObjectProperty<CountryPrefix> selectedCountryPrefix = new SimpleObjectProperty();
    private ListProperty<Integer> phoneNumberSpacesList = new SimpleListProperty();
    private final ObjectProperty<TextInputControl> activeInput = new SimpleObjectProperty();

    public DiscountCodeGenerationPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        this.popupAnchor = new AnchorPane();
        this.forksPrice.set(cashierController.productService.findById(cashierController.activeConfig.getForkProductId()).getActualPrice().doubleValue());
        this.spoonsPrice.set(cashierController.productService.findById(cashierController.activeConfig.getSpoonProductId()).getActualPrice().doubleValue());
        this.totalAmount.bind((ObservableValue)Bindings.createDoubleBinding(() -> this.forksPrice.get() * (double)this.forksCount.get() + this.spoonsPrice.get() * (double)this.spoonsCount.get(), (Observable[])new Observable[]{this.forksPrice, this.spoonsPrice, this.forksCount, this.spoonsCount}));
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("discountCodeGeneration"));
        labelTitle.setFont(cashierController.titleFont);
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        this.prefixComboBox.getItems().addAll((Collection)cashierController.activeConfig.getCountryPrefixes());
        this.prefixComboBox.setMaxSize(350.0, 76.0);
        this.prefixComboBox.setMinSize(300.0, 76.0);
        this.prefixComboBox.setCellFactory(comboBox -> new /* Unavailable Anonymous Inner Class!! */);
        this.prefixComboBox.setButtonCell((ListCell)this.prefixComboBox.getCellFactory().call(null));
        this.prefixComboBox.getItems().stream().filter(item -> "+420".equals(item.getPrefix())).findFirst().ifPresent(arg_0 -> ((ComboBox)this.prefixComboBox).setValue(arg_0));
        this.selectedCountryPrefix.bind((ObservableValue)this.prefixComboBox.getSelectionModel().selectedItemProperty());
        this.phoneNumberSpacesList.bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (this.selectedCountryPrefix.get() != null) {
                String pattern = ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern();
                return FXCollections.observableList((List)this.getListOfSpaces(pattern));
            }
            return FXCollections.observableArrayList();
        }, (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.phoneNumberTextField = new TextField();
        this.phoneNumberTextField.getProperties().put((Object)"vkType", (Object)"none");
        this.phoneNumberTextField.setId("phoneNumberTextField");
        this.phoneNumberTextField.setFont(cashierController.titleFont);
        this.phoneNumberTextField.promptTextProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern(), (Observable[])new Observable[]{this.selectedCountryPrefix}));
        this.phoneNumberTextField.setAlignment(Pos.CENTER);
        this.phoneNumberTextField.requestFocus();
        this.watchActiveInput((TextInputControl)this.phoneNumberTextField);
        this.phoneInputBox = new HBox();
        this.phoneInputBox.getChildren().addAll((Object[])new Node[]{this.prefixComboBox, this.phoneNumberTextField});
        AnchorPane.setTopAnchor((Node)this.phoneInputBox, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.phoneInputBox, (Double)50.0);
        AnchorPane.setRightAnchor((Node)this.phoneInputBox, (Double)50.0);
        Label forksLabel = new Label();
        forksLabel.setText("Vidli\u010dek:");
        forksLabel.setFont(cashierController.subtitleFont);
        Label spoonsLabel = new Label();
        spoonsLabel.setText("L\u017eic:");
        spoonsLabel.setFont(cashierController.subtitleFont);
        TextField forksTextField = new TextField();
        forksTextField.getProperties().put((Object)"vkType", (Object)"none");
        forksTextField.setId("forksTextField");
        forksTextField.setFont(cashierController.titleFont);
        forksTextField.setAlignment(Pos.CENTER);
        this.watchActiveInput((TextInputControl)forksTextField);
        this.forksCount.bind((ObservableValue)Bindings.createIntegerBinding(() -> Integer.valueOf(forksTextField.getText()), (Observable[])new Observable[]{forksTextField.textProperty()}));
        TextField spoonsTextField = new TextField();
        spoonsTextField.getProperties().put((Object)"vkType", (Object)"none");
        spoonsTextField.setId("spoonsTextField");
        spoonsTextField.setFont(cashierController.titleFont);
        spoonsTextField.setAlignment(Pos.CENTER);
        this.watchActiveInput((TextInputControl)spoonsTextField);
        this.spoonsCount.bind((ObservableValue)Bindings.createIntegerBinding(() -> Integer.valueOf(spoonsTextField.getText()), (Observable[])new Observable[]{spoonsTextField.textProperty()}));
        HBox forksInputBox = new HBox();
        forksInputBox.setSpacing(20.0);
        AnchorPane.setTopAnchor((Node)forksInputBox, (Double)250.0);
        AnchorPane.setLeftAnchor((Node)forksInputBox, (Double)50.0);
        AnchorPane.setRightAnchor((Node)forksInputBox, (Double)350.0);
        forksInputBox.getChildren().addAll((Object[])new Node[]{forksLabel, forksTextField});
        HBox spoonsInputBox = new HBox();
        spoonsInputBox.setSpacing(20.0);
        AnchorPane.setTopAnchor((Node)spoonsInputBox, (Double)350.0);
        AnchorPane.setLeftAnchor((Node)spoonsInputBox, (Double)50.0);
        AnchorPane.setRightAnchor((Node)spoonsInputBox, (Double)350.0);
        spoonsInputBox.getChildren().addAll((Object[])new Node[]{spoonsLabel, spoonsTextField});
        this.keyboardFlowPane = new FlowPane();
        this.keyboardFlowPane.setAlignment(Pos.CENTER_RIGHT);
        AnchorPane.setTopAnchor((Node)this.keyboardFlowPane, (Double)200.0);
        AnchorPane.setRightAnchor((Node)this.keyboardFlowPane, (Double)20.0);
        this.keyboardFlowPane.setMaxWidth(300.0);
        GridPane keyboardGridPane = LayoutUtils.createNumberKeyboard((Font)cashierController.subtitleFont, arg_0 -> this.phoneNumber_keyboard_clicked(arg_0));
        this.keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        this.cancelButton = new CancelButton(cashierController.strings.getString("cancel"));
        this.cancelButton.setMinSize(160.0, 40.0);
        this.cancelButton.setFont(cashierController.titleFont);
        this.cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
        this.cancelButton.setOnTouchPressed(touchEvent -> this.hide());
        AnchorPane.setBottomAnchor((Node)this.cancelButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)this.cancelButton, (Double)50.0);
        this.generateButton = new ConfirmButton(cashierController.strings.getString("generate"));
        this.generateButton.setMinSize(160.0, 40.0);
        this.generateButton.setFont(cashierController.titleFont);
        this.generateButton.setOnMouseClicked(mouseEvent -> this.generateButtonAction());
        this.generateButton.setOnTouchPressed(touchEvent -> this.generateButtonAction());
        AnchorPane.setBottomAnchor((Node)this.generateButton, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)this.generateButton, (Double)250.0);
        this.generateButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.validatePhoneNumber(this.phoneNumberTextField.getText()), (Observable[])new Observable[]{this.phoneNumberTextField.textProperty()}));
        this.codeLabel = new Label();
        this.codeLabel.setFont(cashierController.subtitleFont);
        AnchorPane.setBottomAnchor((Node)this.codeLabel, (Double)150.0);
        AnchorPane.setRightAnchor((Node)this.codeLabel, (Double)150.0);
        this.validityLabel = new Label();
        this.validityLabel.setFont(cashierController.subtitleFont);
        AnchorPane.setBottomAnchor((Node)this.validityLabel, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.validityLabel, (Double)150.0);
        this.amountLabel = new Label();
        this.amountLabel.setFont(cashierController.subtitleFont);
        AnchorPane.setBottomAnchor((Node)this.amountLabel, (Double)50.0);
        AnchorPane.setRightAnchor((Node)this.amountLabel, (Double)150.0);
        this.popupAnchor.setMinWidth(650.0);
        this.popupAnchor.setMinHeight(650.0);
        this.popupAnchor.setStyle("-fx-background-color: khaki");
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.phoneInputBox, forksInputBox, spoonsInputBox, this.keyboardFlowPane, this.cancelButton, this.generateButton, this.codeLabel, this.validityLabel, this.amountLabel});
        this.enableCreationMode();
        this.getContent().add((Object)this.popupAnchor);
    }

    private void watchActiveInput(TextInputControl tic) {
        tic.focusedProperty().addListener((obs, was, is) -> {
            if (is.booleanValue()) {
                this.activeInput.set((Object)tic);
            }
        });
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private void enableCreationMode() {
        this.codeLabel.setVisible(false);
        this.validityLabel.setVisible(false);
        this.amountLabel.setVisible(false);
        this.keyboardFlowPane.setVisible(true);
        this.generateButton.setVisible(true);
        this.cancelButton.setText("Zru\u0161it");
    }

    private void enableDisplayMode(String code, LocalDateTime validity) {
        this.codeLabel.setText("K\u00f3d vytvo\u0159en: " + code);
        this.codeLabel.setVisible(true);
        this.validityLabel.setText("Platnost do: " + validity.format(DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm")));
        this.validityLabel.setVisible(true);
        this.amountLabel.setText("Hodnota: " + this.totalAmount.get() + "K\u010d");
        this.amountLabel.setVisible(true);
        this.generateButton.setVisible(false);
        this.keyboardFlowPane.setVisible(false);
        this.cancelButton.setText("Zav\u0159\u00edt");
    }

    private void generateButtonAction() {
        String phoneNumber = (((CountryPrefix)this.selectedCountryPrefix.getValue()).getPrefix() + this.phoneNumberTextField.getText()).replace(" ", "").strip();
        DiscountCodeCreateResponse response = this.cashierController.activeConfig.getPartnerServerRestClient().requestDiscountCodeCreation(this.totalAmount.get(), phoneNumber);
        if (response != null) {
            try {
                String code = response.getDiscountCode();
                LocalDateTime date = LocalDateTime.parse(response.getValidUntil(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
                this.enableDisplayMode(code, date);
                this.cashierController.printDiscountCode(code, date);
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
        } else {
            throw new RuntimeException("Club discount code response is null");
        }
    }

    private void phoneNumber_keyboard_clicked(Event e) {
        String inputId;
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        TextInputControl input = (TextInputControl)this.activeInput.get();
        String string = inputId = input != null ? input.getId() : null;
        if ("x".equals(number)) {
            this.handleBackspace(input);
            return;
        }
        if (inputId == null || inputId.equals("phoneNumberTextField")) {
            this.handlePhoneNumberInput(number);
        } else {
            this.handleSimpleNumericInput(input, number);
        }
    }

    private void handleBackspace(TextInputControl input) {
        String inputId;
        String string = inputId = input != null ? input.getId() : null;
        if (inputId == null || inputId.equals("phoneNumberTextField")) {
            if (!this.phoneNumberTextField.getText().isEmpty()) {
                int toDelete = 1;
                if (this.phoneNumberSpacesList.contains((Object)(this.phoneNumberTextField.getText().length() - 1))) {
                    toDelete = 2;
                }
                this.phoneNumberTextField.setText(this.phoneNumberTextField.getText().substring(0, this.phoneNumberTextField.getText().length() - toDelete));
            }
        } else {
            input.setText(input.getText().substring(0, input.getText().length() - 1));
        }
    }

    private void handlePhoneNumberInput(String number) {
        if (this.phoneNumberTextField.getText().length() < ((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern().length()) {
            this.phoneNumberTextField.setText(this.phoneNumberTextField.getText() + number);
            if (this.phoneNumberSpacesList.contains((Object)this.phoneNumberTextField.getText().length())) {
                this.phoneNumberTextField.setText(this.phoneNumberTextField.getText() + " ");
            }
        }
    }

    private void handleSimpleNumericInput(TextInputControl input, String number) {
        input.setText(input.getText() + number);
    }

    private List<Integer> getListOfSpaces(String input) {
        return IntStream.range(0, input.length()).filter(i -> input.charAt(i) == " ".charAt(0)).boxed().collect(Collectors.toList());
    }

    public boolean validatePhoneNumber(String phoneNumber) {
        String blankNumber = phoneNumber.replaceAll("[0-9]", "X").strip();
        return blankNumber.equals(((CountryPrefix)this.selectedCountryPrefix.get()).getPhoneNumberPattern());
    }

    public void hide() {
        this.phoneNumberTextField.setText("");
        this.enableCreationMode();
        this.prefixComboBox.getItems().stream().filter(item -> "+420".equals(item.getPrefix())).findFirst().ifPresent(arg_0 -> ((ComboBox)this.prefixComboBox).setValue(arg_0));
        super.hide();
    }
}

