/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.BugsnagSingleton;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(ExceptionHandler.class);
    private static BugsnagSingleton BUGSNAG = BugsnagSingleton.getInstance();

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (BUGSNAG != null) {
            BUGSNAG.notify(e);
        }
        LOGGER.error(timestamp + " - " + e.getMessage());
        LOGGER.error(Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        System.out.println(e.getMessage());
        e.printStackTrace();
    }

    public static void logException(Exception e) {
        ExceptionHandler.logException((Exception)e, (boolean)true);
    }

    public static void logException(Exception e, boolean reportToBugnag) {
        if (e == null) {
            return;
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        if (reportToBugnag && BUGSNAG != null) {
            BUGSNAG.notify((Throwable)e);
        }
        LOGGER.error(timestamp + " - " + e.getMessage());
        LOGGER.error(e.getMessage());
        LOGGER.error(Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining("\n")));
        System.out.println(e.getMessage());
        e.printStackTrace();
    }
}

