/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.repository.CategoryRepository;
import cz.polreich.spagetka.repository.PackageSettingsRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CategoryService {
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private PackageSettingsRepository packageSettingsRepository;

    public void saveAll(List<Category> categories) {
        this.categoryRepository.saveAll(categories);
    }

    public List<Category> findAll() {
        return this.categoryRepository.findAll();
    }

    public Category findById(Integer id) {
        if (this.categoryRepository.findById((Object)id).isPresent()) {
            return (Category)this.categoryRepository.findById((Object)id).get();
        }
        throw new EntityNotFoundException("[CategoryService] - Category with ID: " + id + "was not found. (E-154)");
    }

    public void save(Category category) {
        this.categoryRepository.save((Object)category);
    }

    public void deleteById(int id) {
        if (!this.categoryRepository.findById((Object)id).isPresent()) {
            throw new EntityNotFoundException("[CategoryService] - Category with ID: " + id + "was not found. (E-154)");
        }
        this.categoryRepository.deleteById((Object)id);
    }

    public List<Category> findByCookPosition(int cookPosition) {
        return this.categoryRepository.findByCookPosition(cookPosition);
    }
}

