/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.gui.buttons;

import javafx.scene.paint.Color;

public class ButtonColorPalette {
    private String base;
    private String gradientStart;
    private String gradientEnd;
    private String light;
    private String lighter;
    private String hoverLight;
    private String shadow = "rgba(0,0,0,0.75)";

    public ButtonColorPalette(String baseHex) {
        this.base = baseHex;
        Color baseColor = Color.web((String)baseHex);
        this.gradientStart = this.toHex(this.adjustBrightness(baseColor, -0.15));
        this.gradientEnd = this.toHex(this.adjustBrightness(baseColor, -0.25));
        this.light = this.toHex(this.adjustBrightness(baseColor, 0.15));
        this.lighter = this.toHex(this.adjustBrightness(baseColor, 0.3));
        this.hoverLight = this.toHex(this.adjustBrightness(baseColor, 0.45));
    }

    private Color adjustBrightness(Color color, double factor) {
        double r = this.clamp(color.getRed() + factor);
        double g = this.clamp(color.getGreen() + factor);
        double b = this.clamp(color.getBlue() + factor);
        return new Color(r, g, b, color.getOpacity());
    }

    private double clamp(double value) {
        return Math.max(0.0, Math.min(1.0, value));
    }

    private String toHex(Color color) {
        int r = (int)(color.getRed() * 255.0);
        int g = (int)(color.getGreen() * 255.0);
        int b = (int)(color.getBlue() * 255.0);
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public String getBase() {
        return this.base;
    }

    public String getGradientStart() {
        return this.gradientStart;
    }

    public String getGradientEnd() {
        return this.gradientEnd;
    }

    public String getLight() {
        return this.light;
    }

    public String getLighter() {
        return this.lighter;
    }

    public String getHoverLight() {
        return this.hoverLight;
    }

    public String getShadow() {
        return this.shadow;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public void setGradientStart(String gradientStart) {
        this.gradientStart = gradientStart;
    }

    public void setGradientEnd(String gradientEnd) {
        this.gradientEnd = gradientEnd;
    }

    public void setLight(String light) {
        this.light = light;
    }

    public void setLighter(String lighter) {
        this.lighter = lighter;
    }

    public void setHoverLight(String hoverLight) {
        this.hoverLight = hoverLight;
    }

    public void setShadow(String shadow) {
        this.shadow = shadow;
    }
}

