/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.OrderItemDTO;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductGroupsPrice;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.service.ProductFreeVariantService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductVariantService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.lang.invoke.LambdaMetafactory;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;

@Entity
@Access(value=AccessType.PROPERTY)
@Table(name="OrderItems")
public class OrderItem {
    private String id;
    private Product mainProduct;
    private ProductVariant mainProductVariant = null;
    private MenuOption menuOption;
    private List<Product> additionalProductsLegacy = new ArrayList();
    private List<Product> additionalProducts = new ArrayList();
    private List<OrderItem> subItems = new ArrayList();
    private List<ProductFreeVariant> freeVariants = new ArrayList();
    private String affix = "";
    private String suffix = "";
    private DoubleProperty subTotalPrice = new SimpleDoubleProperty();
    private DoubleProperty finalPrice = new SimpleDoubleProperty();
    private double discount;
    private IntegerProperty quantity = new SimpleIntegerProperty();
    private String alternativeName = "";

    public OrderItem() {
        this.addListeners();
    }

    public void addListeners() {
        this.finalPrice.addListener((observable, oldValue, newValue) -> {});
        this.subTotalPrice.addListener((observable, oldValue, newValue) -> {
            double toSet = newValue.doubleValue() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum();
            this.finalPrice.set(toSet);
        });
    }

    public IntegerProperty quantityProperty() {
        return this.quantity;
    }

    @Column(name="quantity")
    public int getQuantity() {
        return this.quantity.get();
    }

    public void setQuantity(int value) {
        this.quantity.set(value);
    }

    public DoubleProperty finalPriceProperty() {
        return this.finalPrice;
    }

    @Column(name="finalPrice")
    public double getFinalPrice() {
        return this.finalPrice.get();
    }

    public void setFinalPrice(double value) {
        this.finalPrice.set(value);
    }

    public DoubleProperty subTotalProperty() {
        return this.subTotalPrice;
    }

    @Column(name="subTotalPrice")
    public double getSubTotalPrice() {
        return this.subTotalPrice.get();
    }

    public void setSubTotalPrice(double value) {
        this.subTotalPrice.set(value);
    }

    @Transient
    public String getDisplayName() {
        String name = this.alternativeName != null && !this.alternativeName.isEmpty() ? this.alternativeName : this.getMainProduct().getReceiptName();
        Object affix = "";
        Object suffix = "";
        if (this.getAffix() != null && !this.getAffix().trim().isEmpty()) {
            affix = this.getAffix().trim() + " ";
        }
        if (this.getSuffix() != null && !this.getSuffix().trim().isEmpty()) {
            suffix = " " + this.getSuffix().trim();
        }
        return (String)affix + name + (String)suffix;
    }

    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    public String getId() {
        return this.id;
    }

    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="main_product_id")
    public Product getMainProduct() {
        return this.mainProduct;
    }

    @ManyToOne
    @JoinColumn(name="main_product_variant_id")
    public ProductVariant getMainProductVariant() {
        return this.mainProductVariant;
    }

    @ManyToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @JoinTable(name="OrderItemsAddProducts", joinColumns={@JoinColumn(name="orderItemId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    public List<Product> getAdditionalProductsLegacy() {
        return this.additionalProductsLegacy;
    }

    @Transient
    public List<Product> getAdditionalProducts() {
        if (this.getSubItems() != null && !this.getSubItems().isEmpty()) {
            return this.getSubItems().stream().map(OrderItem::getMainProduct).toList();
        }
        if (this.getAdditionalProductsLegacy() != null && !this.getAdditionalProductsLegacy().isEmpty()) {
            return this.getAdditionalProductsLegacy();
        }
        return new ArrayList<Product>();
    }

    @OneToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="order_items_sub_items", joinColumns={@JoinColumn(name="orderItemId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="subItemId", referencedColumnName="id")})
    public List<OrderItem> getSubItems() {
        return this.subItems;
    }

    public void addSubItem(OrderItem orderItem) {
        this.subItems.add(orderItem);
    }

    @ManyToMany(cascade={CascadeType.PERSIST, CascadeType.MERGE}, fetch=FetchType.EAGER)
    @JoinTable(name="OrderItemsFreeVariants", joinColumns={@JoinColumn(name="orderItemId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="freeVariantId", referencedColumnName="id")})
    public List<ProductFreeVariant> getFreeVariants() {
        return this.freeVariants;
    }

    public void setFreeVariants(List<ProductFreeVariant> freeVariants) {
        this.freeVariants = freeVariants;
        double variantsPrice = freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum();
        this.finalPrice.set(this.getSubTotalPrice() + variantsPrice);
    }

    @Column
    public String getAffix() {
        return this.affix;
    }

    @Column
    public String getSuffix() {
        return this.suffix;
    }

    @Column
    public double getDiscount() {
        return this.discount;
    }

    @Column
    public String getAlternativeName() {
        return this.alternativeName;
    }

    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public MenuOption getMenuOption() {
        return this.menuOption;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public OrderItem(OrderItemDTO dto) {
        this.addListeners();
        this.id = dto.getId();
        ProductService productService = (ProductService)ApplicationContextUtils.getApplicationContext().getBean(ProductService.class);
        if (!productService.existsById(dto.getMainProductId())) {
            throw new InvalidParameterException("Product with ID " + dto.getMainProductId() + " not found.");
        }
        this.mainProduct = productService.findById(dto.getMainProductId());
        ProductVariantService productVariantService = (ProductVariantService)ApplicationContextUtils.getApplicationContext().getBean(ProductVariantService.class);
        System.out.println("Variant ID: " + dto.getVariantId());
        if (dto.getVariantId() != null) {
            System.out.println("Variant ID is not null");
            if (!productVariantService.existById(dto.getVariantId())) throw new InvalidParameterException("Product Variant with ID " + dto.getVariantId() + " not found.");
            System.out.println("Variant ID exists");
            this.mainProductVariant = productVariantService.findById(dto.getVariantId());
            System.out.println("Variant ID found: " + this.mainProductVariant.getName());
            this.affix = this.mainProductVariant.getName();
            System.out.println("Affix set to: " + this.affix);
        } else {
            System.out.println("Variant ID is null");
        }
        MenuOptionService menuOptionService = (MenuOptionService)ApplicationContextUtils.getApplicationContext().getBean(MenuOptionService.class);
        if (dto.getMenuId() != null && !dto.getMenuId().isEmpty()) {
            this.menuOption = menuOptionService.findById(dto.getMenuId());
            this.affix = "Menu: ";
            this.setAlternativeName(this.menuOption.getName());
        }
        this.additionalProducts = productService.findByIdIn(dto.getAdditionalProductsIds());
        this.subItems = dto.getSubItems().stream().map(OrderItem::new).toList();
        ProductFreeVariantService productFreeVariantsService = (ProductFreeVariantService)ApplicationContextUtils.getApplicationContext().getBean(ProductFreeVariantService.class);
        this.freeVariants = productFreeVariantsService.findByIdIn(dto.getFreeVariantsIds());
        if (!dto.getAffix().isEmpty()) {
            this.affix = dto.getAffix() + " " + this.affix;
        }
        this.suffix = dto.getSuffix();
        this.discount = dto.getDiscount();
        this.subTotalPrice.set(dto.getSubTotalPrice().doubleValue());
        this.finalPrice.set(dto.getFinalPrice().doubleValue());
        this.quantity.set(dto.getQuantity());
    }

    public OrderItem(Product mainProduct) {
        this.addListeners();
        this.mainProduct = mainProduct;
        this.subTotalPrice.set(mainProduct.getActualPrice().doubleValue());
        this.finalPrice.set(this.getSubTotalPrice() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum());
        this.discount = 0.0;
        this.quantity.set(1);
    }

    public OrderItem(Product mainProduct, ProductGroupsPrice productGroupsPrice) {
        this.addListeners();
        this.mainProduct = mainProduct;
        this.subTotalPrice.set(productGroupsPrice.getPrice().doubleValue());
        this.finalPrice.set(this.getSubTotalPrice() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum());
        this.discount = 0.0;
        this.quantity.set(1);
    }

    public OrderItem(Product mainProduct, double discount) {
        this.addListeners();
        this.mainProduct = mainProduct;
        this.subTotalPrice.set(mainProduct.getActualPrice() - discount);
        this.finalPrice.set(this.getSubTotalPrice() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum());
        this.discount = discount;
        this.quantity.set(1);
    }

    public OrderItem(Product product, ProductVariant variant) {
        this.addListeners();
        ProductService productService = (ProductService)ApplicationContextUtils.getApplicationContext().getBean(ProductService.class);
        ProductVariantService productVariantService = (ProductVariantService)ApplicationContextUtils.getApplicationContext().getBean(ProductVariantService.class);
        this.mainProduct = productService.findById(variant.getId().replace("PROD_", "").trim());
        this.mainProductVariant = productVariantService.findById(product.getId().replace("VAR_", "").trim());
        this.affix = product.getName();
        this.subTotalPrice.set(product.getActualPrice() + variant.getPrice());
        this.finalPrice.set(this.getSubTotalPrice() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum());
        this.discount = 0.0;
        this.quantity.set(1);
    }

    public OrderItem(MenuOption menuOption, boolean addAffix) {
        this.addListeners();
        this.createFromMenuOption(menuOption, addAffix);
    }

    public OrderItem(MenuOption menuOption) {
        this.addListeners();
        this.createFromMenuOption(menuOption, true);
    }

    private void createFromMenuOption(MenuOption menuOption, boolean addAffix) {
        this.mainProduct = menuOption.getMainProduct();
        this.subTotalPrice.set(menuOption.getPrice().doubleValue());
        this.menuOption = menuOption;
        this.finalPrice.set(this.getSubTotalPrice() + this.freeVariants.stream().mapToDouble(ProductFreeVariant::getPrice).sum());
        if (addAffix) {
            this.affix = "Menu: ";
        }
        this.setAlternativeName(menuOption.getName());
        this.discount = 0.0;
        this.quantity.set(1);
    }

    @Transient
    public boolean isMenu() {
        return this.affix.equals("Menu: ") || this.menuOption != null;
    }

    public void increaseQuantity() {
        this.quantity.set(this.getQuantity() + 1);
    }

    public void decreaseQuantity() {
        this.quantity.set(this.getQuantity() - 1);
    }

    /*
     * Unable to fully structure code
     */
    public boolean areSameProductAndMenuOption(OrderItem orderItem) {
        productSame = this.mainProduct.getId().equals(orderItem.getMainProduct().getId());
        v0 = variantSame = this.mainProductVariant == null && orderItem.mainProductVariant == null || this.mainProductVariant != null && orderItem.mainProductVariant != null && this.mainProductVariant.getId().equals(orderItem.getMainProductVariant().getId()) != false;
        if (this.freeVariants == null && orderItem.freeVariants == null) ** GOTO lbl-1000
        if (this.freeVariants != null && orderItem.freeVariants != null) {
            if (this.freeVariants.stream().map((Function<ProductFreeVariant, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/ProductFreeVariant;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(orderItem.getFreeVariants().stream().map((Function<ProductFreeVariant, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/ProductFreeVariant;)Ljava/lang/String;)()).toList()))) {
                ** if (!orderItem.freeVariants.stream().map((Function<ProductFreeVariant, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/ProductFreeVariant;)Ljava/lang/String;)()).allMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(this.getFreeVariants().stream().map((Function<ProductFreeVariant, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/ProductFreeVariant;)Ljava/lang/String;)()).toList()))) goto lbl-1000
            }
        }
        ** GOTO lbl-1000
lbl-1000:
        // 2 sources

        {
            v1 = true;
            ** GOTO lbl17
        }
lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
lbl17:
        // 2 sources

        freeVariantsSame = v1;
        thisIds = new HashSet<String>(this.getAdditionalProducts().stream().map((Function<Product, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/Product;)Ljava/lang/String;)()).toList());
        itemIds = new HashSet<String>(orderItem.getAdditionalProducts().stream().map((Function<Product, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcz/polreich/spagetka/models/Product;)Ljava/lang/String;)()).toList());
        addProductsSame = thisIds.size() == itemIds.size() && thisIds.containsAll(itemIds) != false && itemIds.containsAll(thisIds) != false;
        priceSame = this.finalPrice.get() == orderItem.getFinalPrice();
        return productSame != false && variantSame != false && addProductsSame != false && priceSame != false && freeVariantsSame != false;
    }

    public OrderItem(String id, Product mainProduct, ProductVariant mainProductVariant, MenuOption menuOption, List<Product> additionalProductsLegacy, List<Product> additionalProducts, List<OrderItem> subItems, List<ProductFreeVariant> freeVariants, String affix, String suffix, DoubleProperty subTotalPrice, DoubleProperty finalPrice, double discount, IntegerProperty quantity, String alternativeName) {
        this.id = id;
        this.mainProduct = mainProduct;
        this.mainProductVariant = mainProductVariant;
        this.menuOption = menuOption;
        this.additionalProductsLegacy = additionalProductsLegacy;
        this.additionalProducts = additionalProducts;
        this.subItems = subItems;
        this.freeVariants = freeVariants;
        this.affix = affix;
        this.suffix = suffix;
        this.subTotalPrice = subTotalPrice;
        this.finalPrice = finalPrice;
        this.discount = discount;
        this.quantity = quantity;
        this.alternativeName = alternativeName;
    }

    public String toString() {
        return "OrderItem(id=" + this.getId() + ", mainProduct=" + this.getMainProduct() + ", mainProductVariant=" + this.getMainProductVariant() + ", menuOption=" + this.getMenuOption() + ", additionalProductsLegacy=" + this.getAdditionalProductsLegacy() + ", additionalProducts=" + this.getAdditionalProducts() + ", subItems=" + this.getSubItems() + ", freeVariants=" + this.getFreeVariants() + ", affix=" + this.getAffix() + ", suffix=" + this.getSuffix() + ", subTotalPrice=" + this.getSubTotalPrice() + ", finalPrice=" + this.getFinalPrice() + ", discount=" + this.getDiscount() + ", quantity=" + this.getQuantity() + ", alternativeName=" + this.getAlternativeName() + ")";
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMainProduct(Product mainProduct) {
        this.mainProduct = mainProduct;
    }

    public void setMainProductVariant(ProductVariant mainProductVariant) {
        this.mainProductVariant = mainProductVariant;
    }

    public void setMenuOption(MenuOption menuOption) {
        this.menuOption = menuOption;
    }

    public void setAdditionalProductsLegacy(List<Product> additionalProductsLegacy) {
        this.additionalProductsLegacy = additionalProductsLegacy;
    }

    public void setAdditionalProducts(List<Product> additionalProducts) {
        this.additionalProducts = additionalProducts;
    }

    public void setSubItems(List<OrderItem> subItems) {
        this.subItems = subItems;
    }

    public void setAffix(String affix) {
        this.affix = affix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public void setAlternativeName(String alternativeName) {
        this.alternativeName = alternativeName;
    }
}

