/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.DeliveryAddressDTO;
import cz.polreich.spagetka.models.Order;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;

@Entity
@Table(name="deliveryAddresses")
public class DeliveryAddress {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @Column(name="id")
    private Integer id;
    @OneToOne(mappedBy="deliveryAddress")
    private Order order;
    private String streetAndNumber;
    private String city;
    private String zipCode;
    private String country;

    public DeliveryAddress(DeliveryAddressDTO dto) {
        this.streetAndNumber = dto.getStreet();
        this.city = dto.getCity();
        this.zipCode = dto.getZip();
        this.country = dto.getCountry();
    }

    public String toString() {
        return this.streetAndNumber + ", " + this.city + ", " + this.zipCode;
    }

    public Integer getId() {
        return this.id;
    }

    public Order getOrder() {
        return this.order;
    }

    public String getStreetAndNumber() {
        return this.streetAndNumber;
    }

    public String getCity() {
        return this.city;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public String getCountry() {
        return this.country;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public void setStreetAndNumber(String streetAndNumber) {
        this.streetAndNumber = streetAndNumber;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public DeliveryAddress() {
    }

    public DeliveryAddress(Integer id, Order order, String streetAndNumber, String city, String zipCode, String country) {
        this.id = id;
        this.order = order;
        this.streetAndNumber = streetAndNumber;
        this.city = city;
        this.zipCode = zipCode;
        this.country = country;
    }
}

